/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.controls;

import fr.gouv.finances.cp.utils.Pair;
import fr.gouv.finances.cp.utils.ui.DisplayExceptionDlg;
import fr.gouv.finances.cp.utils.xml.marshal.XmlOutputter;
import fr.gouv.finances.cp.xemelios.common.config.DocumentModel;
import fr.gouv.finances.cp.xemelios.common.config.DocumentsModel;
import fr.gouv.finances.cp.xemelios.controls.Anomalie;
import fr.gouv.finances.cp.xemelios.controls.ControlContentHandler;
import fr.gouv.finances.cp.xemelios.controls.ControlParser;
import fr.gouv.finances.cp.xemelios.controls.DlgControl;
import fr.gouv.finances.cp.xemelios.controls.IdGenerator;
import fr.gouv.finances.cp.xemelios.controls.SaxXmlWriter;
import fr.gouv.finances.cp.xemelios.controls.models.ControlsModel;
import fr.gouv.finances.cp.xemelios.controls.models.DocumentControlModel;
import fr.gouv.finances.cp.xemelios.controls.tech.XmlValidator;
import fr.gouv.finances.cp.xemelios.importers.EtatImporteur;
import fr.gouv.finances.cp.xemelios.ui.MainWindow;
import fr.gouv.finances.cp.xemelios.utils.FileUtils;
import java.awt.Frame;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainControl
implements Runnable {
    private static final Logger logger = Logger.getLogger(MainControl.class);
    private File cfgDir;
    private File fichierAController;
    private File rapport;
    private DocumentModel documentModel;
    private DocumentsModel docsModel;
    private Hashtable<String, Object> hashParams = new Hashtable();
    private DocumentControlModel dcm;
    private Date datecontrole;
    private NamespaceContext nameSpaces;
    private SaxXmlWriter saxWriter = new SaxXmlWriter();
    private String encodingValide;
    private String idDocumentRapport = "DocumentRapport";
    private ControlsModel cm;
    private String IDrapport = "";
    private String domainesControles = "";
    private DlgControl dlgControl = null;
    private Triplet triplet = null;

    public MainControl(DocumentModel dm, DocumentsModel docsMod) {
        this.documentModel = dm;
        this.docsModel = docsMod;
        this.cfgDir = new File(System.getProperty("xemelios.documents.def.dir"));
        this.cm = this.getControlsModel();
        this.dcm = this.cm.getDocumentById(dm.getId());
        this.nameSpaces = this.documentModel.getNamespaces();
        this.encodingValide = "ISO-8859-1";
    }

    public void setDlgControl(DlgControl dlgControl) {
        this.dlgControl = dlgControl;
    }

    public DocumentControlModel getDocumentControl() {
        return this.dcm;
    }

    @Override
    public void run() {
        SAXParserFactory factorySAX = SAXParserFactory.newInstance();
        factorySAX.setNamespaceAware(true);
        ControlContentHandler cch = new ControlContentHandler(this.documentModel, this.dcm, this.hashParams, MainWindow.instance, this.fichierAController.getName());
        cch.setParameters(this.hashParams);
        cch.setControlsModel(this.dcm.getControls());
        cch.setDlgControl(this.dlgControl);
        File tmpDir = new File(System.getProperty("java.io.tmpdir"), "XEMELIOS");
        if (!tmpDir.exists()) {
            tmpDir.mkdirs();
        }
        try {
            XmlValidator xmlValidator = new XmlValidator(new File(System.getProperty("xemelios.documents.def.dir"), this.dcm.schemaLocation).getPath(), this.nameSpaces.getNamespaceURI(""), this.dcm.id, this.documentModel);
            xmlValidator.setDlgControl(this.dlgControl);
            logger.debug((Object)("URL sch\u00e9ma : " + new File(System.getProperty("xemelios.documents.def.dir"), this.dcm.schemaLocation).getPath()));
            this.rapport = new File(tmpDir, "rapport" + this.fichierAController.getName());
            FileOutputStream fos = new FileOutputStream(this.rapport);
            this.datecontrole = new Date();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            DocumentModel dmRapport = this.docsModel.getDocumentById(this.idDocumentRapport);
            if (xmlValidator.doValidationSyntaxe(this.fichierAController)) {
                if (FileUtils.getFileEncoding(this.fichierAController).toUpperCase().equals(this.encodingValide)) {
                    if ("true".equals(System.getProperty("xemelios.control.skipSchemaValidation")) || xmlValidator.doValidationSchema(this.fichierAController)) {
                        String[] tabDomaines = xmlValidator.domainesControles.split(",");
                        StringBuffer sb = new StringBuffer();
                        int i = 0;
                        for (String s : tabDomaines) {
                            if (++i == tabDomaines.length) {
                                sb.append(s);
                                continue;
                            }
                            sb.append(s + " / ");
                        }
                        this.domainesControles = sb.toString();
                        FileInputStream fis = new FileInputStream(this.fichierAController);
                        SAXParser parserXml = factorySAX.newSAXParser();
                        this.saxWriter.setNamespaceContext(this.nameSpaces);
                        File fichierEnrichi = new File(tmpDir, this.fichierAController.getName());
                        StreamResult sr = new StreamResult(fichierEnrichi);
                        this.saxWriter.setResult(sr);
                        cch.setSaxWriter(this.saxWriter);
                        cch.setNamespaceContext(this.nameSpaces);
                        parserXml.parse((InputStream)fis, (DefaultHandler)cch);
                        sr.getOutputStream().flush();
                        sr.getOutputStream().close();
                        fis.close();
                        this.dlgControl.stopVentilateur();
                        fos.write(this.doEnteteRapport(sdf.format(this.datecontrole), cch.collectivite, cch.budget, cch.getVTotalAnomalies(), cch.MAX_ANOS));
                        this.triplet = new Triplet(this.IDrapport, cch.collectivite.key, cch.budget.key);
                        for (Anomalie ano : cch.getVTotalAnomalies()) {
                            fos.write(this.doDataRapport(ano));
                        }
                        fos.write(this.doPied());
                        if (!cch.importInterupted) {
                            if (cch.getVTotalAnomalies().size() <= 0) {
                                int reponse = JOptionPane.showConfirmDialog(MainWindow.instance, "Le fichier " + this.fichierAController.getName() + " ne comporte pas d'anomalies.\nSouhaitez-vous quand m\u00eame l'importer?", "Question", 0);
                                if (0 == reponse) {
                                    this.importer(this.documentModel, cch.collectivite, cch.budget, fichierEnrichi, false);
                                    this.importer(dmRapport, cch.collectivite, cch.budget, this.rapport, true);
                                } else {
                                    this.dlgControl.notifyImportFinished(null);
                                }
                            } else {
                                this.importer(this.documentModel, cch.collectivite, cch.budget, fichierEnrichi, false);
                                this.importer(dmRapport, cch.collectivite, cch.budget, this.rapport, true);
                            }
                        }
                    } else if (!xmlValidator.getExceptionOccurs()) {
                        logger.info((Object)("Le fichier " + this.fichierAController.getName() + " n'est pas conforme au schema de " + this.dcm.id));
                        fos.write(this.doEnteteRapport(sdf.format(this.datecontrole), new Pair("00000000000000", "Collectivite de Contr\u00f4le"), new Pair("00", "Budget de Contr\u00f4le"), null, 0));
                        for (Anomalie ano : xmlValidator.anos) {
                            fos.write(this.doDataRapport(ano));
                        }
                        fos.write(this.doPied());
                        this.triplet = new Triplet(this.IDrapport, "00000000000000", "00");
                        this.importer(dmRapport, new Pair("00000000000000", "Collectivite de Contr\u00f4le"), new Pair("00", "Budget de Contr\u00f4le"), this.rapport, true);
                    } else {
                        DisplayExceptionDlg dlgEx = new DisplayExceptionDlg((Frame)MainWindow.getInstance(), (Throwable)xmlValidator.getExceptionSaxe());
                        this.dlgControl.notifyTechniqueValidationFailed();
                        dlgEx.setVisible(true);
                    }
                } else {
                    logger.info((Object)("Le fichier " + this.fichierAController.getName() + " n'est pas encod\u00e9 en " + this.encodingValide + "."));
                    fos.write(this.doEnteteRapport(sdf.format(this.datecontrole), new Pair("00000000000000", "Collectivite de Contr\u00f4le"), new Pair("00", "Budget de Contr\u00f4le"), null, 0));
                    fos.write(this.doDataRapport(new Anomalie(IdGenerator.nextId(), "TECH02", "Contr\u00f4le de l'encoding du fichier.", this.documentModel.getId(), xmlValidator.domainesControles, "", "", "", "", "Le fichier doit \u00eatre encod\u00e9 en ISO-8859-1.", "Le fichier doit \u00eatre encod\u00e9 en ISO-8859-1.", "BLOQUANT", "xpath namespacise", new Hashtable<String, Object>())));
                    fos.write(this.doPied());
                    this.triplet = new Triplet(this.IDrapport, "00000000000000", "00");
                    this.importer(dmRapport, new Pair("00000000000000", "Collectivite de Contr\u00f4le"), new Pair("00", "Budget de Contr\u00f4le"), this.rapport, true);
                }
            } else {
                logger.info((Object)("Le fichier " + this.fichierAController.getName() + " n'est pas un fichier XML valide."));
                fos.write(this.doEnteteRapport(sdf.format(this.datecontrole), new Pair("00000000000000", "Collectivite de Contr\u00f4le"), new Pair("00", "Budget de Contr\u00f4le"), null, 0));
                for (Anomalie ano : xmlValidator.anos) {
                    logger.debug((Object)this.doDataRapport(ano));
                    fos.write(this.doDataRapport(ano));
                }
                fos.write(this.doPied());
                this.triplet = new Triplet(this.IDrapport, "00000000000000", "00");
                this.importer(dmRapport, new Pair("00000000000000", "Collectivite de Contr\u00f4le"), new Pair("00", "Budget de Contr\u00f4le"), this.rapport, true);
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private ControlsModel getControlsModel() {
        ControlsModel ret = null;
        try {
            ControlParser cp = new ControlParser();
            cp.parse(new File(this.cfgDir, this.documentModel.getControlConfigFile()));
            ControlsModel c = (ControlsModel)cp.getMarshallable();
            c.validate();
            ret = c;
        }
        catch (Exception ex) {
            logger.debug((Object)"Error in getControlsModel()!!!", (Throwable)ex);
        }
        return ret;
    }

    public byte[] doEnteteRapport(String datectrl, Pair collec, Pair bud, Vector<Anomalie> vano, int maxanos) {
        String msgAno = "";
        msgAno = vano != null && vano.size() >= maxanos ? "true" : "false";
        this.IDrapport = this.datecontrole.getTime() + this.rapport.getName();
        String entete = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n<ano:DocumentRapport xmlns:ano=\"http://projets.admisource.gouv.fr/xemelios/namespaces#anomally\" xmlns:n=\"http://projets.admisource.gouv.fr/xemelios/namespaces#anomally\">\n<ano:DocId ano:V=\"" + this.documentModel.getId() + "\"/>\n" + "<ano:NomFichier ano:V=\"" + this.fichierAController.getName() + "\"/>\n" + "<ano:DateControle ano:V=\"" + datectrl + "\"/>\n" + "<ano:Collectivite>\n<ano:Siret ano:V=\"" + collec.key + "\"/>\n<ano:Libelle ano:V=\"" + collec.libelle + "\"/>\n</ano:Collectivite>\n" + "<ano:Budget>\n<ano:Code ano:V=\"" + bud.key + "\"/>\n<ano:Libelle ano:V=\"" + bud.libelle + "\"/>\n</ano:Budget>\n" + "<ano:TropAnos ano:V=\"" + msgAno + "\"/>" + "<ano:Domaines ano:V=\"" + this.domainesControles + "\"/>" + "<ano:DonneesRapport>\n<ano:Rapport>\n" + "<ano:Id ano:V=\"" + this.IDrapport + "\"/>\n";
        return entete.getBytes();
    }

    public byte[] doDataRapport(Anomalie a) {
        StringBuffer sb = new StringBuffer();
        sb.append("<ano:Anomalie>\n");
        sb.append("<ano:Id ano:V=\"" + a.getIdAnomalie() + "\"/>\n");
        sb.append("<ano:IdCtrl ano:V=\"" + a.getControleID() + "\"/>\n");
        sb.append("<ano:LibelleCtrl ano:V=\"" + a.getControleLibelle() + "\"/>\n");
        sb.append("<ano:EtatId ano:V=\"" + a.getEtatID() + "\"/>\n");
        sb.append("<ano:ElementImportable ano:V=\"" + a.getelementImportable() + "\"/>\n");
        sb.append("<ano:IdElementImportable ano:V=\"" + a.getIdElementImportable() + "\"/>\n");
        sb.append("<ano:ElementEnAnomalie ano:V=\"" + a.getelementEnAnomalie() + "\"/>\n");
        sb.append("<ano:LibelleLien ano:V=\"" + a.getLibelleLien() + "\"/>\n");
        sb.append("<ano:Message>" + a.getMessage().replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("&", "&amp;") + "</ano:Message>\n");
        sb.append("<ano:Regle>" + a.getRegle().replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("&", "&amp;") + "</ano:Regle>\n");
        sb.append("<ano:Severity ano:V=\"" + a.getSeverity() + "\"/>\n");
        sb.append("<ano:XPath ano:V=\"" + a.getXPath() + "\"/>\n");
        if (a.getXslParams() != null && a.getXslParams().size() > 0) {
            for (String key : a.getXslParams().keySet()) {
                String value = a.getXslParams().get(key).toString();
                sb.append("<ano:XslParam>\n<ano:Key ano:V=\"" + key + "\"/>\n<ano:Value ano:V=\"" + value + "\"/>\n</ano:XslParam>");
            }
        }
        sb.append("</ano:Anomalie>\n");
        return sb.toString().getBytes();
    }

    public byte[] doPied() {
        StringBuffer sb = new StringBuffer("</ano:Rapport>\n");
        sb.append("</ano:DonneesRapport>\n");
        sb.append("</ano:DocumentRapport>");
        return sb.toString().getBytes();
    }

    public void setFileToControl(File f) {
        this.fichierAController = f;
    }

    public void setParameters(Hashtable<String, Object> params) {
        this.hashParams = params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importer(DocumentModel dm, Pair coll, Pair budg, File f, boolean isRapport) {
        block6: {
            try {
                Class<?> clazz = Class.forName(dm.getImportClass());
                Object obj = clazz.newInstance();
                if (!(obj instanceof EtatImporteur)) {
                    JOptionPane.showMessageDialog(MainWindow.instance, "Cette classe n'est pas un importeur.\nLe fichier de configuration qui vous a \u00e9t\u00e9 livr\u00e9 est certainement invalide.\nVeuillez contacter votre fournisseur.\n", "Erreur", 0);
                    return;
                }
                EtatImporteur ei = (EtatImporteur)((Object)obj);
                ei.setDocument(dm, coll, budg);
                ArrayList<File> array = new ArrayList<File>();
                array.add(f);
                MainWindow.ImportContent fToImport = new MainWindow.ImportContent();
                fToImport.setFilesToImport(array);
                if (isRapport) {
                    MainWindow.instance.doImport(ei, fToImport, dm, this.dlgControl, this.triplet, true);
                    break block6;
                }
                MainWindow.instance.doImport(ei, fToImport, dm, true);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    void writeControlConfigFile() throws IOException {
        File output = new File(this.cfgDir, this.documentModel.getControlConfigFile());
        XmlOutputter outputter = new XmlOutputter((OutputStream)new FileOutputStream(output), "ISO-8859-1");
        this.cm.marshall(outputter);
    }

    public class Triplet {
        public String iDrapport;
        public String codeCollectivite;
        public String codeBudget;

        public Triplet(String idRapport, String codColl, String codBud) {
            this.iDrapport = idRapport;
            this.codeCollectivite = codColl;
            this.codeBudget = codBud;
        }
    }
}

