/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.controls;

import fr.gouv.finances.cp.utils.Pair;
import fr.gouv.finances.cp.utils.ui.InfiniteGlassPane;
import fr.gouv.finances.cp.xemelios.common.config.DocumentModel;
import fr.gouv.finances.cp.xemelios.controls.DlgEditParam;
import fr.gouv.finances.cp.xemelios.controls.MainControl;
import fr.gouv.finances.cp.xemelios.controls.models.OptionModel;
import fr.gouv.finances.cp.xemelios.controls.models.ParamModel;
import fr.gouv.finances.cp.xemelios.ui.HtmlViewer;
import fr.gouv.finances.cp.xemelios.ui.MainWindow;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.DefaultCellEditor;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.text.Keymap;
import org.apache.log4j.Logger;
import org.jdesktop.layout.GroupLayout;
import org.jdesktop.swingx.JXTable;

public class DlgControl
extends JDialog {
    private static final Logger logger = Logger.getLogger(DlgControl.class);
    private DocumentModel documentModel;
    private MainControl mc;
    private static String lastInputDirectory;
    private AbstractAction escapeAction;
    private MainControl.Triplet triplet;
    private JTextField dfFileToImport;
    private JScrollPane jScrollPane1;
    private JButton pbCancel;
    private JButton pbOk;
    private JXTable table;

    public DlgControl(Frame parent, DocumentModel documentModel, MainControl mc) {
        super(parent, false);
        this.documentModel = documentModel;
        this.mc = mc;
        this.initComponents();
        InfiniteGlassPane glassPane = new InfiniteGlassPane();
        this.setGlassPane(glassPane);
        mc.setDlgControl(this);
        this.table.packAll();
        this.setLocationRelativeTo(this.getParent());
        this.pbOk.setDefaultCapable(true);
        this.getRootPane().setDefaultButton(this.pbOk);
    }

    protected JRootPane createRootPane() {
        KeyStroke ks = KeyStroke.getKeyStroke(27, 0);
        JRootPane rp = new JRootPane();
        this.escapeAction = new AbstractAction("Annuler"){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent evt) {
                DlgControl.this.cancel(evt);
            }
        };
        rp.registerKeyboardAction(this.escapeAction, "TOTOTOTO", ks, 2);
        return rp;
    }

    private void initComponents() {
        JLabel lblFileToImport = new JLabel();
        JButton pbBrowse = new JButton();
        this.dfFileToImport = new JTextField();
        JLabel lblParams = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.table = new JParamTable(this.createModel());
        this.pbOk = new JButton();
        this.pbCancel = new JButton();
        this.setTitle("Contr\u00f4ler un flux");
        lblFileToImport.setText("Fichier \u00e0 importer");
        pbBrowse.setText("...");
        pbBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DlgControl.this.browse(evt);
            }
        });
        lblParams.setText("Param\u00e8tres");
        this.table.setModel(this.createModel());
        this.table.setSortable(false);
        this.jScrollPane1.setViewportView((Component)this.table);
        this.pbOk.setText("Ok");
        this.pbOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DlgControl.this.doControl(evt);
            }
        });
        this.pbCancel.setText("Annuler");
        this.pbCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DlgControl.this.cancel(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.jScrollPane1, -1, 482, Short.MAX_VALUE).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.pbCancel).addPreferredGap(0).add((Component)this.pbOk)).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.dfFileToImport, -1, 433, Short.MAX_VALUE).addPreferredGap(0).add((Component)pbBrowse)))).add((GroupLayout.Group)layout.createSequentialGroup().add(12, 12, 12).add((Component)lblFileToImport)).add((GroupLayout.Group)layout.createSequentialGroup().add(12, 12, 12).add((Component)lblParams))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)lblFileToImport).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.dfFileToImport, -2, -1, -2).add((Component)pbBrowse)).addPreferredGap(0).add((Component)lblParams).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 257, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.pbOk).add((Component)this.pbCancel)).addContainerGap()));
        this.pack();
    }

    private void cancel(ActionEvent evt) {
        this.setVisible(false);
    }

    private void doControl(ActionEvent evt) {
        if (this.doChecks()) {
            try {
                this.mc.writeControlConfigFile();
            }
            catch (IOException ioEx) {
                logger.error((Object)"while writting control config file", (Throwable)ioEx);
            }
            this.runControl();
        }
    }

    private void displayRapport(MainControl.Triplet infoRapport) {
        StringBuffer uri = new StringBuffer();
        uri.append("xemelios:/query?collectivite=").append(infoRapport.codeCollectivite).append("&budget=").append(infoRapport.codeBudget);
        uri.append("&docId=DocumentRapport&etatId=DonneesRapport&path=[n:Id/@n:V='").append(infoRapport.iDrapport).append("']");
        MainWindow mw = (MainWindow)this.getParent();
        HtmlViewer viewer = new HtmlViewer(uri.toString(), "Rapport de contr\u00f4le", mw);
        mw.getDesk().add(viewer);
        mw.getDesk().getDesktopManager().maximizeFrame(viewer);
        viewer.show();
    }

    private void browse(ActionEvent evt) {
        JFileChooser fc = new JFileChooser();
        fc.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory() || f.getName().toUpperCase().endsWith("XML");
            }

            public String getDescription() {
                return "Fichiers XML";
            }
        });
        if (this.documentModel.getExtension() != null) {
            fc.addChoosableFileFilter(new FileFilter(){

                public boolean accept(File f) {
                    return f.isDirectory() || f.getName().toUpperCase().endsWith(DlgControl.this.documentModel.getExtension().toUpperCase());
                }

                public String getDescription() {
                    return DlgControl.this.documentModel.getLibelleExtension();
                }
            });
        }
        if (lastInputDirectory != null) {
            try {
                fc.setCurrentDirectory(new File(lastInputDirectory));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (fc.showOpenDialog(this) == 0) {
            this.dfFileToImport.setText(fc.getSelectedFile().getAbsolutePath());
            lastInputDirectory = fc.getSelectedFile().getParent();
        }
    }

    private boolean doChecks() {
        if (this.dfFileToImport.getText() == null || this.dfFileToImport.getText().length() == 0) {
            JOptionPane.showMessageDialog(this, "Le fichier \u00e0 importer est obligatoire", "Erreur", 0);
            this.dfFileToImport.grabFocus();
            return false;
        }
        for (ParamModel pm : this.mc.getDocumentControl().getParams()) {
            if (pm.isOptional() || pm.getValue() != null) continue;
            JOptionPane.showMessageDialog(this, "Le param\u00e8tre " + pm.getName() + " est obligatoire.", "Erreur", 0);
            return false;
        }
        return true;
    }

    private void runControl() {
        this.mc.setFileToControl(new File(this.dfFileToImport.getText()));
        Hashtable<String, Object> params = new Hashtable<String, Object>();
        for (ParamModel pm : this.mc.getDocumentControl().getParams()) {
            String[] value = null;
            if (pm.getValue() == null) {
                logger.debug((Object)(pm.getName() + " has no value"));
                continue;
            }
            if (pm.getSelect() != null && pm.getSelect().isMultiValued()) {
                StringTokenizer tokenizer = new StringTokenizer((String)pm.getValue(), " ");
                int count = tokenizer.countTokens();
                String[] values = new String[count];
                for (int i = 0; i < count; ++i) {
                    values[i] = tokenizer.nextToken();
                }
                value = values;
            } else {
                value = pm.getValue();
            }
            params.put(pm.getId(), value);
            logger.debug((Object)("param -> " + pm.getId() + " : " + value.toString()));
        }
        this.mc.setParameters(params);
        this.getGlassPane().setVisible(true);
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                logger.debug((Object)"invoke later");
                SwingUtilities.invokeLater(this.mc);
            } else {
                logger.debug((Object)"invoke now");
                this.mc.run();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void stopVentilateur() {
        this.getGlassPane().setVisible(false);
    }

    public void startVentilateur() {
        this.getGlassPane().setVisible(true);
    }

    public void notifyImportFailed() {
        JOptionPane.showMessageDialog(this, "L'import du rapport a \u00e9chou\u00e9.", "", 64);
        this.setVisible(false);
    }

    public void notifyImportInterupted() {
        JOptionPane.showMessageDialog(this, "L'import du rapport a \u00e9t\u00e9 imterrompu.", "", 2);
        this.stopVentilateur();
    }

    public void notifyTechniqueValidationFailed() {
        this.setVisible(false);
    }

    public void notifyImportFinished(MainControl.Triplet triplet) {
        if (triplet != null) {
            this.displayRapport(triplet);
        }
        this.setVisible(false);
    }

    private TableModel createModel() {
        return new ParamTableModel(null);
    }

    private class ButtonEditParam
    extends JButton {
        private final ParamModel pm;
        private JComboBox cbx;
        private JTextField df;

        private ButtonEditParam(ParamModel pm) {
            super("...");
            this.pm = pm;
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ButtonEditParam.this.doEdit();
                }
            });
        }

        public ButtonEditParam(ParamModel pm, JComboBox cbx) {
            this(pm);
            this.cbx = cbx;
        }

        public ButtonEditParam(ParamModel pm, JTextField df) {
            this(pm);
            this.df = df;
        }

        private void doEdit() {
            DlgEditParam dep = new DlgEditParam((Dialog)DlgControl.this, this.pm);
            dep.setVisible(true);
            if (this.cbx != null) {
                Object value = this.cbx.getSelectedItem();
                this.cbx.removeAllItems();
                int selectedItem = -1;
                for (OptionModel om : this.pm.getSelect().getOptions()) {
                    this.cbx.addItem(new Pair(om.getValue(), om.getLibelle()));
                    if (value == null || !om.getValue().equals(value)) continue;
                    selectedItem = this.cbx.getItemCount() - 1;
                }
                if (selectedItem != -1) {
                    this.cbx.setSelectedIndex(selectedItem);
                }
            } else if (this.df != null) {
                this.df.setText(this.pm.getValue().toString());
            }
        }
    }

    public class MyCellEditor
    extends DefaultCellEditor {
        private DefaultCellEditor chkEditor;
        private DefaultCellEditor cbxEditor;
        private DefaultCellEditor dfEditor;
        private DefaultCellEditor currentEditor;
        private JComponent editorComponent;
        private ParamTableModel ptm;
        private PopupMenuListener cbxPopupListener;
        private FocusListener chkFocusListener;

        public MyCellEditor(ParamTableModel ptm) {
            super(new JTextField());
            this.chkEditor = new DefaultCellEditor(new JCheckBox());
            this.cbxEditor = new DefaultCellEditor(new JComboBox());
            this.dfEditor = new DefaultCellEditor(new JTextField());
            this.setClickCountToStart(1);
            this.ptm = ptm;
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            JComponent ret;
            ParamModel pm = this.ptm.getParam(row);
            if (pm.getSelect() != null && !pm.getSelect().isMultiValued()) {
                JComboBox cbx = (JComboBox)this.cbxEditor.getTableCellEditorComponent(table, value, isSelected, row, column);
                this.editorComponent = cbx;
                if (this.cbxPopupListener == null) {
                    this.cbxPopupListener = new PopupMenuListener(){

                        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                        }

                        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                            MyCellEditor.this.stopCellEditing();
                        }

                        public void popupMenuCanceled(PopupMenuEvent e) {
                        }
                    };
                    cbx.addPopupMenuListener(this.cbxPopupListener);
                }
                cbx.removeAllItems();
                int selectedItem = -1;
                for (OptionModel om : pm.getSelect().getOptions()) {
                    cbx.addItem(new Pair(om.getValue(), om.getLibelle()));
                    if (value == null || !om.getValue().equals(value)) continue;
                    selectedItem = cbx.getItemCount() - 1;
                }
                if (selectedItem != -1) {
                    cbx.setSelectedIndex(selectedItem);
                }
                ret = cbx;
                this.currentEditor = this.cbxEditor;
            } else if ("boolean".equals(pm.getDatatype())) {
                JCheckBox chk = (JCheckBox)this.chkEditor.getTableCellEditorComponent(table, value, isSelected, row, column);
                chk.setHorizontalAlignment(0);
                chk.setBackground(table.getCellRenderer(row, column).getTableCellRendererComponent(table, value, isSelected, DlgControl.this.hasFocus(), row, column).getBackground());
                if (this.chkFocusListener == null) {
                    this.chkFocusListener = new FocusListener(){

                        public void focusGained(FocusEvent e) {
                        }

                        public void focusLost(FocusEvent e) {
                            MyCellEditor.this.stopCellEditing();
                        }
                    };
                    chk.addFocusListener(this.chkFocusListener);
                }
                ret = chk;
                this.currentEditor = this.chkEditor;
                this.editorComponent = chk;
            } else {
                JTextField df = (JTextField)this.dfEditor.getTableCellEditorComponent(table, value, isSelected, row, column);
                Keymap km = df.getKeymap();
                if (km.getAction(KeyStroke.getKeyStroke('\n')) == null) {
                    km.addActionForKeyStroke(KeyStroke.getKeyStroke('\n'), new AbstractAction(){

                        public void actionPerformed(ActionEvent e) {
                            MyCellEditor.this.stopCellEditing();
                        }
                    });
                }
                ret = df;
                this.currentEditor = this.dfEditor;
                this.editorComponent = df;
            }
            if (pm.getSelect() != null && (pm.getSelect().isMultiValued() || pm.getSelect().isEditable())) {
                final ButtonEditParam pbEdit = ret instanceof JComboBox ? new ButtonEditParam(pm, (JComboBox)ret) : new ButtonEditParam(pm, (JTextField)ret);
                double height = table.getRowHeight();
                pbEdit.setSize((int)height, (int)height);
                JPanel pane = new JPanel();
                GroupLayout layout = new GroupLayout((Container)pane);
                pane.setLayout((LayoutManager)layout);
                layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)ret, (int)height, 100, Short.MAX_VALUE).add((Component)pbEdit, (int)height, (int)height, (int)height)));
                layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)pbEdit, (int)height, (int)height, Short.MAX_VALUE).add((Component)ret, (int)height, (int)height, (int)height)));
                ret.addFocusListener(new FocusListener(){

                    public void focusGained(FocusEvent e) {
                    }

                    public void focusLost(FocusEvent e) {
                        MyCellEditor.this.stopCellEditing();
                    }
                });
                pane.addFocusListener(new FocusListener(){

                    public void focusGained(FocusEvent e) {
                        MyCellEditor.this.editorComponent.grabFocus();
                    }

                    public void focusLost(FocusEvent e) {
                    }
                });
                InputMap iMap = pane.getInputMap();
                String actionKey = "helpButton";
                iMap.put(KeyStroke.getKeyStroke(114, 0), actionKey);
                ActionMap am = pane.getActionMap();
                am.put(actionKey, new AbstractAction(){

                    public void actionPerformed(ActionEvent e) {
                        pbEdit.doClick();
                    }
                });
                ret = pane;
            }
            return ret;
        }

        public void setModel(ParamTableModel ptm) {
            this.ptm = ptm;
        }

        public Object getCellEditorValue() {
            return this.currentEditor.getCellEditorValue();
        }
    }

    public class MyCellRenderer
    extends DefaultTableCellRenderer {
        private ParamTableModel ptm;

        public MyCellRenderer(ParamTableModel ptm) {
            this.ptm = ptm;
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component ret;
            if (column == 0) {
                ret = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                JLabel lbl = (JLabel)ret;
                lbl.setHorizontalAlignment(2);
            } else {
                ParamModel pm = this.ptm.getParam(row);
                Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if ("string".equals(pm.getDatatype()) || "integer".equals(pm.getDatatype()) || "decimal".equals(pm.getDatatype()) || "date".equals(pm.getDatatype())) {
                    JLabel lbl = (JLabel)c;
                    if (pm.getValue() == null) {
                        lbl.setText("");
                    } else {
                        lbl.setText(pm.getValue().toString());
                    }
                    if ("integer".equals(pm.getDatatype()) || "decimal".equals(pm.getDatatype())) {
                        lbl.setHorizontalAlignment(4);
                    } else {
                        lbl.setHorizontalAlignment(2);
                    }
                    ret = lbl;
                } else if ("boolean".equals(pm.getDatatype())) {
                    JCheckBox chk = new JCheckBox();
                    chk.setBackground(c.getBackground());
                    chk.setHorizontalAlignment(0);
                    if (pm.getValue() != null && pm.getValue() instanceof Boolean) {
                        Boolean b = (Boolean)pm.getValue();
                        chk.setSelected(b);
                    }
                    ret = chk;
                } else {
                    ret = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                }
                if (pm.getSelect() != null && (pm.getSelect().isMultiValued() || pm.getSelect().isEditable())) {
                    final ButtonEditParam pbEdit = new ButtonEditParam(pm);
                    double height = table.getRowHeight();
                    pbEdit.setSize((int)height, (int)height);
                    JPanel pane = new JPanel();
                    GroupLayout layout = new GroupLayout((Container)pane);
                    pane.setLayout((LayoutManager)layout);
                    layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add(ret, (int)height, 100, Short.MAX_VALUE).add((Component)pbEdit, (int)height, (int)height, (int)height)));
                    layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)pbEdit, (int)height, (int)height, Short.MAX_VALUE).add(ret, (int)height, (int)height, (int)height)));
                    InputMap iMap = pane.getInputMap();
                    String actionKey = "helpButton";
                    iMap.put(KeyStroke.getKeyStroke(114, 0), actionKey);
                    ActionMap am = pane.getActionMap();
                    am.put(actionKey, new AbstractAction(){

                        public void actionPerformed(ActionEvent e) {
                            pbEdit.doClick();
                        }
                    });
                    ret = pane;
                }
            }
            return ret;
        }

        public void setModel(ParamTableModel tpm) {
            this.ptm = tpm;
        }
    }

    private class JParamTable
    extends JXTable {
        private MyCellRenderer cellRenderer;
        private MyCellEditor cellEditor;

        public JParamTable(TableModel model) {
            super(model);
            if (model instanceof ParamTableModel) {
                this.cellRenderer = new MyCellRenderer((ParamTableModel)model);
                this.cellEditor = new MyCellEditor((ParamTableModel)model);
            }
        }

        public JParamTable() {
            this.cellRenderer = new MyCellRenderer(null);
        }

        public TableCellEditor getCellEditor(int row, int column) {
            return this.cellEditor;
        }

        public TableCellRenderer getCellRenderer(int row, int column) {
            return this.cellRenderer;
        }

        public void setModel(TableModel tableModel) {
            super.setModel(tableModel);
            if (tableModel != null && tableModel instanceof ParamTableModel && this.cellRenderer != null) {
                this.cellRenderer.setModel((ParamTableModel)tableModel);
                this.cellEditor.setModel((ParamTableModel)tableModel);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ParamTableModel
    implements TableModel {
        private Vector<ParamModel> params;

        public ParamTableModel(Hashtable<String, Object> existingParams) {
            this.params = DlgControl.this.mc.getDocumentControl().getParams();
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            ParamModel pm = this.getParam(rowIndex);
            if (columnIndex == 1) {
                pm.setValue(aValue);
            }
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return "Param\u00e8tre";
            }
            return "Valeur";
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            ParamModel pm = this.params.get(rowIndex);
            if (columnIndex == 0) {
                return pm.getName();
            }
            if (columnIndex == 1) {
                return pm.getValue();
            }
            return "";
        }

        @Override
        public int getRowCount() {
            return this.params.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        public ParamModel getParam(int rowIndex) {
            return this.params.get(rowIndex);
        }
    }
}

