/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.common.config;

import fr.gouv.finances.cp.utils.xml.marshal.InvalidXmlDefinition;
import fr.gouv.finances.cp.utils.xml.marshal.XmlAttributes;
import fr.gouv.finances.cp.utils.xml.marshal.XmlMarshallable;
import fr.gouv.finances.cp.utils.xml.marshal.XmlOutputter;
import fr.gouv.finances.cp.xemelios.common.config.OptionModel;
import java.util.Vector;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpecialKeyModel
implements XmlMarshallable,
Comparable {
    public static final transient String TAG = "special-key";
    private int pos = 0;
    private String libelle;
    private String path;
    private String transform;
    private Vector<OptionModel> descriptions = new Vector();

    public SpecialKeyModel(String tagName) {
    }

    public void addCharacterData(String cData) throws SAXException {
    }

    public void addChild(XmlMarshallable child, String tagName) throws SAXException {
        this.descriptions.add((OptionModel)child);
    }

    public XmlMarshallable getAttributes(XmlAttributes attributes) throws SAXException {
        this.pos = attributes.getIntValue("pos");
        this.libelle = attributes.getValue("libelle");
        this.path = attributes.getValue("path");
        this.transform = attributes.getValue("transform");
        return this;
    }

    public void marshall(XmlOutputter output) {
        throw new Error("Not yet implemented");
    }

    public void validate() throws InvalidXmlDefinition {
    }

    public String getLibelle() {
        return this.libelle;
    }

    public String getPath() {
        return this.path;
    }

    public int getPos() {
        return this.pos;
    }

    public SpecialKeyModel clone() {
        SpecialKeyModel dfm = new SpecialKeyModel(TAG);
        dfm.pos = this.pos;
        dfm.libelle = this.libelle;
        dfm.path = this.path;
        dfm.transform = this.transform;
        dfm.descriptions.addAll(this.descriptions);
        return dfm;
    }

    public Vector<OptionModel> getDescriptions() {
        return this.descriptions;
    }

    public String getTransform() {
        return this.transform;
    }

    public int compareTo(Object o) {
        if (o == this) {
            return 0;
        }
        if (o instanceof SpecialKeyModel) {
            SpecialKeyModel other = (SpecialKeyModel)o;
            if (this.pos < other.pos) {
                return -1;
            }
            if (this.pos == other.pos) {
                return 0;
            }
            return 1;
        }
        return 0;
    }

    public String transformValue(String value) {
        String ret = value;
        if ("normalizeMonth".equals(this.transform)) {
            int i = Integer.parseInt(value);
            if (i < 10) {
                return "0" + Integer.toString(i);
            }
            ret = Integer.toString(i);
        } else if ("Identity".equals(this.transform)) {
            ret = value;
        }
        if ("UpperCase".equals(this.transform)) {
            ret = value.toUpperCase();
        }
        if ("LowerCase".equals(this.transform)) {
            ret = value.toLowerCase();
        }
        return ret;
    }

    public String getDescriptionOfValue(String value) {
        for (OptionModel om : this.descriptions) {
            if (!om.getValue().equals(value)) continue;
            return om.getLibelle();
        }
        return value;
    }
}

