/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.common.config;

import fr.gouv.finances.cp.utils.Pair;
import fr.gouv.finances.cp.utils.xml.marshal.InvalidXmlDefinition;
import fr.gouv.finances.cp.utils.xml.marshal.XmlAttributes;
import fr.gouv.finances.cp.utils.xml.marshal.XmlMarshallable;
import fr.gouv.finances.cp.utils.xml.marshal.XmlOutputter;
import fr.gouv.finances.cp.xemelios.common.config.OptionModel;
import fr.gouv.finances.cp.xemelios.common.config.RecherchePaireModel;
import fr.gouv.finances.cp.xemelios.common.config.SpecialKeyEntryModel;
import java.util.Collection;
import java.util.Comparator;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.commons.lang.StringEscapeUtils;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectModel
implements XmlMarshallable {
    public static final transient String TAG = "select";
    public static final int SORT_NO = 0;
    public static final int SORT_KEY = 1;
    public static final int SORT_LIB = 2;
    private Vector<OptionModel> options = new Vector();
    private String id;
    private String libelle;
    private String value;
    private Vector<RecherchePaireModel> recherches = new Vector();
    private Vector<SpecialKeyEntryModel> specialKeys = new Vector();
    private String sort = "no";

    public SelectModel(String tagName) {
    }

    public void addCharacterData(String cData) throws SAXException {
    }

    public void addChild(XmlMarshallable child, String tagName) throws SAXException {
        if ("option".equals(tagName)) {
            this.options.add((OptionModel)child);
        } else if ("recherche-paire".equals(tagName)) {
            this.recherches.add((RecherchePaireModel)child);
        } else if ("special-key-entry".equals(tagName)) {
            this.specialKeys.add((SpecialKeyEntryModel)child);
        }
    }

    public XmlMarshallable getAttributes(XmlAttributes attributes) throws SAXException {
        this.id = attributes.getValue("id");
        this.libelle = attributes.getValue("libelle");
        this.value = attributes.getValue("value");
        this.sort = attributes.getValue("sort");
        return this;
    }

    public void marshall(XmlOutputter output) {
        output.startTag(TAG);
        output.addAttribute("id", this.id);
        output.addAttribute("sort", this.sort);
        if (this.libelle != null) {
            output.addAttribute("libelle", StringEscapeUtils.escapeXml(this.libelle));
        }
        for (OptionModel om : this.options) {
            om.marshall(output);
        }
        for (RecherchePaireModel rpm : this.recherches) {
            rpm.marshall(output);
        }
        output.endTag(TAG);
    }

    public void validate() throws InvalidXmlDefinition {
        for (OptionModel om : this.options) {
            om.validate();
        }
        for (RecherchePaireModel rpm : this.recherches) {
            rpm.validate();
        }
    }

    public String getId() {
        return this.id;
    }

    public String getLibelle() {
        return this.libelle;
    }

    public Vector<OptionModel> getOptions() {
        return this.options;
    }

    public Vector<RecherchePaireModel> getRecherches() {
        return this.recherches;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public SelectModel clone() {
        SelectModel sm = new SelectModel(TAG);
        sm.id = this.id;
        sm.libelle = this.libelle;
        sm.value = this.value;
        sm.sort = this.sort;
        for (OptionModel om : this.options) {
            sm.options.add(om.clone());
        }
        for (RecherchePaireModel rpm : this.recherches) {
            sm.recherches.add(rpm.clone());
        }
        for (SpecialKeyEntryModel skem : this.specialKeys) {
            sm.specialKeys.add(skem.clone());
        }
        return sm;
    }

    public int getSortBy() {
        if ("no".equals(this.sort)) {
            return 0;
        }
        if ("key".equals(this.sort)) {
            return 1;
        }
        return 2;
    }

    public Vector<SpecialKeyEntryModel> getSpecialKeys() {
        return this.specialKeys;
    }

    public Collection<Pair> getNewRecipient() {
        int sortBy = this.getSortBy();
        if (sortBy == 0) {
            return new Vector<Pair>();
        }
        Comparator cp = sortBy == 1 ? new Comparator(){

            public int compare(Object o1, Object o2) {
                Pair p1 = (Pair)o1;
                Pair p2 = (Pair)o2;
                return p1.key.compareTo(p2.key);
            }
        } : new Comparator(){

            public int compare(Object o1, Object o2) {
                Pair p1 = (Pair)o1;
                Pair p2 = (Pair)o2;
                return p1.libelle.compareTo(p2.libelle);
            }
        };
        return new TreeSet<Pair>(cp);
    }
}

