/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.common.config;

import fr.gouv.finances.cp.utils.xml.marshal.InvalidXmlDefinition;
import fr.gouv.finances.cp.utils.xml.marshal.XmlAttributes;
import fr.gouv.finances.cp.utils.xml.marshal.XmlMarshallable;
import fr.gouv.finances.cp.utils.xml.marshal.XmlOutputter;
import fr.gouv.finances.cp.xemelios.common.config.CritereModel;
import fr.gouv.finances.cp.xemelios.common.config.ListeResultatModel;
import fr.gouv.finances.cp.xemelios.common.config.OptionModel;
import fr.gouv.finances.cp.xemelios.common.config.PropertyModel;
import fr.gouv.finances.cp.xemelios.common.config.RechercheModel;
import fr.gouv.finances.cp.xemelios.ui.ListDisplayable;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.Vector;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginModel
implements XmlMarshallable,
Comparable,
ListDisplayable {
    public static final transient String TAG = "plugin";
    public static final transient String TYPE_SEARCH = "search";
    public static final transient String TYPE_EXPORT = "export";
    private String pluginType;
    private String pluginTitle;
    private String pluginClass;
    private String availablePersistences;
    private boolean sumPossible = false;
    private Vector<CritereModel> criteres = new Vector();
    private Vector<PropertyModel> properties = new Vector();
    private OptionModel entete;
    private String separator;
    private ListeResultatModel listeResultat;
    private HashSet<String> persistences = null;

    public PluginModel(String tag) {
    }

    public void addCharacterData(String cData) throws SAXException {
    }

    public void addChild(XmlMarshallable child, String tagName) throws SAXException {
        if ("critere".equals(tagName)) {
            this.criteres.add((CritereModel)child);
        } else if ("property".equals(tagName)) {
            this.properties.add((PropertyModel)child);
        } else if ("header".equals(tagName)) {
            this.entete = (OptionModel)child;
        } else if ("liste-export".equals(tagName)) {
            this.listeResultat = (ListeResultatModel)child;
        }
    }

    public XmlMarshallable getAttributes(XmlAttributes attributes) throws SAXException {
        this.pluginType = attributes.getValue("type");
        this.pluginTitle = attributes.getValue("title");
        this.pluginClass = attributes.getValue("class");
        this.separator = attributes.getValue("separator");
        this.availablePersistences = attributes.getValue("available-persistences");
        this.sumPossible = attributes.getBooleanValue("sum-possible");
        return this;
    }

    public void marshall(XmlOutputter output) {
    }

    public void validate() throws InvalidXmlDefinition {
    }

    public PluginModel clone() {
        PluginModel pm = new PluginModel(TAG);
        pm.pluginClass = this.pluginClass;
        pm.pluginTitle = this.pluginTitle;
        pm.pluginType = this.pluginType;
        pm.availablePersistences = this.availablePersistences;
        pm.sumPossible = this.sumPossible;
        for (PropertyModel prop : this.properties) {
            try {
                pm.addChild(prop, "property");
            }
            catch (SAXException ignore) {}
        }
        for (CritereModel crit : this.criteres) {
            try {
                pm.addChild(crit.clone(), "critere");
            }
            catch (SAXException ignore) {}
        }
        pm.separator = this.separator;
        if (this.entete != null) {
            pm.entete = this.entete.clone();
        }
        if (this.listeResultat != null) {
            pm.listeResultat = this.listeResultat.clone();
        }
        return pm;
    }

    public Vector<CritereModel> getCriteres() {
        return this.criteres;
    }

    public String getPluginClass() {
        return this.pluginClass;
    }

    public String getPluginTitle() {
        return this.pluginTitle;
    }

    public String getPluginType() {
        return this.pluginType;
    }

    public int compareTo(Object o) {
        if (o == this) {
            return 0;
        }
        if (o instanceof RechercheModel) {
            RechercheModel other = (RechercheModel)o;
            return this.getPluginTitle().compareTo(other.getName());
        }
        if (o instanceof PluginModel) {
            PluginModel other = (PluginModel)o;
            return this.getPluginTitle().compareTo(other.getPluginTitle());
        }
        return 0;
    }

    public String toString() {
        return this.getPluginTitle();
    }

    public Vector<PropertyModel> getProperties() {
        return this.properties;
    }

    public String getSeparator() {
        return this.separator;
    }

    public OptionModel getEntete() {
        return this.entete;
    }

    public ListeResultatModel getListeExport() {
        return this.listeResultat;
    }

    @Override
    public String getResource() {
        if (TYPE_SEARCH.equals(this.getPluginType())) {
            return "fr/gouv/finances/cp/xemelios/ui/resources/list-search-plug.png";
        }
        if (TYPE_EXPORT.equals(this.getPluginType())) {
            return "fr/gouv/finances/cp/xemelios/ui/resources/list-export-plug.png";
        }
        return null;
    }

    @Override
    public String getDisplayName() {
        return this.toString();
    }

    @Override
    public boolean isDeletable() {
        return false;
    }

    public String getAvailablePersistences() {
        return this.availablePersistences;
    }

    public void setAvailablePersistences(String availablePersistences) {
        this.availablePersistences = availablePersistences;
    }

    public boolean isAvailableFor(String persistence) {
        if (this.persistences == null) {
            this.persistences = new HashSet();
            if (this.availablePersistences != null) {
                StringTokenizer st = new StringTokenizer(this.availablePersistences, ",; ");
                while (st.hasMoreTokens()) {
                    String s = st.nextToken();
                    this.persistences.add(s);
                }
            }
        }
        return this.persistences.contains(persistence);
    }

    public void setSumPossible(boolean isSumPossible) {
        this.sumPossible = isSumPossible;
    }

    public boolean isSumPossible() {
        return this.sumPossible;
    }
}

