/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.common.config;

import fr.gouv.finances.cp.utils.xml.marshal.InvalidXmlDefinition;
import fr.gouv.finances.cp.utils.xml.marshal.XmlAttributes;
import fr.gouv.finances.cp.utils.xml.marshal.XmlMarshallable;
import fr.gouv.finances.cp.utils.xml.marshal.XmlOutputter;
import org.apache.commons.lang.StringEscapeUtils;
import org.xml.sax.SAXException;

public class InputModel
implements XmlMarshallable {
    public static final transient String TAG = "input";
    private String id;
    private String libelle;
    private String datatype;
    private String helpPath;
    private String value;
    private String xmlFormat;
    private boolean uppercase = false;

    public boolean isUppercase() {
        return this.uppercase;
    }

    public InputModel(String tagName) {
    }

    public void addCharacterData(String cData) throws SAXException {
    }

    public void addChild(XmlMarshallable child, String tagName) throws SAXException {
    }

    public XmlMarshallable getAttributes(XmlAttributes attributes) throws SAXException {
        this.id = attributes.getValue("id");
        this.libelle = attributes.getValue("libelle");
        this.datatype = attributes.getValue("datatype");
        this.uppercase = attributes.getBooleanValue("uppercase");
        this.helpPath = attributes.getValue("help");
        this.value = attributes.getValue("value");
        this.xmlFormat = attributes.getValue("xml-format");
        return this;
    }

    public void marshall(XmlOutputter output) {
        output.startTag(TAG);
        output.addAttribute("id", this.id);
        if (this.libelle != null) {
            output.addAttribute("libelle", StringEscapeUtils.escapeXml(this.libelle));
        }
        output.addAttribute("datatype", this.datatype);
        output.addAttribute("uppercase", this.uppercase);
        if ("date".equals(this.datatype)) {
            output.addAttribute("xml-format", this.xmlFormat);
        }
        if (this.helpPath != null) {
            output.addAttribute("help", this.helpPath);
        }
        output.endTag(TAG);
    }

    public void validate() throws InvalidXmlDefinition {
    }

    public String getDatatype() {
        return this.datatype;
    }

    public String getId() {
        return this.id;
    }

    public String getLibelle() {
        return this.libelle;
    }

    public String getHelpPath() {
        return this.helpPath;
    }

    public String getXmlDateFormat() {
        return this.xmlFormat;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public InputModel clone() {
        InputModel im = new InputModel(TAG);
        im.id = this.id;
        im.libelle = this.libelle;
        im.datatype = this.datatype;
        im.helpPath = this.helpPath;
        im.uppercase = this.uppercase;
        im.xmlFormat = this.xmlFormat;
        im.value = this.value;
        return im;
    }
}

