/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.common.config;

import fr.gouv.finances.cp.utils.xml.marshal.InvalidXmlDefinition;
import fr.gouv.finances.cp.utils.xml.marshal.XmlAttributes;
import fr.gouv.finances.cp.utils.xml.marshal.XmlMarshallable;
import fr.gouv.finances.cp.utils.xml.marshal.XmlOutputter;
import fr.gouv.finances.cp.xemelios.common.config.DocumentModel;
import fr.gouv.finances.cp.xemelios.common.config.ElementModel;
import fr.gouv.finances.cp.xemelios.common.config.EnteteModel;
import fr.gouv.finances.cp.xemelios.common.config.EnvironmentDomain;
import fr.gouv.finances.cp.xemelios.common.config.VariableModel;
import fr.gouv.finances.cp.xemelios.data.DataConfigurationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EtatModel
implements XmlMarshallable,
EnvironmentDomain {
    public static final transient String TAG = "etat";
    private static final Logger logger = Logger.getLogger(EtatModel.class);
    private TreeMap<String, ElementModel> elements;
    private Vector<String> entetes = new Vector();
    private DocumentModel parent;
    private String id;
    private String titre;
    private String balise;
    private String xslt;
    private String searchableElement;
    private String browsableElement;
    private String importableElement;
    private String displayInMenuIf;
    private boolean useExternalBrowser = true;
    private boolean browsable = false;
    private boolean searchable = true;
    private boolean multiPage = false;
    private Vector<EnvironmentDomain> vElements;

    public EtatModel(String tagName) {
        this.elements = new TreeMap();
    }

    public void addCharacterData(String cData) throws SAXException {
    }

    public void addChild(XmlMarshallable child, String tagName) throws SAXException {
        if ("element".equals(tagName)) {
            ElementModel element = (ElementModel)child;
            element.setParent(this);
            this.elements.put(element.getId(), element);
        } else if ("entete".equals(tagName)) {
            this.entetes.add(((EnteteModel)child).getBalise());
        }
    }

    public XmlMarshallable getAttributes(XmlAttributes attributes) throws SAXException {
        this.id = attributes.getValue("id");
        this.titre = attributes.getValue("titre");
        this.balise = attributes.getValue("balise");
        this.xslt = attributes.getValue("xslt-file");
        if (attributes.getValue("use-external-browser") != null) {
            this.useExternalBrowser = attributes.getBooleanValue("use-external-browser");
        }
        if (attributes.getValue("browsable") != null) {
            this.browsable = attributes.getBooleanValue("browsable");
        }
        if (attributes.getValue("searchable") != null) {
            this.searchable = attributes.getBooleanValue("searchable");
        }
        if (attributes.getValue("multi-page") != null) {
            this.multiPage = attributes.getBooleanValue("multi-page");
        }
        this.searchableElement = attributes.getValue("searchable-element");
        this.browsableElement = attributes.getValue("browsable-element");
        this.importableElement = attributes.getValue("importable-element");
        this.displayInMenuIf = attributes.getValue("displayInMenuIf");
        return this;
    }

    public void marshall(XmlOutputter output) {
        throw new Error("Not yet implemented");
    }

    public void validate() throws InvalidXmlDefinition {
        if (this.id == null) {
            throw new InvalidXmlDefinition("pas de id dans etat");
        }
        for (ElementModel element : this.elements.values()) {
            element.validate();
        }
    }

    public String getBalise() {
        return this.balise;
    }

    public String getId() {
        return this.id;
    }

    public String getTitre() {
        return this.titre;
    }

    public String getXslt() {
        return this.xslt;
    }

    public Vector<String> getEntetes() {
        return this.entetes;
    }

    public DocumentModel getParent() {
        return this.parent;
    }

    protected void setParent(DocumentModel parent) {
        this.parent = parent;
    }

    public EtatModel clone(DocumentModel otherParent) {
        EtatModel em = new EtatModel(TAG);
        for (ElementModel element : this.elements.values()) {
            try {
                em.addChild(element.clone(), "element");
            }
            catch (Throwable t) {}
        }
        for (String s : this.entetes) {
            em.entetes.add(s);
        }
        em.parent = otherParent;
        em.id = this.id;
        em.titre = this.titre;
        em.balise = this.balise;
        em.xslt = this.xslt;
        em.browsable = this.browsable;
        em.searchable = this.searchable;
        em.browsableElement = this.browsableElement;
        em.importableElement = this.importableElement;
        em.multiPage = this.multiPage;
        em.searchableElement = this.searchableElement;
        em.useExternalBrowser = this.useExternalBrowser;
        return em;
    }

    public EtatModel clone() {
        return this.clone(this.parent);
    }

    public boolean useExternalBrowser() {
        return this.useExternalBrowser;
    }

    public boolean isBrowsable() {
        return this.browsable;
    }

    public boolean isSearchable() {
        return this.searchable;
    }

    public ElementModel getElementById(String elementId) {
        return this.elements.get(elementId);
    }

    public ElementModel getDefaultElement() {
        return this.elements.values().iterator().next();
    }

    public Collection<ElementModel> getSearchableElements() {
        ArrayList<ElementModel> ret = new ArrayList<ElementModel>();
        for (ElementModel em : this.elements.values()) {
            if (!em.isSearchable()) continue;
            ret.add(em);
        }
        return ret;
    }

    public ElementModel getBrowsableElement() {
        if (this.browsableElement != null) {
            return this.getElementById(this.browsableElement);
        }
        return this.getDefaultElement();
    }

    public ElementModel getImportableElement() {
        if (this.importableElement != null) {
            return this.getElementById(this.importableElement);
        }
        return this.getDefaultElement();
    }

    public boolean isMultiPage() {
        return this.multiPage;
    }

    @Override
    public EnvironmentDomain getChildAt(int domain, int pos) {
        if (this.vElements == null) {
            this.vElements = new Vector();
            this.vElements.addAll(this.elements.values());
        }
        return this.vElements.elementAt(pos);
    }

    @Override
    public boolean hasEnvironment(int domain) {
        return false;
    }

    @Override
    public Enumeration<VariableModel> getVariables(int domain) {
        return null;
    }

    @Override
    public int getChildCount(int domain) {
        return this.elements.size();
    }

    @Override
    public Enumeration<EnvironmentDomain> children(int domain) {
        if (this.vElements == null) {
            this.vElements = new Vector();
            this.vElements.addAll(this.elements.values());
        }
        return this.vElements.elements();
    }

    public String toString() {
        return this.titre;
    }

    @Override
    public Object getValue(String path) throws DataConfigurationException {
        String sTmp = path.startsWith("/") ? path.substring(1) : path;
        if (sTmp.startsWith("element")) {
            int pos = sTmp.indexOf(47);
            String next = sTmp.substring(pos);
            String condition = sTmp.substring("element".length(), pos);
            if (condition.startsWith("[") && condition.endsWith("]")) {
                condition = condition.substring(1, condition.length() - 1);
            }
            if (condition.startsWith("@id=")) {
                String elementId = condition.substring(5, condition.length() - 1);
                ElementModel em = this.getElementById(elementId);
                return em.getValue(next);
            }
            throw new DataConfigurationException("can only access to element by id");
        }
        throw new DataConfigurationException("from etat, you can only access to element(s)");
    }

    @Override
    public void setValue(String path, Object value) throws DataConfigurationException {
        String condition;
        String next;
        String sTmp = path.startsWith("/") ? path.substring(1) : path;
        if (sTmp.startsWith("element")) {
            int pos = sTmp.indexOf(47);
            next = sTmp.substring(pos);
            condition = sTmp.substring("element".length(), pos);
            if (condition.startsWith("[") && condition.endsWith("]")) {
                condition = condition.substring(1, condition.length() - 1);
            }
            if (!condition.startsWith("@id=")) {
                throw new DataConfigurationException("can only access to element by id");
            }
        } else {
            throw new DataConfigurationException("from etat, you can only access to element(s)");
        }
        String elementId = condition.substring(5, condition.length() - 1);
        ElementModel em = this.getElementById(elementId);
        em.setValue(next, value);
    }

    public String getDisplayInMenuIf() {
        return this.displayInMenuIf;
    }
}

