/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.common.config;

import fr.gouv.finances.cp.utils.xml.marshal.InvalidXmlDefinition;
import fr.gouv.finances.cp.utils.xml.marshal.XmlAttributes;
import fr.gouv.finances.cp.utils.xml.marshal.XmlMarshallable;
import fr.gouv.finances.cp.utils.xml.marshal.XmlOutputter;
import fr.gouv.finances.cp.xemelios.common.config.CritereModel;
import fr.gouv.finances.cp.xemelios.common.config.EnvironmentDomain;
import fr.gouv.finances.cp.xemelios.common.config.EnvironmentModel;
import fr.gouv.finances.cp.xemelios.common.config.EtatModel;
import fr.gouv.finances.cp.xemelios.common.config.ListeResultatModel;
import fr.gouv.finances.cp.xemelios.common.config.PluginModel;
import fr.gouv.finances.cp.xemelios.common.config.VariableModel;
import fr.gouv.finances.cp.xemelios.common.config.XPathModel;
import fr.gouv.finances.cp.xemelios.data.DataConfigurationException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementModel
implements XmlMarshallable,
EnvironmentDomain,
PropertyChangeListener {
    public static final transient String TAG = "element";
    private static final Logger logger = Logger.getLogger(ElementModel.class);
    private static final Object locker = new Object();
    private ListeResultatModel listeResultat;
    private Vector<CritereModel> criteres = new Vector();
    private Vector<PluginModel> plugins = new Vector();
    private String id;
    private String titre;
    private String balise;
    private String xslt;
    private XPathModel path;
    private EtatModel parent;
    private boolean browsable = false;
    private boolean searchable = true;
    private EnvironmentModel env;
    private int maxDisplay = 100;
    private boolean modeAnomaly = false;
    private Vector<CritereModel> availableCriteres;
    private ArrayList<PropertyChangeListener> listeners = new ArrayList();

    public ElementModel(String tagName) {
        this.listeners.add(this);
    }

    public void addCharacterData(String cData) throws SAXException {
    }

    public void addChild(XmlMarshallable child, String tagName) throws SAXException {
        if ("liste-resultat".equals(tagName)) {
            this.listeResultat = (ListeResultatModel)child;
            this.listeResultat.setParent(this);
        } else if ("critere".equals(tagName)) {
            this.criteres.add((CritereModel)child);
        } else if ("path".equals(tagName)) {
            this.path = (XPathModel)child;
        } else if ("plugin".equals(tagName)) {
            this.plugins.add((PluginModel)child);
        } else if ("environment".equals(tagName)) {
            this.env = (EnvironmentModel)child;
        } else {
            throw new SAXException("unexpected child element : " + tagName);
        }
    }

    public XmlMarshallable getAttributes(XmlAttributes attributes) throws SAXException {
        this.id = attributes.getValue("id");
        this.titre = attributes.getValue("titre");
        this.balise = attributes.getValue("balise");
        this.xslt = attributes.getValue("xslt-file");
        try {
            this.maxDisplay = attributes.getIntValue("max-display");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (attributes.getValue("browsable") != null) {
            this.browsable = attributes.getBooleanValue("browsable");
        }
        if (attributes.getValue("searchable") != null) {
            this.searchable = attributes.getBooleanValue("searchable");
        }
        if ("anomally".equals(attributes.getValue("mode"))) {
            this.modeAnomaly = true;
        }
        return this;
    }

    public void marshall(XmlOutputter output) {
        throw new Error("Not yet implemented");
    }

    public void validate() throws InvalidXmlDefinition {
        if (this.id == null) {
            throw new InvalidXmlDefinition("pas de id dans element");
        }
        if (this.listeResultat != null) {
            this.listeResultat.validate();
        }
        for (CritereModel cm : this.criteres) {
            cm.validate();
        }
        this.path.validate();
    }

    public String getBalise() {
        return this.balise;
    }

    public String getId() {
        return this.id;
    }

    public ListeResultatModel getListeResultat() {
        return this.listeResultat;
    }

    public String getTitre() {
        return this.titre;
    }

    public Vector<CritereModel> getCriteres() {
        return this.criteres;
    }

    public XPathModel getPath() {
        return this.path;
    }

    public int getMaxDisplay() {
        return this.maxDisplay;
    }

    public Vector<PluginModel> getPlugins() {
        return this.plugins;
    }

    public ElementModel clone() {
        ElementModel em = new ElementModel(TAG);
        em.listeResultat = this.listeResultat.clone();
        em.listeResultat.setParent(em);
        for (CritereModel cm : this.criteres) {
            em.criteres.add(cm.clone());
        }
        for (PluginModel pm : this.plugins) {
            try {
                em.addChild(pm.clone(), "plugin");
            }
            catch (Throwable t) {}
        }
        em.id = this.id;
        em.titre = this.titre;
        em.balise = this.balise;
        em.path = this.path.clone();
        em.maxDisplay = this.maxDisplay;
        em.browsable = this.browsable;
        if (this.env != null) {
            em.env = this.env.clone();
        }
        em.modeAnomaly = this.modeAnomaly;
        em.searchable = this.searchable;
        em.xslt = this.xslt;
        return em;
    }

    public String getXslt() {
        if (this.xslt == null) {
            return this.parent.getXslt();
        }
        return this.xslt;
    }

    public boolean isBrowsable() {
        return this.browsable;
    }

    public boolean isSearchable() {
        return this.searchable;
    }

    public boolean isModeAnomaly() {
        return this.modeAnomaly;
    }

    @Override
    public EnvironmentDomain getChildAt(int domain, int pos) {
        return null;
    }

    @Override
    public boolean hasEnvironment(int domain) {
        if (this.env == null) {
            return false;
        }
        Enumeration<VariableModel> enumer = this.env.getVariables(domain);
        if (enumer == null) {
            return false;
        }
        return enumer.hasMoreElements();
    }

    @Override
    public Enumeration<VariableModel> getVariables(int domain) {
        return this.env.getVariables(domain);
    }

    @Override
    public int getChildCount(int domain) {
        return 0;
    }

    @Override
    public Enumeration<EnvironmentDomain> children(int domain) {
        return null;
    }

    public String toString() {
        return this.titre;
    }

    public EtatModel getParent() {
        return this.parent;
    }

    public void setParent(EtatModel parent) {
        this.parent = parent;
    }

    @Override
    public Object getValue(String path) throws DataConfigurationException {
        String sTmp = path.startsWith("/") ? path.substring(1) : path;
        if ("@max-display".equals(sTmp)) {
            return new Integer(this.getMaxDisplay());
        }
        if ("@mode".equals(sTmp)) {
            return new Boolean(this.isModeAnomaly());
        }
        throw new DataConfigurationException(sTmp + " is not readable");
    }

    @Override
    public void setValue(String path, Object value) throws DataConfigurationException {
        String sTmp = path.startsWith("/") ? path.substring(1) : path;
        if ("@max-display".equals(sTmp)) {
            int newValue = Integer.parseInt((String)value);
            if (newValue != this.maxDisplay) {
                int oldValue = this.maxDisplay;
                this.maxDisplay = newValue;
                this.firePropertyChange("max-display", oldValue, newValue);
            }
        } else if ("@mode".equals(sTmp)) {
            boolean newValue = (Boolean)value;
            if (newValue != this.modeAnomaly) {
                this.modeAnomaly = newValue;
                this.firePropertyChange("mode", !newValue, newValue);
            }
        } else {
            throw new DataConfigurationException(sTmp + " is not readable");
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
        this.firePropertyChange(propertyName, new Integer(oldValue), new Integer(newValue));
    }

    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        this.firePropertyChange(propertyName, new Boolean(oldValue), new Boolean(newValue));
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        PropertyChangeEvent pce = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
        for (PropertyChangeListener listener : this.listeners) {
            listener.propertyChange(pce);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("mode".equals(evt.getPropertyName())) {
            this.availableCriteres = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<CritereModel> getAvailableCriteres() {
        if (this.availableCriteres == null) {
            Object object = locker;
            synchronized (object) {
                this.availableCriteres = new Vector();
                int targetMode = this.isModeAnomaly() ? 2 : 1;
                for (CritereModel cm : this.getCriteres()) {
                    if ((cm.getMode() & targetMode) <= 0) continue;
                    this.availableCriteres.add(cm);
                }
            }
        }
        return this.availableCriteres;
    }

    public Iterator<PropertyChangeListener> getPropertyListeners() {
        if (this.listeners.isEmpty()) {
            return null;
        }
        return this.listeners.iterator();
    }
}

