/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.common.config;

import fr.gouv.finances.cp.utils.xml.marshal.InvalidXmlDefinition;
import fr.gouv.finances.cp.utils.xml.marshal.XmlAttributes;
import fr.gouv.finances.cp.utils.xml.marshal.XmlMarshallable;
import fr.gouv.finances.cp.utils.xml.marshal.XmlOutputter;
import fr.gouv.finances.cp.xemelios.common.config.DocumentModel;
import fr.gouv.finances.cp.xemelios.common.config.ElementModel;
import fr.gouv.finances.cp.xemelios.common.config.EnvironmentDomain;
import fr.gouv.finances.cp.xemelios.common.config.VariableModel;
import fr.gouv.finances.cp.xemelios.data.DataConfigurationException;
import java.util.Enumeration;
import java.util.Vector;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentsModel
implements XmlMarshallable,
EnvironmentDomain {
    public static final transient String TAG = "documents";
    Vector<DocumentModel> documents = new Vector();
    Vector<EnvironmentDomain> vDocuments = new Vector();

    public DocumentsModel(String tag) {
    }

    public void addCharacterData(String cData) throws SAXException {
        throw new SAXException("pas de CDATA attendu");
    }

    public void addChild(XmlMarshallable child, String tagName) throws SAXException {
        if (!"document".equals(tagName)) {
            throw new SAXException(tagName + ": tag non attendu");
        }
        this.documents.add((DocumentModel)child);
        this.vDocuments.add((EnvironmentDomain)child);
    }

    public XmlMarshallable getAttributes(XmlAttributes attributes) throws SAXException {
        return this;
    }

    public void marshall(XmlOutputter output) {
        throw new Error("Not yet implemented");
    }

    public void validate() throws InvalidXmlDefinition {
        for (DocumentModel dm : this.documents) {
            dm.validate();
        }
    }

    public Vector<DocumentModel> getDocuments() {
        return this.documents;
    }

    public DocumentModel getDocumentById(String docId) {
        Enumeration<DocumentModel> enumer = this.documents.elements();
        while (enumer.hasMoreElements()) {
            DocumentModel doc = enumer.nextElement();
            if (!doc.getId().equals(docId)) continue;
            return doc;
        }
        return null;
    }

    public DocumentsModel clone() {
        DocumentsModel dom = new DocumentsModel(TAG);
        for (DocumentModel dm : this.documents) {
            try {
                dom.addChild(dm.clone(), "document");
            }
            catch (Throwable t) {}
        }
        return dom;
    }

    @Override
    public EnvironmentDomain getChildAt(int domain, int pos) {
        return this.documents.elementAt(pos);
    }

    @Override
    public boolean hasEnvironment(int domain) {
        return false;
    }

    @Override
    public Enumeration<VariableModel> getVariables(int domain) {
        return null;
    }

    @Override
    public int getChildCount(int domain) {
        return this.documents.size();
    }

    @Override
    public Enumeration<EnvironmentDomain> children(int domain) {
        return this.vDocuments.elements();
    }

    public String toString() {
        return TAG;
    }

    @Override
    public Object getValue(String path) throws DataConfigurationException {
        String sTmp = path.startsWith(TAG) ? path.substring(TAG.length()) : path;
        if (sTmp.startsWith("/")) {
            sTmp = sTmp.substring(1);
        }
        if (sTmp.startsWith("@")) {
            throw new DataConfigurationException(path + " is not significant on " + DocumentsModel.class.getName());
        }
        if (sTmp.startsWith("document")) {
            int pos = sTmp.indexOf("/");
            String next = sTmp.substring(pos);
            String condition = sTmp.substring("document".length(), pos);
            if (condition.startsWith("[") && condition.endsWith("]")) {
                condition = condition.substring(1, condition.length() - 1).trim();
            }
            if (condition.startsWith("@id=")) {
                String documentId = condition.substring(5, condition.length() - 1);
                DocumentModel dm = this.getDocumentById(documentId);
                return dm.getValue(next);
            }
            throw new DataConfigurationException(condition + " is not valid to access to " + "document");
        }
        throw new DataConfigurationException(sTmp + " : invalid path on " + DocumentsModel.class.getName());
    }

    @Override
    public void setValue(String path, Object value) throws DataConfigurationException {
        String condition;
        String next;
        String sTmp = path.startsWith(TAG) ? path.substring(TAG.length()) : path;
        if (sTmp.startsWith("/")) {
            sTmp = sTmp.substring(1);
        }
        if (sTmp.startsWith("@")) {
            throw new DataConfigurationException(path + " is not significant on " + DocumentsModel.class.getName());
        }
        if (sTmp.startsWith("document")) {
            int pos = sTmp.indexOf("/");
            next = sTmp.substring(pos);
            condition = sTmp.substring("document".length(), pos);
            if (condition.startsWith("[") && condition.endsWith("]")) {
                condition = condition.substring(1, condition.length() - 1).trim();
            }
            if (!condition.startsWith("@id=")) {
                throw new DataConfigurationException(condition + " is not valid to access to " + "document");
            }
        } else {
            throw new DataConfigurationException(sTmp + " : invalid path on " + DocumentsModel.class.getName());
        }
        String documentId = condition.substring(5, condition.length() - 1);
        DocumentModel dm = this.getDocumentById(documentId);
        dm.setValue(next, value);
    }

    public Vector<ElementModel> getElementsById(String elementId) {
        Vector<ElementModel> ret = new Vector<ElementModel>();
        for (DocumentModel dm : this.documents) {
            ret.addAll(dm.getElementsById(elementId));
        }
        return ret;
    }
}

