/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.common.config;

import fr.gouv.finances.cp.utils.Pair;
import fr.gouv.finances.cp.utils.xml.marshal.InvalidXmlDefinition;
import fr.gouv.finances.cp.utils.xml.marshal.XmlAttributes;
import fr.gouv.finances.cp.utils.xml.marshal.XmlMarshallable;
import fr.gouv.finances.cp.utils.xml.marshal.XmlOutputter;
import fr.gouv.finances.cp.xemelios.common.config.DeleteFilterModel;
import fr.gouv.finances.cp.xemelios.common.config.ElementModel;
import fr.gouv.finances.cp.xemelios.common.config.EnteteModel;
import fr.gouv.finances.cp.xemelios.common.config.EnvironmentDomain;
import fr.gouv.finances.cp.xemelios.common.config.EtatModel;
import fr.gouv.finances.cp.xemelios.common.config.NamespaceModel;
import fr.gouv.finances.cp.xemelios.common.config.OptionModel;
import fr.gouv.finances.cp.xemelios.common.config.ParametersModel;
import fr.gouv.finances.cp.xemelios.common.config.RecherchePaireModel;
import fr.gouv.finances.cp.xemelios.common.config.SpecialKeyModel;
import fr.gouv.finances.cp.xemelios.common.config.VariableModel;
import fr.gouv.finances.cp.xemelios.data.DataConfigurationException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentModel
implements XmlMarshallable,
EnvironmentDomain {
    public static final transient String TAG = "document";
    private static final Logger logger = Logger.getLogger(DocumentModel.class);
    private Vector<EtatModel> etats = new Vector();
    private Vector<EnvironmentDomain> vEtats = new Vector();
    private Vector<String> entetes = new Vector();
    private Hashtable<String, EnteteModel> map = new Hashtable();
    private String id;
    private String extension;
    private String schema;
    private String titre;
    private String balise;
    private String referentiel;
    private String importClass;
    private String indexCreation;
    private String libelleExtension;
    private String referentielXsltFile;
    private String defaultBrowsableEtat;
    private String referentielImportTransfo;
    private String persistenceConfigFile;
    private RecherchePaireModel collectivitePath;
    private RecherchePaireModel budgetPath;
    private Vector<DeleteFilterModel> deleteFilters;
    private Vector<Pair> defaultBudgets = new Vector();
    private Vector<SpecialKeyModel> specialKeys = new Vector();
    private NamespaceModel namespaces = null;
    private boolean browsable = false;
    private boolean isControlable = false;
    private boolean groupMenuItems = true;
    private String controlConfigFile;
    private ParametersModel parameters;

    public DocumentModel(String tagName) {
        this.deleteFilters = new Vector();
    }

    public void addCharacterData(String cData) throws SAXException {
    }

    public void addChild(XmlMarshallable child, String tagName) throws SAXException {
        if ("entete".equals(tagName)) {
            String key = ((EnteteModel)child).getBalise();
            this.entetes.add(key);
            this.map.put(key, (EnteteModel)child);
        } else if ("etat".equals(tagName)) {
            EtatModel etat = (EtatModel)child;
            etat.setParent(this);
            this.etats.add(etat);
            this.vEtats.add(etat);
        } else if ("budget-path".equals(tagName)) {
            this.budgetPath = (RecherchePaireModel)child;
        } else if ("collectivite-path".equals(tagName)) {
            this.collectivitePath = (RecherchePaireModel)child;
        } else if ("delete-filter".equals(tagName)) {
            this.deleteFilters.add((DeleteFilterModel)child);
        } else if ("default-budget".equals(tagName)) {
            OptionModel om = (OptionModel)child;
            Pair p = new Pair(om.getValue(), om.getLibelle());
            this.defaultBudgets.add(p);
        } else if ("special-key".equals(tagName)) {
            SpecialKeyModel skm = (SpecialKeyModel)child;
            this.specialKeys.add(skm);
        } else if ("namespaces".equals(tagName)) {
            this.namespaces = (NamespaceModel)child;
        } else if ("parameters".equals(tagName)) {
            this.parameters = (ParametersModel)child;
        }
    }

    public XmlMarshallable getAttributes(XmlAttributes attributes) throws SAXException {
        this.id = attributes.getValue("id");
        this.extension = attributes.getValue("extension");
        this.schema = attributes.getValue("schema");
        this.titre = attributes.getValue("titre");
        this.balise = attributes.getValue("balise");
        this.referentiel = attributes.getValue("referentiel");
        this.importClass = attributes.getValue("import-class");
        this.indexCreation = attributes.getValue("index-creation");
        this.libelleExtension = attributes.getValue("libelle-extension");
        this.referentielXsltFile = attributes.getValue("referentiel-xslt-file");
        if (attributes.getValue("browsable") != null) {
            this.browsable = attributes.getBooleanValue("browsable");
        }
        if (attributes.getValue("isControlable") != null) {
            this.isControlable = attributes.getBooleanValue("isControlable");
        }
        this.defaultBrowsableEtat = attributes.getValue("default-browsable-etat");
        this.referentielImportTransfo = attributes.getValue("referentiel-import-xslt");
        this.persistenceConfigFile = attributes.getValue("persistence-config");
        if (attributes.getValue("menu-grouping") != null) {
            this.groupMenuItems = "group".equals(attributes.getValue("menu-grouping"));
        }
        this.controlConfigFile = attributes.getValue("control-config-file");
        return this;
    }

    public void marshall(XmlOutputter output) {
        throw new Error("Not yet implemented");
    }

    public void validate() throws InvalidXmlDefinition {
        for (EtatModel em : this.etats) {
            em.validate();
        }
        if (this.collectivitePath != null) {
            this.collectivitePath.validate();
        }
        if (this.budgetPath != null) {
            this.budgetPath.validate();
        }
        if (this.namespaces == null) {
            throw new InvalidXmlDefinition("namespaces is required.");
        }
    }

    public String getBalise() {
        return this.balise;
    }

    public Vector<EtatModel> getEtats() {
        return this.etats;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getId() {
        return this.id;
    }

    public String getReferentiel() {
        return this.referentiel;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getTitre() {
        return this.titre;
    }

    public String getImportClass() {
        return this.importClass;
    }

    public boolean isControlable() {
        return this.isControlable;
    }

    public EtatModel getEtatById(String etatId) {
        Enumeration<EtatModel> enumer = this.etats.elements();
        while (enumer.hasMoreElements()) {
            EtatModel etat = enumer.nextElement();
            if (!etat.getId().equals(etatId)) continue;
            return etat;
        }
        return null;
    }

    public EtatModel getEtatByTagName(String tagName) {
        Enumeration<EtatModel> enumer = this.etats.elements();
        while (enumer.hasMoreElements()) {
            EtatModel etat = enumer.nextElement();
            if (!etat.getBalise().equals(tagName)) continue;
            return etat;
        }
        return null;
    }

    public Vector<String> getEntetes() {
        return this.entetes;
    }

    public RecherchePaireModel getBudgetPath() {
        return this.budgetPath;
    }

    public RecherchePaireModel getCollectivitePath() {
        return this.collectivitePath;
    }

    public String getLibelleExtension() {
        return this.libelleExtension == null ? this.getTitre() : this.libelleExtension;
    }

    public Hashtable<String, EnteteModel> getMap() {
        return this.map;
    }

    public String getIndexCreation() {
        return this.indexCreation;
    }

    public String toString() {
        return this.titre;
    }

    public Vector<DeleteFilterModel> getDeleteFilters() {
        return this.deleteFilters;
    }

    public Vector<Pair> getDefaultBudgets() {
        return this.defaultBudgets;
    }

    public String getReferentielXsltFile() {
        return this.referentielXsltFile;
    }

    public DocumentModel clone() {
        DocumentModel dm = new DocumentModel(TAG);
        for (EtatModel etatModel : this.etats) {
            try {
                dm.addChild(etatModel.clone(dm), "etat");
            }
            catch (Throwable t) {}
        }
        for (String string : this.entetes) {
            dm.entetes.add(string);
            dm.map.put(string, this.map.get(string).clone());
        }
        dm.id = this.id;
        dm.extension = this.extension;
        dm.schema = this.schema;
        dm.titre = this.titre;
        dm.balise = this.balise;
        dm.referentiel = this.referentiel;
        dm.importClass = this.importClass;
        dm.indexCreation = this.indexCreation;
        dm.libelleExtension = this.libelleExtension;
        dm.referentielXsltFile = this.referentielXsltFile;
        dm.browsable = this.browsable;
        dm.isControlable = this.isControlable;
        dm.defaultBrowsableEtat = this.defaultBrowsableEtat;
        dm.collectivitePath = this.collectivitePath.clone();
        dm.budgetPath = this.budgetPath.clone();
        dm.persistenceConfigFile = this.persistenceConfigFile;
        for (DeleteFilterModel deleteFilterModel : this.deleteFilters) {
            try {
                dm.addChild(deleteFilterModel.clone(), "delete-filter");
            }
            catch (Throwable t) {}
        }
        for (Pair pair : this.defaultBudgets) {
            dm.defaultBudgets.add(pair);
        }
        dm.groupMenuItems = this.groupMenuItems;
        dm.namespaces = this.namespaces.clone();
        for (SpecialKeyModel specialKeyModel : this.specialKeys) {
            dm.specialKeys.add(specialKeyModel.clone());
        }
        dm.controlConfigFile = this.controlConfigFile;
        if (this.parameters != null) {
            dm.parameters = this.parameters.clone();
        }
        return dm;
    }

    public Vector<SpecialKeyModel> getSpecialKeys() {
        return this.specialKeys;
    }

    public boolean isBrowsable() {
        return this.browsable;
    }

    public EtatModel getDefaultBrowsableEtat() {
        if (this.defaultBrowsableEtat != null) {
            return this.getEtatById(this.defaultBrowsableEtat);
        }
        return this.etats.elementAt(0);
    }

    public DeleteFilterModel getDeleteFilter(int specialKeySource) {
        for (DeleteFilterModel dfm : this.deleteFilters) {
            if (dfm.getPos() != specialKeySource) continue;
            return dfm;
        }
        return null;
    }

    @Deprecated
    public String getReferentielImportTransfo() {
        return this.referentielImportTransfo;
    }

    public String getPersistenceConfigFile() {
        return this.persistenceConfigFile;
    }

    public void setPersistenceConfigFile(String persistenceConfigFile) {
        this.persistenceConfigFile = persistenceConfigFile;
    }

    public NamespaceModel getNamespaces() {
        return this.namespaces;
    }

    public boolean isGroupMenuItem() {
        return this.groupMenuItems;
    }

    @Override
    public EnvironmentDomain getChildAt(int domain, int pos) {
        return this.etats.elementAt(pos);
    }

    @Override
    public boolean hasEnvironment(int domain) {
        return false;
    }

    @Override
    public Enumeration<VariableModel> getVariables(int domain) {
        return null;
    }

    @Override
    public int getChildCount(int domain) {
        return this.etats.size();
    }

    @Override
    public Enumeration<EnvironmentDomain> children(int domain) {
        return this.vEtats.elements();
    }

    @Override
    public Object getValue(String path) throws DataConfigurationException {
        String sTmp = path.startsWith("/") ? path.substring(1) : path;
        if (sTmp.startsWith("etat")) {
            int pos = sTmp.indexOf(47);
            String next = sTmp.substring(pos);
            String condition = sTmp.substring("etat".length(), pos);
            if (condition.startsWith("[") && condition.endsWith("]")) {
                condition = condition.substring(1, condition.length() - 1).trim();
            }
            if (condition.startsWith("@id=")) {
                String etatId = condition.substring(5, condition.length() - 1);
                EtatModel em = this.getEtatById(etatId);
                return em.getValue(next);
            }
            throw new DataConfigurationException("can only get etat by id");
        }
        throw new DataConfigurationException("from document, you can only access to etat(s)");
    }

    @Override
    public void setValue(String path, Object value) throws DataConfigurationException {
        String condition;
        String next;
        String sTmp = path.startsWith("/") ? path.substring(1) : path;
        if (sTmp.startsWith("etat")) {
            int pos = sTmp.indexOf(47);
            next = sTmp.substring(pos);
            condition = sTmp.substring("etat".length(), pos);
            if (condition.startsWith("[") && condition.endsWith("]")) {
                condition = condition.substring(1, condition.length() - 1).trim();
            }
            if (!condition.startsWith("@id=")) {
                throw new DataConfigurationException("can only get etat by id");
            }
        } else {
            throw new DataConfigurationException("from document, you can only access to etat(s)");
        }
        String etatId = condition.substring(5, condition.length() - 1);
        EtatModel em = this.getEtatById(etatId);
        em.setValue(next, value);
    }

    public Vector<ElementModel> getElementsById(String elementId) {
        Vector<ElementModel> ret = new Vector<ElementModel>();
        for (EtatModel em : this.etats) {
            ElementModel el = em.getElementById(elementId);
            if (el == null) continue;
            ret.add(el);
        }
        return ret;
    }

    public String getControlConfigFile() {
        return this.controlConfigFile;
    }

    public void setBudgetPath(RecherchePaireModel budgetPath) {
        this.budgetPath = budgetPath;
    }

    public void setCollectivitePath(RecherchePaireModel collectivitePath) {
        this.collectivitePath = collectivitePath;
    }

    public ParametersModel getParameters() {
        return this.parameters;
    }
}

