/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.common.config;

import fr.gouv.finances.cp.utils.xml.marshal.InvalidXmlDefinition;
import fr.gouv.finances.cp.utils.xml.marshal.XmlAttributes;
import fr.gouv.finances.cp.utils.xml.marshal.XmlMarshallable;
import fr.gouv.finances.cp.utils.xml.marshal.XmlOutputter;
import fr.gouv.finances.cp.xemelios.common.config.BlankModel;
import fr.gouv.finances.cp.xemelios.common.config.PropertyModel;
import fr.gouv.finances.cp.xemelios.common.config.XPathModel;
import java.util.HashMap;
import java.util.Vector;
import org.apache.commons.lang.StringEscapeUtils;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CritereModel
implements XmlMarshallable {
    public static final transient String TAG = "critere";
    public static final int MODE_NORMAL = 1;
    public static final int MODE_ANOMALY = 2;
    public static final int MODE_BOTH = 3;
    private String libelle;
    private String id;
    private String idAffichage;
    private boolean displayOptional = false;
    private XPathModel path;
    private Vector<XmlMarshallable> inputs = new Vector();
    private Vector<PropertyModel> valeurs = new Vector();
    private HashMap<String, PropertyModel> properties = new HashMap();
    private BlankModel blank = null;
    private int mode = 3;
    private Object additionnalData = null;

    public boolean equals(Object o) {
        if (o instanceof CritereModel) {
            CritereModel other = (CritereModel)o;
            return other.getLibelle().equals(this.getLibelle());
        }
        return false;
    }

    public CritereModel(String tagName) {
    }

    public void addCharacterData(String cData) throws SAXException {
    }

    public void addChild(XmlMarshallable child, String tagName) throws SAXException {
        if ("path".equals(tagName)) {
            this.path = (XPathModel)child;
        } else if ("property".equals(tagName)) {
            PropertyModel pm = (PropertyModel)child;
            this.valeurs.add(pm);
            this.properties.put(pm.getName(), pm);
        } else if ("blank".equals(tagName)) {
            this.blank = (BlankModel)child;
        } else {
            this.inputs.add(child);
        }
    }

    public XmlMarshallable getAttributes(XmlAttributes attributes) throws SAXException {
        String sTmp;
        this.libelle = attributes.getValue("libelle");
        this.id = attributes.getValue("id");
        this.idAffichage = attributes.getValue("optional-display-id");
        if (attributes.getValue("optional-display") != null && attributes.getValue("optional-display").equals("true")) {
            this.displayOptional = true;
        }
        if ((sTmp = attributes.getValue("mode")) != null) {
            if ("both".equals(sTmp)) {
                this.mode = 3;
            } else if ("anomaly".equals(sTmp)) {
                this.mode = 2;
            } else if ("normal".equals(sTmp)) {
                this.mode = 1;
            }
        }
        return this;
    }

    public void marshall(XmlOutputter output) {
        output.startTag(TAG);
        output.addAttribute("id", this.getId());
        output.addAttribute("libelle", StringEscapeUtils.escapeXml(this.libelle));
        if (this.getIdAffichage() != null) {
            output.addAttribute("optional-display-id", this.getIdAffichage());
        }
        if (this.isDisplayOptional()) {
            output.addAttribute("optional-display", "true");
        }
        this.path.marshall(output);
        if (this.hasBlank()) {
            this.blank.marshall(output);
        }
        for (XmlMarshallable xm : this.inputs) {
            xm.marshall(output);
        }
        for (PropertyModel pm : this.valeurs) {
            pm.marshall(output);
        }
        output.endTag(TAG);
    }

    public void validate() throws InvalidXmlDefinition {
        if (this.id == null || this.id.length() == 0) {
            throw new InvalidXmlDefinition("Element critere must have a unique id (" + (this.libelle == null ? "null" : this.libelle) + ")");
        }
        this.path.validate();
        for (XmlMarshallable xm : this.inputs) {
            xm.validate();
        }
    }

    public Vector<XmlMarshallable> getInputs() {
        return this.inputs;
    }

    public String getLibelle() {
        return this.libelle;
    }

    public XPathModel getPath() {
        return this.path;
    }

    public String toString() {
        return this.getLibelle();
    }

    public Vector<PropertyModel> getValeurs() {
        return this.valeurs;
    }

    public CritereModel clone() {
        CritereModel cm = new CritereModel(TAG);
        cm.libelle = this.libelle;
        cm.id = this.id;
        cm.idAffichage = this.idAffichage;
        if (this.path != null) {
            cm.path = this.path.clone();
        }
        cm.displayOptional = this.displayOptional;
        for (XmlMarshallable xm : this.inputs) {
            cm.inputs.add((XmlMarshallable)xm.clone());
        }
        if (this.hasBlank()) {
            cm.blank = this.blank.clone();
        }
        cm.mode = this.mode;
        return cm;
    }

    public String getId() {
        return this.id;
    }

    public String getIdAffichage() {
        return this.idAffichage;
    }

    public Object getAdditionnalData() {
        return this.additionnalData;
    }

    public void setAdditionnalData(Object additionnalData) {
        this.additionnalData = additionnalData;
    }

    public String getProperty(String propName) {
        PropertyModel pm = this.properties.get(propName);
        if (pm != null) {
            return pm.getValue();
        }
        return null;
    }

    public boolean hasBlank() {
        return this.blank != null;
    }

    public boolean isDisplayOptional() {
        return this.displayOptional;
    }

    public void setDisplayOptional(boolean d) {
        this.displayOptional = d;
    }

    public int getMode() {
        return this.mode;
    }
}

