/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.common.config;

import fr.gouv.finances.cp.utils.Amount;
import fr.gouv.finances.cp.utils.xml.marshal.InvalidXmlDefinition;
import fr.gouv.finances.cp.utils.xml.marshal.XmlAttributes;
import fr.gouv.finances.cp.utils.xml.marshal.XmlMarshallable;
import fr.gouv.finances.cp.utils.xml.marshal.XmlOutputter;
import fr.gouv.finances.cp.xemelios.common.config.XPathModel;
import fr.gouv.finances.cp.xemelios.ui.resulttable.PjRefHandler;
import java.util.Date;
import org.apache.commons.lang.StringEscapeUtils;
import org.xml.sax.SAXException;

public class ChampModel
implements XmlMarshallable {
    public static final transient String DATATYPE_PJ = "pj-list";
    public static final transient String DATATYPE_DECIMAL = "decimal";
    public static final transient String DATATYPE_AMOUNT = "amount";
    public static final transient String DATATYPE_INTEGER = "integer";
    public static final transient String DATATYPE_DATE = "date";
    public static final transient String TAG = "champ";
    private String tag;
    private String id;
    private String libelle;
    private String datatype;
    private XPathModel path;
    private Class classToReturn = null;
    private boolean checked = false;
    private boolean afficheDefaut = true;
    private boolean sommePossible = false;

    public ChampModel(String tagName) {
        this.tag = tagName;
    }

    public void addCharacterData(String cData) throws SAXException {
    }

    public void addChild(XmlMarshallable child, String tagName) throws SAXException {
        if ("valeur".equals(tagName)) {
            this.path = (XPathModel)child;
        }
    }

    public XmlMarshallable getAttributes(XmlAttributes attributes) throws SAXException {
        this.id = attributes.getValue("id");
        this.libelle = attributes.getValue("libelle");
        this.datatype = attributes.getValue("datatype");
        if (this.datatype == null) {
            this.datatype = "string";
        }
        this.checked = attributes.getBooleanValue("checked");
        if (attributes.getValue("default-display") != null) {
            this.afficheDefaut = attributes.getBooleanValue("default-display");
        }
        this.sommePossible = attributes.getBooleanValue("aggregate");
        return this;
    }

    public void marshall(XmlOutputter output) {
        output.startTag(this.tag);
        output.addAttribute("id", StringEscapeUtils.escapeXml(this.id));
        output.addAttribute("libelle", StringEscapeUtils.escapeXml(this.libelle));
        output.addAttribute("datatype", StringEscapeUtils.escapeXml(this.datatype));
        if (this.checked) {
            output.addAttribute("checked", "true");
        }
        if (!this.afficheDefaut) {
            output.addAttribute("default-display", "false");
        }
        if (this.sommePossible) {
            output.addAttribute("aggregate", "true");
        }
        this.path.marshall(output);
        output.endTag(this.tag);
    }

    public void validate() throws InvalidXmlDefinition {
        if (this.id == null) {
            throw new InvalidXmlDefinition("pas de id dans champ");
        }
        this.path.validate();
    }

    public String getId() {
        return this.id;
    }

    public String getLibelle() {
        return this.libelle;
    }

    public XPathModel getPath() {
        return this.path;
    }

    public Class getDataClass() {
        if (this.classToReturn == null) {
            this.classToReturn = DATATYPE_INTEGER.equalsIgnoreCase(this.datatype) ? Integer.class : (DATATYPE_DECIMAL.equalsIgnoreCase(this.datatype) ? Float.class : (DATATYPE_DATE.equalsIgnoreCase(this.datatype) ? Date.class : (DATATYPE_AMOUNT.equalsIgnoreCase(this.datatype) ? Amount.class : (DATATYPE_PJ.equalsIgnoreCase(this.datatype) ? PjRefHandler.class : String.class))));
        }
        return this.classToReturn;
    }

    public ChampModel clone() {
        ChampModel cm = new ChampModel(this.tag);
        cm.id = this.id;
        cm.libelle = this.libelle;
        cm.datatype = this.datatype;
        cm.path = this.path.clone();
        cm.checked = this.checked;
        cm.afficheDefaut = this.afficheDefaut;
        cm.sommePossible = this.sommePossible;
        return cm;
    }

    public boolean equals(Object other) {
        if (other instanceof ChampModel) {
            return ((ChampModel)other).id.equals(this.id);
        }
        return this.equals(other);
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setChecked(boolean bChk) {
        this.checked = bChk;
    }

    public boolean isAfficheDefaut() {
        return this.afficheDefaut;
    }

    public void setAfficheDefaut(boolean affDef) {
        this.afficheDefaut = affDef;
    }

    public boolean isSommePossible() {
        return this.sommePossible;
    }

    public void setSommePossible(boolean somPos) {
        this.sommePossible = somPos;
    }

    public String getDatatype() {
        return this.datatype;
    }
}

