/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.utils.xml.xpath;

import java.util.Arrays;
import java.util.List;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionException;
import org.w3c.dom.NodeList;

public class FuncStringInList
implements XPathFunction {
    public static final transient String FUNCTION_NAME = "InList";
    private static final long serialVersionUID = 3690756198181974327L;

    public Object evaluate(List args) throws XPathFunctionException {
        if (args.size() < 2) {
            throw new XPathFunctionException("InList requires at least 2 parameters");
        }
        Object o1 = args.get(0);
        String valueToSearch = null;
        if (o1 instanceof NodeList) {
            NodeList nl = (NodeList)o1;
            valueToSearch = nl.item(0).getNodeValue();
        } else {
            valueToSearch = (String)o1;
        }
        Object[] data = new String[args.size() - 1];
        for (int i = 0; i < args.size() - 1; ++i) {
            String s = null;
            Object o = args.get(i + 1);
            if (o instanceof NodeList) {
                NodeList nl = (NodeList)o;
                s = nl.item(0).getNodeValue();
            } else {
                s = (String)o;
            }
            data[i] = s;
        }
        Arrays.sort(data);
        int ret = Arrays.binarySearch(data, valueToSearch);
        return ret >= 0 ? Boolean.TRUE : Boolean.FALSE;
    }
}

