/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.utils.xml.xpath;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.List;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionException;
import org.w3c.dom.NodeList;

public class FuncEscapeUri
implements XPathFunction {
    public static final transient String FUNCTION_NAME = "escape-uri";
    private static final long serialVersionUID = 3545795485781537336L;

    public Object evaluate(List args) throws XPathFunctionException {
        if (args.size() != 2) {
            throw new XPathFunctionException("escape-uri requires exactly 2 parameters");
        }
        Object o1 = args.get(0);
        String s1 = null;
        if (o1 instanceof NodeList) {
            NodeList nl = (NodeList)o1;
            s1 = nl.item(0).getNodeValue();
        } else {
            s1 = (String)o1;
        }
        Object o2 = args.get(1);
        boolean escapeIt = false;
        if (o2 instanceof NodeList) {
            NodeList nl = (NodeList)o2;
            escapeIt = Boolean.valueOf(nl.item(0).getNodeValue());
        } else {
            Boolean b = (Boolean)o2;
            escapeIt = b;
        }
        String ret = null;
        if (escapeIt) {
            try {
                ret = URLDecoder.decode(s1, "UTF-8");
            }
            catch (UnsupportedEncodingException eEx) {}
        } else {
            try {
                ret = URLEncoder.encode(s1, "UTF-8");
            }
            catch (UnsupportedEncodingException eEx) {
                // empty catch block
            }
        }
        return ret;
    }
}

