/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.utils.xml.xpath;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionException;
import org.w3c.dom.NodeList;

public class FuncDateEquals
implements XPathFunction {
    public static final transient String FUNCTION_NAME = "DateEquals";
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");

    public Object evaluate(List args) throws XPathFunctionException {
        Date d2;
        Date d1;
        NodeList nl;
        if (args.size() != 2) {
            throw new XPathFunctionException("DateEquals requires exactly 2 parameters");
        }
        Object o1 = args.get(0);
        Object o2 = args.get(1);
        String s1 = null;
        String s2 = null;
        if (o1 instanceof NodeList) {
            nl = (NodeList)o1;
            s1 = nl.item(0).getNodeValue();
        } else {
            s1 = (String)o1;
        }
        if (o2 instanceof NodeList) {
            nl = (NodeList)o2;
            s2 = nl.item(0).getNodeValue();
        } else {
            s2 = (String)o2;
        }
        if (s1 == null && s2 == null) {
            return Boolean.TRUE;
        }
        if (s1 == null || s2 == null) {
            return Boolean.FALSE;
        }
        try {
            d1 = this.sdf.parse(s1);
        }
        catch (ParseException pEx) {
            return Boolean.FALSE;
        }
        try {
            d2 = this.sdf.parse(s2);
        }
        catch (ParseException pEx) {
            return Boolean.FALSE;
        }
        return new Boolean(d1.equals(d2));
    }
}

