/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.utils.xml.dompath;

import fr.gouv.finances.cp.utils.xml.InvalidPathExpressionException;
import fr.gouv.finances.cp.utils.xml.PathNotFoundException;
import java.util.StringTokenizer;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DomPath {
    private static final Logger logger = Logger.getLogger(DomPath.class);
    private Stepper[] path = null;

    public DomPath(String pathExpression, NamespaceContext ns) throws InvalidPathExpressionException {
        StringTokenizer tokizer = new StringTokenizer(pathExpression, "/", false);
        int length = tokizer.countTokens();
        if (length == 0) {
            throw new InvalidPathExpressionException("empty");
        }
        this.path = new Stepper[length];
        int i = 0;
        --length;
        while (tokizer.hasMoreTokens()) {
            this.path[i] = new Stepper(tokizer.nextToken(), ns);
            if (i < length) {
                if (this.path[i].getType() == 2) {
                    throw new InvalidPathExpressionException("only the last element can be an attribute: " + pathExpression);
                }
            } else if (this.path[i].getType() == 1 && !this.path[i].elementName.equals("text()") && !this.path[i].elementName.equals("name()")) {
                throw new InvalidPathExpressionException("the last element must be an attribute or a text(): " + pathExpression);
            }
            ++i;
        }
    }

    public Object getValue(Node node, boolean catchException) throws PathNotFoundException {
        try {
            Object o = node;
            for (Stepper stepper : this.path) {
                if (o == null || !(o instanceof Node)) continue;
                o = stepper.step((Node)o);
            }
            return o == null ? null : o.toString();
        }
        catch (PathNotFoundException pnfEx) {
            if (!catchException) {
                throw pnfEx;
            }
            return null;
        }
    }

    private class Stepper {
        public static final int TYPE_ELEMENT = 1;
        public static final int TYPE_ATTRIBUTE = 2;
        private String elementName = null;
        private int elementRank = 0;
        private int type = 0;
        private NamespaceContext ns;

        public Stepper(String pathElement, NamespaceContext ns) throws InvalidPathExpressionException {
            this.ns = ns;
            if (pathElement.startsWith("@")) {
                this.type = 2;
                this.elementName = pathElement.substring(1);
                if (this.elementName == null || this.elementName.length() == 0) {
                    throw new InvalidPathExpressionException("attribute name can not be empty");
                }
                if (this.elementName.indexOf(42) >= 0) {
                    throw new InvalidPathExpressionException("attribute name can not contain *");
                }
            } else {
                this.type = 1;
                String s = pathElement;
                if (s.indexOf(91) >= 0) {
                    String inner = s.substring(s.indexOf(91) + 1, s.indexOf(93));
                    System.out.println(inner);
                    int rank = 1;
                    if (inner.length() > 0) {
                        try {
                            rank = Integer.parseInt(inner);
                        }
                        catch (NumberFormatException nfEx) {
                            throw new InvalidPathExpressionException(inner + " is not a valid rank");
                        }
                    }
                    if (rank == 0) {
                        throw new InvalidPathExpressionException("rank can not be lower than 1");
                    }
                    this.elementRank = rank - 1;
                    s = s.substring(0, s.indexOf(91));
                }
                this.elementName = s;
                if (this.elementName == null || this.elementName.length() == 0) {
                    throw new InvalidPathExpressionException("element name can not be empty");
                }
                if (this.elementName.indexOf(42) >= 0) {
                    throw new InvalidPathExpressionException("element name can not contain *");
                }
            }
        }

        public int getType() {
            return this.type;
        }

        public Object step(Node node) throws PathNotFoundException {
            QName qn = this.getQName(this.elementName, this.ns);
            if (this.type == 1) {
                Element el = (Element)node;
                if ("text()".equals(this.elementName)) {
                    return el.getTextContent();
                }
                if ("name()".equals(this.elementName)) {
                    return el.getNodeName();
                }
                Node ret = null;
                if ("..".equals(qn.getLocalPart())) {
                    ret = node.getParentNode();
                } else {
                    NodeList lst = el.getElementsByTagNameNS(qn.getNamespaceURI(), qn.getLocalPart());
                    int parsingRank = 0;
                    for (int i = 0; i < lst.getLength(); ++i) {
                        Node n = lst.item(i);
                        if (parsingRank == this.elementRank) {
                            ret = n;
                            break;
                        }
                        ++parsingRank;
                        if (ret != null) break;
                    }
                }
                if (ret == null) {
                    throw new PathNotFoundException(this.elementName + "{" + this.elementRank + "} not found under" + node.getNodeName() + ".");
                }
                return ret;
            }
            NamedNodeMap map = node.getAttributes();
            if (map == null || map.getLength() == 0) {
                throw new PathNotFoundException("no " + this.elementName + " attribute in " + node.getNodeName());
            }
            Node attr = map.getNamedItemNS(qn.getNamespaceURI(), qn.getLocalPart());
            if (attr == null) {
                attr = map.getNamedItem(qn.getLocalPart());
            }
            if (attr != null) {
                return attr.getNodeValue();
            }
            logger.error((Object)(qn + " not found on " + node.getNodeName()));
            for (int i = 0; i < map.getLength(); ++i) {
                Node n = map.item(i);
                logger.debug((Object)("{" + n.getNamespaceURI() + "}" + n.getLocalName()));
            }
            return null;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.type == 1 ? "ELEMENT " : "ATTRIBUTE ").append(this.elementName).append(" rank=").append(this.elementRank);
            return sb.toString();
        }

        private QName getQName(String spec, NamespaceContext ns) {
            QName ret = null;
            int pos = spec.indexOf(58);
            if (pos >= 0) {
                String prefix = spec.substring(0, pos);
                String localName = spec.substring(pos + 1);
                String uri = ns.getNamespaceURI(prefix);
                ret = new QName(uri, localName, prefix);
            } else if (this.getType() == 1) {
                String uri = ns.getNamespaceURI("");
                ret = new QName(uri, spec);
            } else {
                ret = new QName(spec);
            }
            return ret;
        }
    }
}

