/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.utils.xml.certs;

import java.io.ByteArrayInputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import sun.misc.BASE64Decoder;

public class Certificate509 {
    private static final Logger logger = Logger.getLogger(Certificate509.class);

    public static String extractCN(String base64) {
        BASE64Decoder decoder = new BASE64Decoder();
        String emetteur = "";
        try {
            byte[] buffer = decoder.decodeBuffer(base64);
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream bais = new ByteArrayInputStream(buffer);
            X509Certificate cert = (X509Certificate)factory.generateCertificate(bais);
            Certificate509.printCert(cert);
            String dn = cert.getSubjectX500Principal().getName();
            StringTokenizer tokenizer = new StringTokenizer(dn, ",");
            while (tokenizer.hasMoreTokens()) {
                String tok = tokenizer.nextToken();
                if (!tok.startsWith("CN=")) continue;
                emetteur = tok.substring(3);
            }
        }
        catch (Exception ioEx) {
            logger.error((Object)("unable to decode " + base64));
        }
        return emetteur;
    }

    public static String extractEMail(String base64) {
        BASE64Decoder decoder = new BASE64Decoder();
        String emetteur = "";
        try {
            byte[] buffer = decoder.decodeBuffer(base64);
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream bais = new ByteArrayInputStream(buffer);
            X509Certificate cert = (X509Certificate)factory.generateCertificate(bais);
            String dn = cert.getSubjectX500Principal().toString();
            StringTokenizer tokenizer = new StringTokenizer(dn, ",");
            while (tokenizer.hasMoreTokens()) {
                String tok = tokenizer.nextToken();
                if (!tok.startsWith("EMAILADDRESS=")) continue;
                emetteur = tok.substring("EMAILADDRESS=".length());
            }
        }
        catch (Exception ioEx) {
            logger.error((Object)("unable to decode " + base64));
        }
        return emetteur;
    }

    private static void printCert(X509Certificate cert) {
        logger.debug((Object)("issuerDN.toString()=" + ((Object)cert.getIssuerDN()).toString()));
        logger.debug((Object)("issuerDN.getName()=" + cert.getIssuerDN().getName()));
        logger.debug((Object)("X500principal.toString()=" + cert.getIssuerX500Principal().toString()));
        logger.debug((Object)("X500principal.getName()=" + cert.getIssuerX500Principal().getName()));
        logger.debug((Object)("subjectDn.toString()=" + ((Object)cert.getSubjectDN()).toString()));
        logger.debug((Object)("subjectDn.getName()=" + cert.getSubjectDN().getName()));
        logger.debug((Object)("subjectX500principal.toString()=" + cert.getSubjectX500Principal().toString()));
        logger.debug((Object)("subjectX500principal.getName()=" + cert.getSubjectX500Principal().getName()));
        try {
            Collection<List<?>> coll = cert.getIssuerAlternativeNames();
            if (coll != null) {
                for (List<?> l : coll) {
                    for (Object o : l) {
                        logger.debug((Object)("issuerAltName=" + o.toString()));
                    }
                }
            }
            Collection<List<?>> coll2 = cert.getSubjectAlternativeNames();
            if (coll != null) {
                for (List<?> l : coll2) {
                    for (Object o : l) {
                        logger.debug((Object)("subjectAltName=" + o.toString()));
                    }
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

