/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.utils.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.text.DecimalFormat;
import javax.swing.JComponent;

public class RamViewer
extends JComponent {
    private static final long serialVersionUID = 1L;
    private Runner currentRunner = null;

    public RamViewer() {
        this.initComponents();
    }

    protected void initComponents() {
        this.setPreferredSize(new Dimension(100, 20));
        this.currentRunner = new Runner(this);
        this.currentRunner.start();
    }

    public void paint(Graphics g) {
        if (!this.isVisible()) {
            return;
        }
        int width = this.getSize().width;
        int height = this.getSize().height;
        Graphics offG = g;
        if (g == null) {
            return;
        }
        long freeRam = Runtime.getRuntime().freeMemory();
        long totalRam = Runtime.getRuntime().totalMemory();
        int freeWidth = (int)((long)width * freeRam / totalRam);
        int totalWidth = width - freeWidth;
        offG.setColor(this.getParent().getBackground());
        offG.fillRect(0, 0, width, height);
        offG.setColor(new Color(0xCC0000));
        offG.fillRect(0, 0, totalWidth, height);
        offG.setColor(new Color(52224));
        offG.fillRect(totalWidth, 0, freeWidth, height);
        Font f = new Font("Arial", 1, 12);
        FontMetrics fm = this.getFontMetrics(f);
        offG.setFont(f);
        DecimalFormat df = new DecimalFormat("0.0' MB'");
        String s = df.format((double)(totalRam - freeRam) / 1024.0 / 1024.0) + " / " + df.format((double)totalRam / 1024.0 / 1024.0);
        offG.setColor(Color.WHITE);
        offG.drawString(s, (width - fm.stringWidth(s)) / 2, (int)((double)height * 0.8));
        offG.setColor(Color.BLACK);
        offG.drawRect(0, 0, width - 1, height - 1);
    }

    protected class Runner
    extends Thread {
        private RamViewer viewer = null;
        private boolean stop = false;

        public Runner(RamViewer viewer) {
            this.viewer = viewer;
        }

        public void run() {
            this.setPriority(10);
            while (!this.stop) {
                this.viewer.paint(this.viewer.getGraphics());
                try {
                    Runner.sleep(1000L);
                }
                catch (Throwable throwable) {}
            }
        }

        public void stopIt() {
            this.stop = true;
        }
    }
}

