/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.controls.pesv2.tie;

import fr.gouv.finances.cp.xemelios.controls.AbstractUnitControl;
import fr.gouv.finances.cp.xemelios.controls.Anomalie;
import fr.gouv.finances.cp.xemelios.controls.IdGenerator;
import fr.gouv.finances.cp.xemelios.controls.Node;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TIE06
extends AbstractUnitControl {
    private static final Logger logger = Logger.getLogger(TIE06.class);
    public static final transient String CTRL_ID = "TIE06";
    private Vector<Anomalie> anos = null;
    private Hashtable<String, Object> hParams;
    private String docId = null;
    private String nodeId = null;
    private static final String ON_RETURN_ANOMALIES = "Piece";
    private String bord_Exer = "";
    private String bord_IdBord = "";
    private String bord_TypBord = "";
    private String piece_IdPce = "";
    private String ligne_IdLigne = "";
    private String idBancInt = "";
    private String idCpte = "";
    private String codeEtab = "";
    private String codeGuic = "";
    private String cleRib = "";
    private static final String MSG_BORD_NUM = "#BORD_NUM#";
    private static final String MSG_BORD_EXER = "#BORD_EXER#";
    private static final String MSG_BORD_TYPBORD = "#BORD_TYPBORD#";
    private static final String MSG_PIECE_IDPCE = "#PIECE_IDPCE#";
    private static final String MSG_LIGNE_IDLIGNE = "#LIGNE_IDLIGNE#";
    private static final String MSG_CPTE_IDBANCINT = "#CPTE_IDBANCINT#";
    private static final String MSG_CPTE_IDCPTE = "#CPTE_IDCPTE#";
    private static final String MSG_CPTE_CODEETAB = "#CPTE_CODEETAB#";
    private static final String MSG_CPTE_CODEGUIC = "#CPTE_CODEGUIC#";
    private static final String MSG_CPTE_CLERIB = "#CPTE_CLERIB#";
    private static final String CHEMIN_BLOCBORDEREAU = "/Bordereau/BlocBordereau/";
    private static final String CHEMIN_BLOCBORDEREAU_EXER = "/Bordereau/BlocBordereau/Exer/";
    private static final String CHEMIN_BLOCBORDEREAU_IDBORD = "/Bordereau/BlocBordereau/IdBord/";
    private static final String CHEMIN_BLOCBORDEREAU_TYPBORD = "/Bordereau/BlocBordereau/TypBord/";
    private static final String RECETTE = "PES_RecetteAller";
    private static final String DEPENSE = "PES_DepenseAller";
    private boolean depense = false;
    private static String CHEMIN_BLOCPIECE = "";
    private static String CHEMIN_BLOCPIECE_IDPCE = "";
    private static final String R_CHEMIN_BLOCPIECE = "/Bordereau/Piece/BlocPiece/";
    private static final String R_CHEMIN_BLOCPIECE_IDPCE = "/Bordereau/Piece/BlocPiece/IdPce/";
    private static final String D_CHEMIN_BLOCPIECE = "/Bordereau/Piece/BlocPiece/";
    private static final String D_CHEMIN_BLOCPIECE_IDPCE = "/Bordereau/Piece/BlocPiece/InfoPce/IdPce/";
    private static String CHEMIN_INFOLIGNEPIECE = "";
    private static String CHEMIN_INFOLIGNEPIECE_IDLIGNE = "";
    private static final String R_CHEMIN_INFOLIGNEPIECE = "/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePiece/";
    private static final String R_CHEMIN_INFOLIGNEPIECE_IDLIGNE = "/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePiece/IdLigne/";
    private static final String D_CHEMIN_INFOLIGNEPIECE = "/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePce/";
    private static final String D_CHEMIN_INFOLIGNEPIECE_IDLIGNE = "/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePce/IdLigne/";
    private static final String CHEMIN_COMPTE = "/Bordereau/Piece/LigneDePiece/Tiers/CpteBancaire/";
    private static final String CHEMIN_COMPTE_IDBANCINT = "/Bordereau/Piece/LigneDePiece/Tiers/CpteBancaire/IdBancInt/";
    private static final String CHEMIN_COMPTE_IDCPTE = "/Bordereau/Piece/LigneDePiece/Tiers/CpteBancaire/IdCpte/";
    private static final String CHEMIN_COMPTE_CODEETAB = "/Bordereau/Piece/LigneDePiece/Tiers/CpteBancaire/CodeEtab/";
    private static final String CHEMIN_COMPTE_CODEGUIC = "/Bordereau/Piece/LigneDePiece/Tiers/CpteBancaire/CodeGuic/";
    private static final String CHEMIN_COMPTE_CLERIB = "/Bordereau/Piece/LigneDePiece/Tiers/CpteBancaire/CleRib/";
    private static final String FIN_CPTE = "CpteBancaire";

    public void startDocument() throws SAXException {
        logger.info((Object)"In TIE06");
    }

    public void setDocId(String docID) {
        this.docId = docID;
    }

    public void startElement(String uri, String localName, String qName, Attributes atts, String xpath) {
        if (xpath.indexOf(DEPENSE) != -1) {
            this.depense = true;
            CHEMIN_BLOCPIECE = "/Bordereau/Piece/BlocPiece/";
            CHEMIN_BLOCPIECE_IDPCE = D_CHEMIN_BLOCPIECE_IDPCE;
            CHEMIN_INFOLIGNEPIECE = D_CHEMIN_INFOLIGNEPIECE;
            CHEMIN_INFOLIGNEPIECE_IDLIGNE = D_CHEMIN_INFOLIGNEPIECE_IDLIGNE;
        }
        if (xpath.indexOf(RECETTE) != -1) {
            this.depense = false;
            CHEMIN_BLOCPIECE = "/Bordereau/Piece/BlocPiece/";
            CHEMIN_BLOCPIECE_IDPCE = R_CHEMIN_BLOCPIECE_IDPCE;
            CHEMIN_INFOLIGNEPIECE = R_CHEMIN_INFOLIGNEPIECE;
            CHEMIN_INFOLIGNEPIECE_IDLIGNE = R_CHEMIN_INFOLIGNEPIECE_IDLIGNE;
        }
        if (xpath.endsWith(CHEMIN_BLOCBORDEREAU)) {
            this.bord_TypBord = "";
            this.bord_IdBord = "";
            this.bord_Exer = "";
        }
        if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_EXER)) {
            this.bord_Exer = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_IDBORD)) {
            this.bord_IdBord = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_TYPBORD)) {
            this.bord_TypBord = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_BLOCPIECE)) {
            this.piece_IdPce = "";
            this.anos = new Vector();
        }
        if (xpath.endsWith(CHEMIN_BLOCPIECE_IDPCE)) {
            this.piece_IdPce = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_INFOLIGNEPIECE)) {
            this.ligne_IdLigne = "";
        }
        if (xpath.endsWith(CHEMIN_INFOLIGNEPIECE_IDLIGNE)) {
            this.ligne_IdLigne = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_COMPTE)) {
            this.cleRib = "";
            this.codeGuic = "";
            this.codeEtab = "";
            this.idCpte = "";
            this.idBancInt = "";
            this.nodeId = atts.getValue("ano:node-id");
        }
        if (xpath.endsWith(CHEMIN_COMPTE_IDBANCINT)) {
            this.idBancInt = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_COMPTE_IDCPTE)) {
            this.idCpte = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_COMPTE_CODEETAB)) {
            this.codeEtab = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_COMPTE_CODEGUIC)) {
            this.codeGuic = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_COMPTE_CLERIB)) {
            this.cleRib = atts.getValue("V");
        }
    }

    public Vector<Anomalie> endElement(String uri, String localName, String qName, String xpath) throws SAXException {
        if (ON_RETURN_ANOMALIES.equals(localName)) {
            return this.anos;
        }
        if (FIN_CPTE.equals(localName)) {
            boolean err = false;
            String search0 = "^[0][0]*$";
            String search9 = "^[9][9]*$";
            StringBuffer sb = new StringBuffer();
            if (this.idBancInt != null) {
                sb.append(this.idBancInt);
            }
            if (this.idCpte != null) {
                sb.append(this.idCpte);
            }
            if (this.codeEtab != null) {
                sb.append(this.codeEtab);
            }
            if (this.codeGuic != null) {
                sb.append(this.codeGuic);
            }
            if (sb.toString().matches(search0) || sb.toString().matches(search9)) {
                err = true;
            }
            if (!err) {
                try {
                    err = !this.validateRib(this.codeEtab, this.codeGuic, this.idCpte, this.cleRib);
                }
                catch (Exception e) {
                    err = true;
                }
            }
            if (err) {
                String msg = this.getDocumentModel().getControlById(CTRL_ID).getMessage().getHtmlContent();
                msg = msg.replaceAll(MSG_BORD_NUM, this.bord_IdBord);
                msg = msg.replaceAll(MSG_BORD_EXER, this.bord_Exer);
                msg = msg.replaceAll(MSG_BORD_TYPBORD, this.bord_TypBord);
                msg = msg.replaceAll(MSG_PIECE_IDPCE, this.piece_IdPce);
                msg = msg.replaceAll(MSG_LIGNE_IDLIGNE, this.ligne_IdLigne);
                msg = msg.replaceAll(MSG_CPTE_IDBANCINT, this.idBancInt);
                msg = msg.replaceAll(MSG_CPTE_IDCPTE, this.idCpte);
                msg = msg.replaceAll(MSG_CPTE_CODEETAB, this.codeEtab);
                msg = msg.replaceAll(MSG_CPTE_CODEGUIC, this.codeGuic);
                msg = msg.replaceAll(MSG_CPTE_CLERIB, this.cleRib);
                msg = this.depense ? msg.replaceAll("#MT#", "Mandat") : msg.replaceAll("#MT#", "Titre");
                String path = "@added:primary-key='" + this.bord_Exer + "-" + this.bord_TypBord + "-" + this.bord_IdBord + "'";
                String anoId = IdGenerator.nextId();
                String libelleLien = "Bordereau " + this.bord_IdBord + " Mandat " + this.piece_IdPce;
                Hashtable<String, String> xslParams = new Hashtable<String, String>();
                xslParams.put("elementId", "");
                xslParams.put("mandatId", this.piece_IdPce);
                xslParams.put("browser-destination", "internal");
                xslParams.put("anoId", anoId);
                Anomalie ano = new Anomalie(anoId, this.getDocumentModel().getControlById(CTRL_ID).getId(), this.getDocumentModel().getControlById(CTRL_ID).getLibelle(), this.getDocumentModel().id, xpath.split("/")[1], "Bordereau", this.bord_IdBord, localName, libelleLien, msg, this.getDocumentModel().getControlById(CTRL_ID).getRegle().getHtmlContent(), this.getDocumentModel().getControlById(CTRL_ID).getSeverity(), path, xslParams);
                ano.addNode(new Node(this.nodeId));
                this.anos.add(ano);
            }
            return null;
        }
        return null;
    }

    public boolean validateRib(String codeEtab, String codeGuich, String idCpte, String cleRib) {
        boolean ret = false;
        String tabPossibles = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        char[] tabTranscrit = "123456789123456789234567890123456789".toCharArray();
        String compte = "";
        idCpte = idCpte.toUpperCase();
        for (int i = 0; i < idCpte.length(); ++i) {
            compte = compte + tabTranscrit[tabPossibles.indexOf(idCpte.charAt(i))];
        }
        double bqe = Double.parseDouble(codeEtab);
        double gui = Double.parseDouble(codeGuich);
        double cp = Double.parseDouble(compte);
        double a = bqe % 97.0;
        a = a * 100000.0 + gui;
        a %= 97.0;
        a = a * Math.pow(10.0, 11.0) + cp;
        a %= 97.0;
        a *= 100.0;
        a %= 97.0;
        a = 97.0 - a;
        double cr = Double.parseDouble(cleRib);
        ret = cr == a;
        return ret;
    }

    public void endDocument() throws SAXException {
    }

    public void characters(char[] ch, int start, int length, String xpath) {
    }

    public void ignorableWhitespace(char[] ch, int start, int length, String xpath) {
    }

    public void startPrefixMapping(String prefix, String uri, String xpath) {
    }

    public void endPrefixMapping(String prefix, String xpath) {
    }

    public void processingInstruction(String target, String data, String xpath) {
    }

    public void skippedEntity(String name, String xpath) {
    }

    public void setParameters(Hashtable<String, Object> params) {
        this.hParams = params;
    }

    public void setDocumentLocator(Locator locator) {
    }
}

