/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.controls.pesv2.rec;

import fr.gouv.finances.cp.xemelios.controls.AbstractUnitControl;
import fr.gouv.finances.cp.xemelios.controls.Anomalie;
import fr.gouv.finances.cp.xemelios.controls.IdGenerator;
import fr.gouv.finances.cp.xemelios.controls.Node;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class REC13
extends AbstractUnitControl {
    private static final Logger logger = Logger.getLogger(REC13.class);
    public static final transient String CTRL_ID = "REC13";
    private Vector<Anomalie> anos = new Vector();
    private Hashtable<String, Object> hParams;
    private String docId = null;
    private String nodeId = null;
    private static final String FIN_BORDEREAU = "/PES_RecetteAller/Bordereau/";
    private static final String FIN_PIECE = "/PES_RecetteAller/Bordereau/Piece/";
    private static final String FIN_INFO_LIGNEPIECE = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePiece/";
    private static final String ON_RETURN_ANOMALIES = "/PES_RecetteAller/Bordereau/";
    private String bord_IdBord = "";
    private String bord_ExerBord = "";
    private String bord_TypBord = "";
    private String piece_IdPce = "";
    private String piece_TypPce = "";
    private String piece_NodeIdPce = "";
    private String ligne_CodProdLoc = "";
    private String ligne_CpteTiers = "";
    private String ligne_NodeIdCodProdLoc = "";
    private String ligne_NodeIdCpteTiers = "";
    private Hashtable<String, Hashtable<String, Vector<String>>> codProdCpteTiers = new Hashtable();
    Vector<Node> anonodes = new Vector();
    private static final String MSG_BORD_NUM = "#BORD_NUM#";
    private static final String MSG_BORD_EXER = "#BORD_EXER#";
    private static final String MSG_BORD_TYPE = "#BORD_TYPBORD#";
    private static final String MSG_PIECE_ID = "#PIECE_IDPCE#";
    private static final String MSG_DETAIL = "#DETAIL_MSG#";
    private static final String CHEMIN_BLOCBORDEREAU = "/PES_RecetteAller/Bordereau/BlocBordereau/";
    private static final String CHEMIN_BLOCBORDEREAU_EXER = "/PES_RecetteAller/Bordereau/BlocBordereau/Exer/";
    private static final String CHEMIN_BLOCBORDEREAU_IDBORD = "/PES_RecetteAller/Bordereau/BlocBordereau/IdBord/";
    private static final String CHEMIN_BLOCBORDEREAU_TYPBORD = "/PES_RecetteAller/Bordereau/BlocBordereau/TypBord/";
    private static final String CHEMIN_PIECE = "/PES_RecetteAller/Bordereau/Piece/";
    private static final String CHEMIN_BLOCPIECE = "/PES_RecetteAller/Bordereau/Piece/BlocPiece/";
    private static final String CHEMIN_BLOCPIECE_IDPIECE = "/PES_RecetteAller/Bordereau/Piece/BlocPiece/IdPce/";
    private static final String CHEMIN_BLOCPIECE_TYPPIECE = "/PES_RecetteAller/Bordereau/Piece/BlocPiece/TypPce/";
    private static final String CHEMIN_LIGNE_CODPRODLOC = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePiece/CodProdLoc/";
    private static final String CHEMIN_LIGNE_CPTETIERS = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePiece/CpteTiers/";

    public void startDocument() throws SAXException {
        logger.info((Object)"In REC13");
    }

    public void setDocId(String docID) {
        this.docId = docID;
    }

    public void startElement(String uri, String localName, String qName, Attributes atts, String xpath) {
        xpath.endsWith(CHEMIN_BLOCBORDEREAU);
        if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_EXER)) {
            this.bord_ExerBord = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_IDBORD)) {
            this.bord_IdBord = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_TYPBORD)) {
            this.bord_TypBord = atts.getValue("V");
        }
        if (xpath.endsWith("/PES_RecetteAller/Bordereau/Piece/")) {
            this.anos.clear();
        }
        if (xpath.endsWith(CHEMIN_BLOCPIECE)) {
            this.ligne_CpteTiers = "";
            this.ligne_CodProdLoc = "";
            this.piece_TypPce = "";
            this.piece_IdPce = "";
            this.ligne_NodeIdCpteTiers = "";
            this.ligne_NodeIdCodProdLoc = "";
            this.piece_NodeIdPce = "";
            this.piece_NodeIdPce = atts.getValue("ano:node-id");
            this.codProdCpteTiers = new Hashtable();
            this.anonodes = new Vector();
        }
        if (xpath.endsWith(CHEMIN_BLOCPIECE_IDPIECE)) {
            this.piece_IdPce = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_BLOCPIECE_TYPPIECE)) {
            this.piece_TypPce = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_LIGNE_CODPRODLOC)) {
            this.ligne_CodProdLoc = atts.getValue("V");
            this.ligne_NodeIdCodProdLoc = atts.getValue("ano:node-id");
        }
        if (xpath.endsWith(CHEMIN_LIGNE_CPTETIERS)) {
            this.ligne_CpteTiers = atts.getValue("V");
            this.ligne_NodeIdCpteTiers = atts.getValue("ano:node-id");
        }
    }

    public Vector<Anomalie> endElement(String uri, String localName, String qName, String xpath) throws SAXException {
        if (xpath.endsWith(FIN_INFO_LIGNEPIECE) && "06".equals(this.piece_TypPce) && !"0000".equals(this.ligne_CodProdLoc)) {
            Vector<String> v;
            Hashtable<String, Vector<String>> h = this.codProdCpteTiers.get(this.ligne_CodProdLoc);
            if (h == null) {
                h = new Hashtable();
                this.codProdCpteTiers.put(this.ligne_CodProdLoc, h);
            }
            if ((v = h.get(this.ligne_CpteTiers)) == null) {
                v = new Vector();
                h.put(this.ligne_CpteTiers, v);
            }
            v.add(String.valueOf(this.ligne_NodeIdCodProdLoc) + "|" + this.ligne_NodeIdCpteTiers);
        }
        if (xpath.endsWith("/PES_RecetteAller/Bordereau/Piece/")) {
            Enumeration<String> e = this.codProdCpteTiers.keys();
            while (e.hasMoreElements()) {
                String keyCodProdLoc = e.nextElement();
                Hashtable<String, Vector<String>> h = this.codProdCpteTiers.get(keyCodProdLoc);
                if (h.keySet().size() <= 1) continue;
                StringBuffer msgListe = new StringBuffer();
                Vector<Node> anonodes = new Vector<Node>();
                Enumeration<String> e1 = h.keys();
                while (e1.hasMoreElements()) {
                    String keyCpteTiers = e1.nextElement();
                    for (String s : h.get(keyCpteTiers)) {
                        String _ligne_CodProdLoc = keyCodProdLoc;
                        String _ligne_CpteTiers = keyCpteTiers;
                        StringTokenizer st = new StringTokenizer(s, "|");
                        String _ligne_NodeIdCodProdLoc = st.nextToken();
                        String _ligne_NodeIdCpteTiers = st.nextToken();
                        msgListe.append("<li>Code Produit Loc N\u00b0 ").append(_ligne_CodProdLoc).append(" Compte de Tiers N\u00b0 ").append(_ligne_CpteTiers).append("</li>");
                        anonodes.add(new Node(_ligne_NodeIdCodProdLoc));
                    }
                }
                String msg = this.getDocumentModel().getControlById(CTRL_ID).getMessage().getHtmlContent();
                msg = msg.replaceAll(MSG_BORD_NUM, this.bord_IdBord);
                msg = msg.replaceAll(MSG_BORD_EXER, this.bord_ExerBord);
                msg = msg.replaceAll(MSG_BORD_TYPE, this.bord_TypBord);
                msg = msg.replaceAll(MSG_PIECE_ID, this.piece_IdPce);
                msg = msg.replaceAll(MSG_DETAIL, msgListe.toString());
                String path = "@added:primary-key='" + this.bord_ExerBord + "-" + this.bord_TypBord + "-" + this.bord_IdBord + "'";
                String anoId = IdGenerator.nextId();
                String libelleLien = "Bordereau " + this.bord_IdBord + " Titre " + this.piece_IdPce;
                Hashtable<String, String> xslParams = new Hashtable<String, String>();
                xslParams.put("elementId", "");
                xslParams.put("mandatId", this.piece_IdPce);
                xslParams.put("browser-destination", "internal");
                xslParams.put("anoId", anoId);
                Anomalie ano = new Anomalie(anoId, this.getDocumentModel().getControlById(CTRL_ID).getId(), this.getDocumentModel().getControlById(CTRL_ID).getLibelle(), this.getDocumentModel().id, xpath.split("/")[1], "Bordereau", this.bord_IdBord, localName, libelleLien, msg, this.getDocumentModel().getControlById(CTRL_ID).getRegle().getHtmlContent(), this.getDocumentModel().getControlById(CTRL_ID).getSeverity(), path, xslParams);
                ano.addAll(anonodes);
                this.anos.add(ano);
            }
            return this.anos;
        }
        return null;
    }

    public void endDocument() throws SAXException {
    }

    public void characters(char[] ch, int start, int length, String xpath) {
    }

    public void ignorableWhitespace(char[] ch, int start, int length, String xpath) {
    }

    public void startPrefixMapping(String prefix, String uri, String xpath) {
    }

    public void endPrefixMapping(String prefix, String xpath) {
    }

    public void processingInstruction(String target, String data, String xpath) {
    }

    public void skippedEntity(String name, String xpath) {
    }

    public void setParameters(Hashtable<String, Object> params) {
        this.hParams = params;
    }

    public void setDocumentLocator(Locator locator) {
    }
}

