/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.controls.pesv2.rec;

import fr.gouv.finances.cp.xemelios.controls.AbstractUnitControl;
import fr.gouv.finances.cp.xemelios.controls.Anomalie;
import fr.gouv.finances.cp.xemelios.controls.IdGenerator;
import fr.gouv.finances.cp.xemelios.controls.Node;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class REC04
extends AbstractUnitControl {
    private static final Logger logger = Logger.getLogger(REC04.class);
    public static final transient String CTRL_ID = "REC04";
    private Vector<Anomalie> anos = new Vector();
    private Hashtable<String, Object> hParams;
    private String docId = null;
    private ArrayList<Node> nodesId = new ArrayList();
    private static final String FIN_BORDEREAU = "/PES_RecetteAller/Bordereau/";
    private static final String ON_RETURN_ANOMALIES = "/PES_RecetteAller/Bordereau/";
    private String bord_ExerBord = "";
    private String bord_IdBord = "";
    private String bord_TypBord = "";
    private String bord_MtBordHT = "";
    private String bord_MtBordHT_nodeid = "";
    private String bord_MtBordTVA = "";
    private String bord_MtBordTVA_nodeid = "";
    private String pieces_TotalHT = "";
    private String pieces_TotalTVA = "";
    private Vector<String> pieces_TotalHT_nodesid = new Vector();
    private Vector<String> pieces_TotalTVA_nodesid = new Vector();
    private static DecimalFormat df = new DecimalFormat("############0.##");
    private static final String MSG_BORD_NUM = "#BORD_NUM#";
    private static final String MSG_BORD_EXER = "#BORD_EXER#";
    private static final String MSG_BORD_TYPEBORD = "#BORD_TYPBORD#";
    private static final String MSG_BORD_MNT = "#MT_BORD#";
    private static final String MSG_PIECE_TOTAL = "#MT_LIGNES#";
    private static final String CHEMIN_BLOCBORDEREAU = "/PES_RecetteAller/Bordereau/BlocBordereau/";
    private static final String CHEMIN_BORDEREAU = "/PES_RecetteAller/Bordereau/";
    private static final String CHEMIN_BLOCBORDEREAU_EXER = "/PES_RecetteAller/Bordereau/BlocBordereau/Exer/";
    private static final String CHEMIN_BLOCBORDEREAU_IDBORD = "/PES_RecetteAller/Bordereau/BlocBordereau/IdBord/";
    private static final String CHEMIN_BLOCBORDEREAU_TYPBORD = "/PES_RecetteAller/Bordereau/BlocBordereau/TypBord/";
    private static final String CHEMIN_BLOCBORDEREAU_MTHTBORD = "/PES_RecetteAller/Bordereau/BlocBordereau/MtBordHt/";
    private static final String CHEMIN_PIECE_MTHT = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePiece/MtHT/";
    private static final String CHEMIN_BLOCBORDEREAU_MTTVABORD = "/PES_RecetteAller/Bordereau/BlocBordereau/MtBordTVA/";
    private static final String CHEMIN_PIECE_MTTVA = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePiece/MtTVA/";

    public void startDocument() throws SAXException {
        logger.info((Object)"In REC04");
    }

    public void setDocId(String docID) {
        this.docId = docID;
    }

    public void startElement(String uri, String localName, String qName, Attributes atts, String xpath) {
        if (xpath.endsWith(CHEMIN_BLOCBORDEREAU)) {
            this.pieces_TotalTVA = "";
            this.pieces_TotalHT = "";
            this.bord_TypBord = "";
            this.bord_MtBordTVA_nodeid = "";
            this.bord_MtBordTVA = "";
            this.bord_MtBordHT_nodeid = "";
            this.bord_MtBordHT = "";
            this.bord_IdBord = "";
            this.bord_ExerBord = "";
            this.anos = new Vector();
            this.pieces_TotalHT_nodesid = new Vector();
            this.pieces_TotalTVA_nodesid = new Vector();
        }
        if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_EXER)) {
            this.bord_ExerBord = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_IDBORD)) {
            this.bord_IdBord = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_TYPBORD)) {
            this.bord_TypBord = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_MTHTBORD)) {
            this.bord_MtBordHT = atts.getValue("V");
            this.bord_MtBordHT_nodeid = atts.getValue("ano:node-id");
        }
        if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_MTTVABORD)) {
            this.bord_MtBordTVA = atts.getValue("V");
            this.bord_MtBordTVA_nodeid = atts.getValue("ano:node-id");
        }
        if (xpath.endsWith(CHEMIN_PIECE_MTHT)) {
            this.pieces_TotalHT_nodesid.add(atts.getValue("ano:node-id"));
            try {
                double tmp = 0.0;
                try {
                    tmp += Double.parseDouble(this.pieces_TotalHT);
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.pieces_TotalHT = new Double(tmp += Double.parseDouble(atts.getValue("V"))).toString();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (xpath.endsWith(CHEMIN_PIECE_MTTVA)) {
            this.pieces_TotalTVA_nodesid.add(atts.getValue("ano:node-id"));
            try {
                double tmp = 0.0;
                try {
                    tmp += Double.parseDouble(this.pieces_TotalTVA);
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.pieces_TotalTVA = new Double(tmp += Double.parseDouble(atts.getValue("V"))).toString();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public Vector<Anomalie> endElement(String uri, String localName, String qName, String xpath) throws SAXException {
        if (xpath.endsWith("/PES_RecetteAller/Bordereau/")) {
            Anomalie ano;
            Hashtable<String, String> xslParams;
            String libelleLien;
            String anoId;
            String path;
            String msg;
            try {
                double totalPieceHT;
                double totalBordHT;
                if (this.bord_MtBordHT != null && !"".equals(this.bord_MtBordHT) && (totalBordHT = Double.parseDouble(this.bord_MtBordHT)) != (totalPieceHT = Double.parseDouble(this.pieces_TotalHT))) {
                    msg = this.getDocumentModel().getControlById(CTRL_ID).getMessage().getHtmlContent();
                    msg = msg.replaceAll(MSG_BORD_NUM, this.bord_IdBord);
                    msg = msg.replaceAll(MSG_BORD_EXER, this.bord_ExerBord);
                    msg = msg.replaceAll(MSG_BORD_TYPEBORD, this.bord_TypBord);
                    msg = msg.replaceAll(MSG_BORD_MNT, " - MtBordHT= " + df.format(totalBordHT));
                    msg = msg.replaceAll(MSG_PIECE_TOTAL, " - MtHT= " + df.format(totalPieceHT));
                    path = "@added:primary-key='" + this.bord_ExerBord + "-" + this.bord_TypBord + "-" + this.bord_IdBord + "'";
                    anoId = IdGenerator.nextId();
                    libelleLien = "Bordereau " + this.bord_IdBord;
                    xslParams = new Hashtable<String, String>();
                    xslParams.put("elementId", "Bordereau");
                    xslParams.put("mandatId", "");
                    xslParams.put("browser-destination", "internal");
                    xslParams.put("anoId", anoId);
                    ano = new Anomalie(anoId, this.getDocumentModel().getControlById(CTRL_ID).getId(), this.getDocumentModel().getControlById(CTRL_ID).getLibelle(), this.getDocumentModel().id, xpath.split("/")[1], "Bordereau", this.bord_IdBord, localName, libelleLien, msg, this.getDocumentModel().getControlById(CTRL_ID).getRegle().getHtmlContent(), this.getDocumentModel().getControlById(CTRL_ID).getSeverity(), path, xslParams);
                    ano.addNode(new Node(this.bord_MtBordHT_nodeid));
                    for (String node : this.pieces_TotalHT_nodesid) {
                        ano.addNode(new Node(node));
                    }
                    this.anos.add(ano);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                double totalPieceTVA;
                double totalBordTVA;
                if (this.bord_MtBordTVA != null && !"".equals(this.bord_MtBordTVA) && (totalBordTVA = Double.parseDouble(this.bord_MtBordTVA)) != (totalPieceTVA = Double.parseDouble(this.pieces_TotalTVA))) {
                    msg = this.getDocumentModel().getControlById(CTRL_ID).getMessage().getHtmlContent();
                    msg = msg.replaceAll(MSG_BORD_NUM, this.bord_IdBord);
                    msg = msg.replaceAll(MSG_BORD_EXER, this.bord_ExerBord);
                    msg = msg.replaceAll(MSG_BORD_TYPEBORD, this.bord_TypBord);
                    msg = msg.replaceAll(MSG_BORD_MNT, " - MtBordTVA= " + df.format(totalBordTVA));
                    msg = msg.replaceAll(MSG_PIECE_TOTAL, " - MtTVA= " + df.format(totalPieceTVA));
                    path = "@added:primary-key='" + this.bord_ExerBord + "-" + this.bord_TypBord + "-" + this.bord_IdBord + "'";
                    anoId = IdGenerator.nextId();
                    libelleLien = "Bordereau " + this.bord_IdBord;
                    xslParams = new Hashtable();
                    xslParams.put("elementId", "Bordereau");
                    xslParams.put("mandatId", "");
                    xslParams.put("browser-destination", "internal");
                    xslParams.put("anoId", anoId);
                    ano = new Anomalie(anoId, this.getDocumentModel().getControlById(CTRL_ID).getId(), this.getDocumentModel().getControlById(CTRL_ID).getLibelle(), this.getDocumentModel().id, xpath.split("/")[1], "Bordereau", this.bord_IdBord, localName, libelleLien, msg, this.getDocumentModel().getControlById(CTRL_ID).getRegle().getHtmlContent(), this.getDocumentModel().getControlById(CTRL_ID).getSeverity(), path, xslParams);
                    ano.addNode(new Node(this.bord_MtBordTVA_nodeid));
                    for (String node : this.pieces_TotalTVA_nodesid) {
                        ano.addNode(new Node(node));
                    }
                    this.anos.add(ano);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            return this.anos;
        }
        return null;
    }

    public void endDocument() throws SAXException {
    }

    public void characters(char[] ch, int start, int length, String xpath) {
    }

    public void ignorableWhitespace(char[] ch, int start, int length, String xpath) {
    }

    public void startPrefixMapping(String prefix, String uri, String xpath) {
    }

    public void endPrefixMapping(String prefix, String xpath) {
    }

    public void processingInstruction(String target, String data, String xpath) {
    }

    public void skippedEntity(String name, String xpath) {
    }

    public void setParameters(Hashtable<String, Object> params) {
        this.hParams = params;
    }

    public void setDocumentLocator(Locator locator) {
    }
}

