/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.controls.pesv2.dep;

import fr.gouv.finances.cp.xemelios.controls.AbstractUnitControl;
import fr.gouv.finances.cp.xemelios.controls.Anomalie;
import fr.gouv.finances.cp.xemelios.controls.IdGenerator;
import fr.gouv.finances.cp.xemelios.controls.Node;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DEP10
extends AbstractUnitControl {
    private static final Logger logger = Logger.getLogger(DEP10.class);
    public static final transient String CTRL_ID = "DEP10";
    private Vector<Anomalie> anos = new Vector();
    private Hashtable<String, Object> hParams;
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    private String docId = null;
    private String bord_nodeId = null;
    private String ligne_nodeId = null;
    private static final String ON_RETURN_ANOMALIES = "/PES_DepenseAller/Bordereau/Piece/";
    private static final String FIN_DGP = "/PES_DepenseAller/Bordereau/Piece/BlocPiece/DGP/";
    private String bord_Exer = "";
    private String bord_IdBord = "";
    private String bord_TypBord = "";
    private String piece_IdPce = "";
    private boolean dgp_present = false;
    private String dgp_DteDeb = "";
    private String dgp_DteFin = "";
    private String dgp_Duree = "";
    private String dgp_DteDeb_nodeid = "";
    private String dgp_DteFin_nodeid = "";
    private String dgp_Duree_nodeid = "";
    private static final String MSG_BORD_NUM = "#BORD_NUM#";
    private static final String MSG_BORD_EXER = "#BORD_EXER#";
    private static final String MSG_BORD_TYPBORD = "#BORD_TYPBORD#";
    private static final String MSG_PIECE_IDPCE = "#PIECE_IDPCE#";
    private static final String MSG_DGP_DEB = "#DGP_DEB#";
    private static final String MSG_DGP_FIN = "#DGP_FIN#";
    private static final String MSG_DGP_DUREE = "#DGP_DUREE#";
    private static final String CHEMIN_BLOCBORDEREAU = "/PES_DepenseAller/Bordereau/BlocBordereau/";
    private static final String CHEMIN_BLOCBORDEREAU_EXER = "/PES_DepenseAller/Bordereau/BlocBordereau/Exer/";
    private static final String CHEMIN_BLOCBORDEREAU_IDBORD = "/PES_DepenseAller/Bordereau/BlocBordereau/IdBord/";
    private static final String CHEMIN_BLOCBORDEREAU_TYPBORD = "/PES_DepenseAller/Bordereau/BlocBordereau/TypBord/";
    private static final String CHEMIN_BLOCPIECE = "/PES_DepenseAller/Bordereau/Piece/BlocPiece/";
    private static final String CHEMIN_BLOCPIECE_IDPCE = "/PES_DepenseAller/Bordereau/Piece/BlocPiece/InfoPce/IdPce/";
    private static final String CHEMIN_DGP = "/PES_DepenseAller/Bordereau/Piece/BlocPiece/DGP/";
    private static final String CHEMIN_DGP_DTEDEB = "/PES_DepenseAller/Bordereau/Piece/BlocPiece/DGP/DteDebDgp/";
    private static final String CHEMIN_DGP_DTEFIN = "/PES_DepenseAller/Bordereau/Piece/BlocPiece/DGP/DteFinDgp/";
    private static final String CHEMIN_DGP_DUREE = "/PES_DepenseAller/Bordereau/Piece/BlocPiece/DGP/DureeDgp/";

    public void startDocument() throws SAXException {
        logger.info((Object)"In DEP10");
    }

    public void setDocId(String docID) {
        this.docId = docID;
    }

    public void startElement(String uri, String localName, String qName, Attributes atts, String xpath) {
        if (xpath.endsWith(CHEMIN_BLOCBORDEREAU)) {
            this.bord_TypBord = "";
            this.bord_IdBord = "";
            this.bord_Exer = "";
            this.bord_nodeId = atts.getValue("ano:node-id");
            this.anos = new Vector();
        }
        if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_EXER)) {
            this.bord_Exer = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_IDBORD)) {
            this.bord_IdBord = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_TYPBORD)) {
            this.bord_TypBord = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_BLOCPIECE)) {
            this.piece_IdPce = "";
            this.dgp_present = false;
        }
        if (xpath.endsWith(CHEMIN_BLOCPIECE_IDPCE)) {
            this.piece_IdPce = atts.getValue("V");
        }
        if (xpath.endsWith("/PES_DepenseAller/Bordereau/Piece/BlocPiece/DGP/")) {
            this.dgp_Duree = "";
            this.dgp_DteFin = "";
            this.dgp_DteDeb = "";
            this.ligne_nodeId = atts.getValue("ano:node-id");
            this.dgp_present = true;
        }
        if (xpath.endsWith(CHEMIN_DGP_DTEDEB)) {
            this.dgp_DteDeb = atts.getValue("V");
            this.dgp_DteDeb_nodeid = atts.getValue("ano:node-id");
        }
        if (xpath.endsWith(CHEMIN_DGP_DTEFIN)) {
            this.dgp_DteFin = atts.getValue("V");
            this.dgp_DteFin_nodeid = atts.getValue("ano:node-id");
        }
        if (xpath.endsWith(CHEMIN_DGP_DUREE)) {
            this.dgp_Duree = atts.getValue("V");
            this.dgp_Duree_nodeid = atts.getValue("ano:node-id");
        }
    }

    public Vector<Anomalie> endElement(String uri, String localName, String qName, String xpath) throws SAXException {
        if (xpath.endsWith(ON_RETURN_ANOMALIES)) {
            return this.anos;
        }
        if (xpath.endsWith("/PES_DepenseAller/Bordereau/Piece/BlocPiece/DGP/")) {
            if (this.dgp_present) {
                boolean err = false;
                Vector<Node> anonodes = new Vector<Node>();
                int dureeMax = 45;
                if (this.hParams.get("dureedgp") != null) {
                    dureeMax = (Integer)this.hParams.get("dureedgp");
                }
                int duree = 0;
                Date dateDeb = null;
                Date dateFin = null;
                if (this.dgp_Duree != null && !"".equals(this.dgp_Duree)) {
                    duree = Integer.parseInt(this.dgp_Duree);
                }
                if (duree > dureeMax) {
                    err = true;
                    anonodes.add(new Node(this.dgp_Duree_nodeid));
                }
                if (this.dgp_DteDeb != null && !"".equals(this.dgp_DteDeb)) {
                    try {
                        dateDeb = this.sdf.parse(this.dgp_DteDeb);
                    }
                    catch (Exception e) {
                        dateDeb = null;
                        err = true;
                        anonodes.add(new Node(this.dgp_DteDeb_nodeid));
                    }
                }
                if (this.dgp_DteFin != null && !"".equals(this.dgp_DteFin)) {
                    try {
                        dateFin = this.sdf.parse(this.dgp_DteFin);
                    }
                    catch (Exception e) {
                        dateFin = null;
                        err = true;
                        anonodes.add(new Node(this.dgp_DteFin_nodeid));
                    }
                }
                Calendar c = Calendar.getInstance();
                c.setTime(dateDeb);
                c.add(5, duree);
                if (dateFin.getTime() < c.getTime().getTime()) {
                    err = true;
                    anonodes.add(new Node(this.dgp_DteDeb_nodeid));
                    anonodes.add(new Node(this.dgp_DteFin_nodeid));
                }
                if (err) {
                    String msg = this.getDocumentModel().getControlById(CTRL_ID).getMessage().getHtmlContent();
                    msg = msg.replaceAll(MSG_BORD_NUM, this.bord_IdBord);
                    msg = msg.replaceAll(MSG_BORD_EXER, this.bord_Exer);
                    msg = msg.replaceAll(MSG_BORD_TYPBORD, this.bord_TypBord);
                    msg = msg.replaceAll(MSG_PIECE_IDPCE, this.piece_IdPce);
                    msg = msg.replaceAll(MSG_DGP_DEB, this.dgp_DteDeb);
                    msg = msg.replaceAll(MSG_DGP_FIN, this.dgp_DteFin);
                    msg = msg.replaceAll(MSG_DGP_DUREE, this.dgp_Duree);
                    String path = "@added:primary-key='" + this.bord_Exer + "-" + this.bord_TypBord + "-" + this.bord_IdBord + "'";
                    String anoId = IdGenerator.nextId();
                    String libelleLien = "Bordereau " + this.bord_IdBord + " Mandat " + this.piece_IdPce;
                    Hashtable<String, String> xslParams = new Hashtable<String, String>();
                    xslParams.put("elementId", "");
                    xslParams.put("mandatId", this.piece_IdPce);
                    xslParams.put("browser-destination", "internal");
                    xslParams.put("anoId", anoId);
                    Anomalie ano = new Anomalie(anoId, this.getDocumentModel().getControlById(CTRL_ID).getId(), this.getDocumentModel().getControlById(CTRL_ID).getLibelle(), this.getDocumentModel().id, xpath.split("/")[1], "Bordereau", this.bord_IdBord, localName, libelleLien, msg, this.getDocumentModel().getControlById(CTRL_ID).getRegle().getHtmlContent().replaceAll("#NB_JOURS#", this.hParams.get("dureedgp").toString()), this.getDocumentModel().getControlById(CTRL_ID).getSeverity(), path, xslParams);
                    ano.addAll(anonodes);
                    this.anos.add(ano);
                }
            }
            return null;
        }
        return null;
    }

    public void endDocument() throws SAXException {
    }

    public void characters(char[] ch, int start, int length, String xpath) {
    }

    public void ignorableWhitespace(char[] ch, int start, int length, String xpath) {
    }

    public void startPrefixMapping(String prefix, String uri, String xpath) {
    }

    public void endPrefixMapping(String prefix, String xpath) {
    }

    public void processingInstruction(String target, String data, String xpath) {
    }

    public void skippedEntity(String name, String xpath) {
    }

    public void setParameters(Hashtable<String, Object> params) {
        this.hParams = params;
    }

    public void setDocumentLocator(Locator locator) {
    }
}

