/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.controls.pesv2.dep;

import fr.gouv.finances.cp.xemelios.controls.AbstractUnitControl;
import fr.gouv.finances.cp.xemelios.controls.Anomalie;
import fr.gouv.finances.cp.xemelios.controls.IdGenerator;
import fr.gouv.finances.cp.xemelios.controls.Node;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DEP01
extends AbstractUnitControl {
    private static final Logger logger = Logger.getLogger(DEP01.class);
    public static final transient String CTRL_ID = "DEP01";
    private Vector<Anomalie> anos = new Vector();
    private Hashtable<String, Object> hParams;
    private String docId = null;
    private String nodeId = null;
    private static final String ON_RETURN_ANOMALIES = "/PES_DepenseAller/Bordereau/";
    private static final String FIN_BORDEREAU = "/PES_DepenseAller/Bordereau/";
    private String bord_Exer = "";
    private String bord_IdBord = "";
    private String bord_TypBord = "";
    private static final String MSG_BORD_NUM = "#BORD_NUM#";
    private static final String MSG_BORD_EXER = "#BORD_EXER#";
    private static final String MSG_BORD_TYPBORD = "#BORD_TYPBORD#";
    private static final String CHEMIN_BLOCBORDEREAU = "/PES_DepenseAller/Bordereau/BlocBordereau/";
    private static final String CHEMIN_BLOCBORDEREAU_EXER = "/PES_DepenseAller/Bordereau/BlocBordereau/Exer/";
    private static final String CHEMIN_BLOCBORDEREAU_IDBORD = "/PES_DepenseAller/Bordereau/BlocBordereau/IdBord/";
    private static final String CHEMIN_BLOCBORDEREAU_TYPBORD = "/PES_DepenseAller/Bordereau/BlocBordereau/TypBord/";

    public void startDocument() throws SAXException {
        logger.info((Object)"In DEP01");
    }

    public void setDocId(String docID) {
        this.docId = docID;
    }

    public void startElement(String uri, String localName, String qName, Attributes atts, String xpath) {
        if (xpath.endsWith(CHEMIN_BLOCBORDEREAU)) {
            this.bord_IdBord = "";
            this.bord_Exer = "";
            this.anos = new Vector();
        }
        if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_EXER)) {
            this.bord_Exer = atts.getValue("V");
            this.nodeId = atts.getValue("ano:node-id");
        }
        if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_IDBORD)) {
            this.bord_IdBord = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_TYPBORD)) {
            this.bord_TypBord = atts.getValue("V");
        }
    }

    public Vector<Anomalie> endElement(String uri, String localName, String qName, String xpath) throws SAXException {
        if (xpath.endsWith("/PES_DepenseAller/Bordereau/")) {
            boolean err = false;
            try {
                int annee = Integer.parseInt(this.bord_Exer);
                GregorianCalendar gc = (GregorianCalendar)GregorianCalendar.getInstance();
                err = annee != gc.get(1) && annee != gc.get(1) - 1;
            }
            catch (Exception e) {
                err = true;
            }
            if (err) {
                String msg = this.getDocumentModel().getControlById(CTRL_ID).getMessage().getHtmlContent();
                msg = msg.replaceAll(MSG_BORD_NUM, this.bord_IdBord);
                msg = msg.replaceAll(MSG_BORD_EXER, this.bord_Exer);
                msg = msg.replaceAll(MSG_BORD_TYPBORD, this.bord_TypBord);
                String path = "@added:primary-key='" + this.bord_Exer + "-" + this.bord_TypBord + "-" + this.bord_IdBord + "'";
                String anoId = IdGenerator.nextId();
                String libelleLien = "Bordereau " + this.bord_IdBord;
                Hashtable<String, String> xslParams = new Hashtable<String, String>();
                xslParams.put("elementId", "Bordereau");
                xslParams.put("mandatId", "");
                xslParams.put("browser-destination", "internal");
                xslParams.put("anoId", anoId);
                Anomalie ano = new Anomalie(anoId, this.getDocumentModel().getControlById(CTRL_ID).getId(), this.getDocumentModel().getControlById(CTRL_ID).getLibelle(), this.getDocumentModel().id, xpath.split("/")[1], "Bordereau", this.bord_IdBord, localName, libelleLien, msg, this.getDocumentModel().getControlById(CTRL_ID).getRegle().getHtmlContent(), this.getDocumentModel().getControlById(CTRL_ID).getSeverity(), path, xslParams);
                ano.addNode(new Node(this.nodeId));
                this.anos.add(ano);
            }
            return this.anos;
        }
        return null;
    }

    public void endDocument() throws SAXException {
    }

    public void characters(char[] ch, int start, int length, String xpath) {
    }

    public void ignorableWhitespace(char[] ch, int start, int length, String xpath) {
    }

    public void startPrefixMapping(String prefix, String uri, String xpath) {
    }

    public void endPrefixMapping(String prefix, String xpath) {
    }

    public void processingInstruction(String target, String data, String xpath) {
    }

    public void skippedEntity(String name, String xpath) {
    }

    public void setParameters(Hashtable<String, Object> params) {
        this.hParams = params;
    }

    public void setDocumentLocator(Locator locator) {
    }
}

