/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.auth.dgcp;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import fr.gouv.finances.cp.utils.ui.IhmFactory;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRootPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class NewAdmin
extends JDialog {
    private static final long serialVersionUID = 3616731564957317170L;
    public static final String TITLE = "Cr\u00e9ation de mot de passe";
    private JTextField dfLogin;
    private JPasswordField pwd1;
    private JPasswordField pwd2;
    private JButton pbOk;
    private JButton pbCancel;
    private boolean ret;
    private Action escapeAction;

    public NewAdmin(JFrame owner) throws HeadlessException {
        super(owner, TITLE, true);
        this.initialize();
    }

    protected void initialize() {
        int sepInfo = 2;
        int lineInfo = sepInfo + 2;
        int sepRWline = lineInfo + 2;
        int loginLine = sepRWline + 2;
        int pwdLine = loginLine + 2;
        int confirmLine = pwdLine + 2;
        int buttonLine = confirmLine + 2;
        JTextArea area = null;
        FormLayout fl = new FormLayout("3dlu,20dlu,pref,3dlu,pref,3dlu", "7dlu,pref,3dlu,pref,7dlu,pref,3dlu,pref,3dlu,pref,1dlu,pref,10dlu,pref,10dlu");
        CellConstraints cc = new CellConstraints();
        PanelBuilder pb = new PanelBuilder(fl);
        IhmFactory iF = IhmFactory.newInstance();
        pb.addSeparator("Informations", cc.xyw(2, sepInfo, 4));
        area = new JTextArea();
        pb.add((Component)area, cc.xyw(3, lineInfo, 3));
        pb.addSeparator("Administrateur", cc.xyw(2, sepRWline, 4));
        pb.add((Component)iF.newLabel("Identifiant", "normal"), cc.xy(3, loginLine));
        this.dfLogin = new JTextField();
        pb.add((Component)this.dfLogin, cc.xy(5, loginLine));
        pb.add((Component)iF.newLabel("Mot de passe", "normal"), cc.xy(3, pwdLine));
        this.pwd1 = new JPasswordField();
        pb.add((Component)this.pwd1, cc.xy(5, pwdLine));
        pb.add((Component)iF.newLabel("Confirmer", "normal"), cc.xy(3, confirmLine));
        this.pwd2 = new JPasswordField();
        pb.add((Component)this.pwd2, cc.xy(5, confirmLine));
        JPanel bPane = new JPanel(new FlowLayout(1));
        this.pbCancel = new JButton(this.escapeAction);
        this.pbOk = new JButton("Ok");
        bPane.add(this.pbOk);
        bPane.add(this.pbCancel);
        pb.add((Component)bPane, cc.xyw(2, buttonLine, 4));
        this.pwd1.setColumns(15);
        this.add(pb.getPanel());
        area.setEditable(false);
        area.setLineWrap(true);
        area.setRows(3);
        area.setBackground(this.getBackground());
        area.setText("Afin de prot\u00e9ger l'acc\u00e8s \u00e0 cet outil,\nvous devez cr\u00e9er un super-utilisateur dont le r\u00f4le sera d'administrer les utilisateurs.");
        this.pbOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NewAdmin.this.checkResponse();
            }
        });
        this.getRootPane().setDefaultButton(this.pbOk);
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    protected JRootPane createRootPane() {
        KeyStroke ks = KeyStroke.getKeyStroke(27, 0);
        JRootPane rp = new JRootPane();
        this.escapeAction = new AbstractAction("Annuler"){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent evt) {
                NewAdmin.this.ret = false;
                NewAdmin.this.setVisible(false);
            }
        };
        rp.registerKeyboardAction(this.escapeAction, "TOTOTOTO", ks, 2);
        return rp;
    }

    protected void checkResponse() {
        this.ret = true;
        if (this.pwd1.getPassword() == null || this.pwd1.getPassword().length == 0) {
            JOptionPane.showMessageDialog(this, "Les champs de mot de passe sont obligatoires", "Erreur de saisie", 2);
            this.pwd1.grabFocus();
            this.ret = false;
        }
        if (this.ret && (this.pwd2.getPassword() == null || this.pwd2.getPassword().length == 0)) {
            JOptionPane.showMessageDialog(this, "Les champs de mot de passe sont obligatoires", "Erreur de saisie", 2);
            this.pwd2.grabFocus();
            this.ret = false;
        }
        if (this.ret && !Arrays.equals(this.pwd1.getPassword(), this.pwd2.getPassword())) {
            JOptionPane.showMessageDialog(this, "Vous devez saisir le m\u00eame mot de passe dans les deux champs", "Erreur de saisie", 2);
            this.ret = false;
        }
        if (this.ret) {
            this.setVisible(false);
        }
    }

    public boolean run() {
        this.setVisible(true);
        this.toFront();
        return this.ret;
    }

    public String getNewPassword() {
        return new String(this.pwd1.getPassword());
    }

    public String getNewLogin() {
        return this.dfLogin.getText();
    }

    public void setVisible(boolean b) {
        this.dfLogin.grabFocus();
        super.setVisible(b);
    }

    static {
        System.out.println(System.getProperty("os.name"));
        if (System.getProperty("os.name").toLowerCase().indexOf("win") >= 0) {
            NewAdmin.setDefaultLookAndFeelDecorated(true);
        }
    }
}

