/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.auth.dgcp;

import fr.gouv.finances.cp.xemelios.Splash;
import fr.gouv.finances.cp.xemelios.auth.AbstractAuthenticationManager;
import fr.gouv.finances.cp.xemelios.auth.AuthChecker;
import fr.gouv.finances.cp.xemelios.auth.AuthProvider;
import fr.gouv.finances.cp.xemelios.auth.AuthenticationCancelationException;
import fr.gouv.finances.cp.xemelios.auth.AuthenticationConfigurationException;
import fr.gouv.finances.cp.xemelios.auth.XemeliosUser;
import fr.gouv.finances.cp.xemelios.auth.dgcp.DgcpProvider;
import fr.gouv.finances.cp.xemelios.auth.dgcp.DgcpUser;
import fr.gouv.finances.cp.xemelios.auth.dgcp.DlgAdminUsers;
import fr.gouv.finances.cp.xemelios.auth.dgcp.NewAdmin;
import fr.gouv.finances.cp.xemelios.common.Crypter;
import fr.gouv.finances.cp.xemelios.data.DataAccessException;
import fr.gouv.finances.cp.xemelios.data.DataConfigurationException;
import fr.gouv.finances.cp.xemelios.data.DataImpl;
import fr.gouv.finances.cp.xemelios.data.DataLayerManager;
import fr.gouv.finances.cp.xemelios.data.impl.MySqlDataLayer;
import fr.gouv.finances.cp.xemelios.ui.MainWindow;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.AuthenticationException;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class Manager
extends AbstractAuthenticationManager
implements AuthChecker {
    private static final transient String LDAP_SERVICE_PROVIDER = "auth.ldap.service.provider";
    private static final transient String LDAP_SERVER_URL = "auth.ldap.server.url";
    public static final transient String LDAP_BASE_DN = "auth.ldap.userDn";
    private static Logger logger = Logger.getLogger(Manager.class);
    private String serviceProvider;
    private String ldapUrl;
    private String baseDn;
    private AuthProvider provider;

    public Manager(MainWindow mw) throws AuthenticationConfigurationException, AuthenticationCancelationException {
        block22: {
            this.provider = null;
            this.setMainWindow(mw);
            try {
                if (!(DataLayerManager.getImplementation() instanceof MySqlDataLayer)) {
                    throw new AuthenticationConfigurationException(this.getAuthenticationManagerName() + " can run only with mysql data layer");
                }
                Connection con = null;
                MySqlDataLayer dataLayer = null;
                Statement ps = null;
                try {
                    Splash splash;
                    int size;
                    dataLayer = (MySqlDataLayer)DataLayerManager.getImplementation();
                    con = dataLayer.getConnection();
                    String sql = "CREATE TABLE IF NOT EXISTS DGCP_USERS (LOGIN VARCHAR(24) NOT NULL, PASSWORD VARCHAR(128), ACCESS INT, CONSTRAINT UN_LOGIN UNIQUE (LOGIN))";
                    con.createStatement().executeUpdate(sql);
                    ResultSet rs = con.createStatement().executeQuery("SELECT COUNT(*) FROM DGCP_USERS");
                    if (!rs.next() || (size = rs.getInt(1)) != 0) break block22;
                    sql = "SELECT PASSWORD FROM BASIC_USERS WHERE LOGIN='admin'";
                    boolean exists = false;
                    try {
                        ps = con.prepareStatement(sql);
                        rs = ps.executeQuery();
                        if (rs.next()) {
                            String password = rs.getString(1);
                            sql = "INSERT INTO DGCP_USERS (LOGIN, PASSWORD, ACCESS) VALUES (?,?,?)";
                            rs.close();
                            ps.close();
                            ps = con.prepareStatement(sql);
                            ps.setString(1, "admin");
                            ps.setString(2, password);
                            ps.setInt(3, 65535);
                            ps.executeUpdate();
                            ps.close();
                            exists = true;
                            if (this.getMainWindow().getStartListener() instanceof Splash) {
                                Splash splash2 = (Splash)this.getMainWindow().getStartListener();
                                splash2.setAlwaysOnTop(false);
                                splash2.setVisible(false);
                            }
                            String msg = "La configuration \"R\u00e9seau du Tr\u00e9sor\" a bien \u00e9t\u00e9 activ\u00e9e.\nL'utilisateur d'administration a \u00e9t\u00e9 cr\u00e9\u00e9 avec succ\u00e8s.\nSon login est 'admin' et son mot de passe est celui\nde l'ancien administrateur.";
                            JOptionPane.showMessageDialog((Component)this.getMainWindow(), msg);
                            if (this.getMainWindow().getStartListener() instanceof Splash) {
                                splash = (Splash)this.getMainWindow().getStartListener();
                                splash.setVisible(true);
                                splash.setAlwaysOnTop(true);
                            }
                        }
                    }
                    catch (SQLException sqlEx) {
                        // empty catch block
                    }
                    if (exists) break block22;
                    if (this.getMainWindow().getStartListener() instanceof Splash) {
                        Splash splash3 = (Splash)this.getMainWindow().getStartListener();
                        splash3.setAlwaysOnTop(false);
                        splash3.setVisible(false);
                    }
                    NewAdmin na = new NewAdmin((JFrame)this.getMainWindow());
                    boolean bRet = na.run();
                    if (this.getMainWindow().getStartListener() instanceof Splash) {
                        splash = (Splash)this.getMainWindow().getStartListener();
                        splash.setVisible(true);
                        splash.setAlwaysOnTop(true);
                    }
                    if (bRet) {
                        String password = na.getNewPassword();
                        String login = na.getNewLogin();
                        sql = "INSERT INTO DGCP_USERS(LOGIN,PASSWORD,ACCESS) VALUES (?,?,?)";
                        ps = con.prepareStatement(sql);
                        ps.setString(1, login);
                        ps.setString(2, Crypter.cryptPassword((String)password));
                        ps.setInt(3, 65535);
                        ps.executeUpdate();
                        break block22;
                    }
                    throw new AuthenticationCancelationException("Action interrompue");
                }
                catch (SQLException sqlEx) {
                    throw new AuthenticationConfigurationException((Throwable)sqlEx);
                }
                finally {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable t) {}
                    }
                    if (con != null) {
                        dataLayer.releaseConnection(con);
                    }
                }
            }
            catch (DataConfigurationException dataConfigurationException) {
                // empty catch block
            }
        }
    }

    public boolean authenticate(XemeliosUser user) throws DataAccessException, AuthenticationConfigurationException {
        boolean ret = false;
        try {
            ret = this.authenticateLDAP(user);
            logger.debug((Object)("LDAP->" + (ret ? "OK" : "failed")));
            if (ret) {
                this.authenticateSQL(user);
            } else if (this.isAdmin(user)) {
                logger.debug((Object)(user.getId() + " is admin"));
                ret = this.authenticateSQL(user);
            }
        }
        catch (DataConfigurationException dcEx) {
            throw new AuthenticationConfigurationException((Throwable)dcEx);
        }
        if (user.isAllowedTo(null, 1) && user.isAllowedTo(null, 4096)) {
            this.insertAdminMenu();
        }
        return ret && user.isAllowedTo(null, 1);
    }

    public AuthChecker getChecker() {
        return this;
    }

    public AuthProvider getProvider() {
        if (this.provider == null) {
            this.provider = new DgcpProvider(this.getMainWindow());
        }
        return this.provider;
    }

    public String getAuthenticationManagerName() {
        return "Authentification r\u00e9seau DGCP";
    }

    protected boolean authenticateLDAP(XemeliosUser user) throws DataConfigurationException, AuthenticationConfigurationException {
        DgcpUser dgcpUser = null;
        if (!(user instanceof DgcpUser)) {
            throw new DataConfigurationException("can only authenticate DcgpUser");
        }
        dgcpUser = (DgcpUser)user;
        InitialDirContext dctx = null;
        Hashtable<String, String> env = new Hashtable<String, String>();
        if (this.serviceProvider == null) {
            throw new NullPointerException("you must configure service provider in " + System.getProperty("xemelios.authentication.config.filename") + " - " + LDAP_SERVICE_PROVIDER);
        }
        if (this.ldapUrl == null) {
            throw new NullPointerException("You must configure ldap server url in " + System.getProperty("xemelios.authentication.config.filename") + " - " + LDAP_SERVER_URL);
        }
        env.put("java.naming.factory.initial", this.serviceProvider);
        env.put("java.naming.provider.url", this.ldapUrl);
        env.put("java.naming.security.authentication", "simple");
        String userDn = this.baseDn.replaceAll("%LOGIN%", user.getId());
        env.put("java.naming.security.principal", userDn);
        env.put("java.naming.security.credentials", dgcpUser.getPassword());
        try {
            dctx = new InitialDirContext(env);
            dctx.close();
        }
        catch (AuthenticationException aEx) {
            logger.debug((Object)"authentication failed");
            return false;
        }
        catch (NamingException naEx) {
            logger.warn((Object)naEx.getMessage());
            return false;
        }
        logger.debug((Object)"authenticated");
        dgcpUser.setAuthenticated(true);
        return true;
    }

    protected boolean authenticateSQL(XemeliosUser user) throws DataConfigurationException, DataAccessException {
        DataImpl impl = DataLayerManager.getImplementation();
        if (!(impl instanceof MySqlDataLayer)) {
            throw new DataConfigurationException(this.getAuthenticationManagerName() + " can only deal with MySql data layer");
        }
        if (!(user instanceof DgcpUser)) {
            throw new DataConfigurationException(this.getAuthenticationManagerName() + " can only authenticate DgcpUser");
        }
        DgcpUser dgcpUser = (DgcpUser)user;
        MySqlDataLayer layer = (MySqlDataLayer)impl;
        Connection con = null;
        Statement ps = null;
        ResultSet rs = null;
        try {
            con = layer.getConnection();
            String sql = "SELECT ACCESS FROM DGCP_USERS WHERE LOGIN=? AND PASSWORD=?";
            ps = con.prepareStatement(sql);
            ps.setString(1, dgcpUser.getId());
            ps.setString(2, Crypter.cryptPassword((String)dgcpUser.getPassword()));
            rs = ps.executeQuery();
            if (rs.next()) {
                dgcpUser.setAuth(rs.getInt(1));
                dgcpUser.setAuthenticated(true);
                rs.close();
            } else {
                ps.close();
                sql = "SELECT ACCESS FROM DGCP_USERS WHERE LOGIN=? AND PASSWORD IS NULL";
                ps = con.prepareStatement(sql);
                ps.setString(1, user.getId());
                rs = ps.executeQuery();
                if (rs.next()) {
                    dgcpUser.setAuth(rs.getInt(1));
                } else if (dgcpUser.isAuthenticated()) {
                    rs.close();
                    ps.close();
                    sql = "INSERT INTO DGCP_USERS (LOGIN,ACCESS) VALUES (?,?)";
                    ps = con.prepareStatement(sql);
                    ps.setString(1, dgcpUser.getId());
                    ps.setInt(2, 113);
                    ps.executeUpdate();
                }
            }
        }
        catch (SQLException sqlEx) {
            throw new DataAccessException((Throwable)sqlEx);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t) {}
            }
            if (con != null) {
                layer.releaseConnection(con);
            }
            dgcpUser.setPassword(null);
        }
        return dgcpUser.isAuthenticated();
    }

    protected boolean isAdmin(XemeliosUser user) throws DataConfigurationException, DataAccessException {
        DataImpl impl = DataLayerManager.getImplementation();
        if (!(impl instanceof MySqlDataLayer)) {
            throw new DataConfigurationException(this.getAuthenticationManagerName() + " can only deal with MySql data layer");
        }
        MySqlDataLayer layer = (MySqlDataLayer)impl;
        Connection con = null;
        Statement ps = null;
        ResultSet rs = null;
        boolean bRet = false;
        try {
            con = layer.getConnection();
            String sql = "SELECT ACCESS FROM DGCP_USERS WHERE LOGIN=?";
            ps = con.prepareStatement(sql);
            ps.setString(1, user.getId());
            rs = ps.executeQuery();
            if (rs.next()) {
                bRet = (0x1000 & rs.getInt(1)) > 0;
                rs.close();
            }
        }
        catch (SQLException sqlEx) {
            throw new DataAccessException((Throwable)sqlEx);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t) {}
            }
            if (con != null) {
                layer.releaseConnection(con);
            }
        }
        return bRet;
    }

    public boolean modifyPassword(DgcpUser user) throws DataConfigurationException, DataAccessException {
        DataImpl impl = DataLayerManager.getImplementation();
        if (!(impl instanceof MySqlDataLayer)) {
            throw new DataConfigurationException(this.getAuthenticationManagerName() + " can only deal with MySql data layer");
        }
        MySqlDataLayer layer = (MySqlDataLayer)impl;
        Connection con = null;
        PreparedStatement ps = null;
        Object rs = null;
        boolean bRet = false;
        try {
            con = layer.getConnection();
            ps = con.prepareStatement("UPDATE DGCP_USERS SET PASSWORD=? WHERE LOGIN=?");
            ps.setString(1, Crypter.cryptPassword((String)user.getPassword()));
            ps.setString(2, user.getId());
            bRet = ps.executeUpdate() == 1;
        }
        catch (SQLException sqlEx) {
            throw new DataAccessException((Throwable)sqlEx);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t) {}
            }
            if (con != null) {
                layer.releaseConnection(con);
            }
            user.setPassword(null);
        }
        return bRet;
    }

    public void setProperties(Properties props) {
        super.setProperties(props);
        this.serviceProvider = props.getProperty(LDAP_SERVICE_PROVIDER);
        this.ldapUrl = props.getProperty(LDAP_SERVER_URL);
        this.baseDn = props.getProperty(LDAP_BASE_DN);
    }

    protected void insertAdminMenu() {
        logger.info((Object)"in insertAdminMenu");
        JMenu adminMenu = new JMenu("Administration");
        JMenuItem item = new JMenuItem("Gestion des utlisateurs...");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new DlgAdminUsers((Frame)Manager.this.getMainWindow());
            }
        });
        adminMenu.add(item);
        JMenuBar mBar = this.getMainWindow().getJMenuBar();
        int mnuCount = mBar.getMenuCount();
        JMenu helpMenu = mBar.getMenu(mnuCount - 1);
        mBar.add(adminMenu);
        mBar.add(helpMenu);
        this.getMainWindow().setJMenuBar(mBar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateAuthUser(DgcpUser user) {
        try {
            DataImpl impl = DataLayerManager.getImplementation();
            if (!(impl instanceof MySqlDataLayer)) {
                throw new DataConfigurationException(this.getAuthenticationManagerName() + " can only deal with MySql data layer");
            }
            MySqlDataLayer layer = (MySqlDataLayer)impl;
            Connection con = null;
            Statement ps = null;
            try {
                con = layer.getConnection();
                String sql = "UPDATE DGCP_USERS SET ACCESS=? WHERE LOGIN=?";
                ps = con.prepareStatement(sql);
                ps.setInt(1, user.getAuth(null));
                ps.setString(2, user.getId());
                ps.executeUpdate();
            }
            catch (SQLException sqlEx) {
                sqlEx.printStackTrace();
            }
            finally {
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (Throwable t) {}
                }
                if (con != null) {
                    layer.releaseConnection(con);
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    protected boolean create(DgcpUser user) {
        boolean bRet = false;
        try {
            DataImpl impl = DataLayerManager.getImplementation();
            if (!(impl instanceof MySqlDataLayer)) {
                throw new DataConfigurationException(this.getAuthenticationManagerName() + " can only deal with MySql data layer");
            }
            MySqlDataLayer layer = (MySqlDataLayer)impl;
            String sql = "INSERT INTO DGCP_USERS (LOGIN,ACCESS) VALUES (?,?)";
            Connection con = null;
            PreparedStatement ps = null;
            try {
                con = layer.getConnection();
                ps = con.prepareStatement(sql);
                ps.setString(1, user.getId());
                ps.setInt(2, user.getAuth(null));
                ps.executeUpdate();
                bRet = true;
            }
            catch (SQLException sqlEx) {
                sqlEx.printStackTrace();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return bRet;
    }
}

