/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.auth.dgcp;

import fr.gouv.finances.cp.utils.ui.DisplayExceptionDlg;
import fr.gouv.finances.cp.xemelios.auth.AuthenticationFactory;
import fr.gouv.finances.cp.xemelios.auth.AuthenticationManager;
import fr.gouv.finances.cp.xemelios.auth.XemeliosUser;
import fr.gouv.finances.cp.xemelios.auth.dgcp.DgcpUser;
import fr.gouv.finances.cp.xemelios.auth.dgcp.Manager;
import fr.gouv.finances.cp.xemelios.ui.MainWindow;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;
import org.jdesktop.layout.GroupLayout;

public class DlgChangePassword
extends JDialog {
    private static final Logger logger = Logger.getLogger(DlgChangePassword.class);
    private Action escapeAction;
    private boolean ret;
    private AuthenticationManager manager = null;
    private JPasswordField dfConfirmPasswd;
    private JPasswordField dfNewPasswd;
    private JPasswordField dfOldPasswd;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JButton pbCancel;
    private JButton pbOk;

    public DlgChangePassword(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.pbOk);
        this.setLocationRelativeTo(this.getParent());
        try {
            this.manager = AuthenticationFactory.getManager((MainWindow)MainWindow.getInstance());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.dfOldPasswd = new JPasswordField();
        this.dfNewPasswd = new JPasswordField();
        this.dfConfirmPasswd = new JPasswordField();
        this.pbOk = new JButton();
        this.pbCancel = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Changement de mot de passe");
        this.jLabel1.setText("Ancien mot de passe");
        this.jLabel2.setText("Nouveau mot de passe");
        this.jLabel3.setText("Confirmer le nouveau mot de passe");
        this.pbOk.setText("Ok");
        this.pbOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DlgChangePassword.this.pbOkActionPerformed(evt);
            }
        });
        this.pbCancel.setAction(this.escapeAction);
        this.pbCancel.setText("Annuler");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel3).add((Component)this.jLabel2).add((Component)this.jLabel1)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.dfNewPasswd, -1, 125, Short.MAX_VALUE).add((Component)this.dfConfirmPasswd, -1, 125, Short.MAX_VALUE).add((Component)this.dfOldPasswd, -1, 125, Short.MAX_VALUE)).addContainerGap()).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap(114, Short.MAX_VALUE).add((Component)this.pbOk).add(19, 19, 19).add((Component)this.pbCancel).add(116, 116, 116)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.dfOldPasswd, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.dfNewPasswd, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.dfConfirmPasswd, -2, -1, -2)).addPreferredGap(0, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.pbOk).add((Component)this.pbCancel)).addContainerGap()));
        this.pack();
    }

    private void pbOkActionPerformed(ActionEvent evt) {
        char[] confirm;
        char[] oldPwd = this.dfOldPasswd.getPassword();
        char[] newPwd = this.dfNewPasswd.getPassword();
        if (!Arrays.equals(newPwd, confirm = this.dfConfirmPasswd.getPassword())) {
            JOptionPane.showMessageDialog(this, "Les nouveaux mots de passe ne sont pas identiques entre eux.", "Erreur", 0);
            this.dfNewPasswd.setText("");
            this.dfConfirmPasswd.setText("");
            this.dfNewPasswd.grabFocus();
            return;
        }
        if (newPwd.length == 0) {
            JOptionPane.showMessageDialog(this, "Le nouveau mot de passe ne peut \u00eatre vide.", "Erreur", 0);
            this.dfNewPasswd.grabFocus();
            return;
        }
        DgcpUser user = (DgcpUser)MainWindow.instance.getConnectedUser();
        DgcpUser newUser = new DgcpUser(user.getId(), new String(oldPwd));
        try {
            if (!this.manager.getChecker().authenticate((XemeliosUser)newUser)) {
                JOptionPane.showMessageDialog(this, "L'ancien mot de passe est incorrect.", "Erreur", 0);
                this.dfOldPasswd.setText("");
                this.dfOldPasswd.grabFocus();
                return;
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Impossible de modifier le mot de passe pour l'instant.", "Erreur", 0);
            logger.debug((Object)"while validating old password", (Throwable)ex);
            return;
        }
        if (this.manager instanceof Manager) {
            Manager mgr = (Manager)this.manager;
            try {
                DgcpUser modifiedUser = new DgcpUser(user.getId(), new String(newPwd));
                if (mgr.modifyPassword(modifiedUser)) {
                    JOptionPane.showMessageDialog(this, "Mot de passe correctement modifi\u00e9.", "", 1);
                    this.setVisible(false);
                }
            }
            catch (Throwable t) {
                DisplayExceptionDlg dispDlg = new DisplayExceptionDlg((Dialog)this, t);
            }
        }
    }

    protected JRootPane createRootPane() {
        KeyStroke ks = KeyStroke.getKeyStroke(27, 0);
        JRootPane rp = new JRootPane();
        this.escapeAction = new AbstractAction("Annuler"){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent evt) {
                DlgChangePassword.this.ret = false;
                DlgChangePassword.this.setVisible(false);
            }
        };
        rp.registerKeyboardAction(this.escapeAction, "TOTOTOTO", ks, 2);
        return rp;
    }
}

