/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.auth.dgcp;

import fr.gouv.finances.cp.xemelios.auth.AuthenticationFactory;
import fr.gouv.finances.cp.xemelios.auth.dgcp.DgcpUser;
import fr.gouv.finances.cp.xemelios.auth.dgcp.DlgChangePassword;
import fr.gouv.finances.cp.xemelios.auth.dgcp.Manager;
import fr.gouv.finances.cp.xemelios.data.DataLayerManager;
import fr.gouv.finances.cp.xemelios.data.impl.MySqlDataLayer;
import fr.gouv.finances.cp.xemelios.ui.MainWindow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;

public class DlgAdminUsers
extends JDialog {
    private static final long serialVersionUID = -139419090026420451L;
    private JXTable table = null;
    private UsersModel model = null;

    public DlgAdminUsers(Frame owner) throws HeadlessException {
        super(owner, "Gestion des utilisateurs");
        this.initialize();
    }

    protected void initialize() {
        JPanel pane = new JPanel(new BorderLayout());
        JPanel centerPane = new JPanel(new FlowLayout());
        JButton pbAddUser = new JButton("Nouvel utilisateur...");
        centerPane.add((Component)pbAddUser, "West");
        JButton pbOk = new JButton("Fermer");
        centerPane.add((Component)pbOk, "Center");
        JPanel buttonPane = new JPanel(new BorderLayout());
        buttonPane.add((Component)centerPane, "Center");
        JButton pbChangPassword = new JButton("Changer le mot de passe...");
        JPanel tmpPane = new JPanel(new FlowLayout());
        tmpPane.add(pbChangPassword);
        buttonPane.add((Component)tmpPane, "East");
        pane.add((Component)buttonPane, "South");
        MySqlDataLayer layer = null;
        try {
            layer = (MySqlDataLayer)DataLayerManager.getImplementation();
        }
        catch (Throwable t) {
            // empty catch block
        }
        pbOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DlgAdminUsers.this.setVisible(false);
                DlgAdminUsers.this.dispose();
            }
        });
        pbChangPassword.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DlgChangePassword chgPwd = new DlgChangePassword((Frame)MainWindow.instance, true);
                chgPwd.setVisible(true);
            }
        });
        if (layer != null) {
            final MySqlDataLayer aLayer = layer;
            pbAddUser.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DlgAdminUsers.this.addNewUser(aLayer);
                }
            });
        }
        this.model = new UsersModel(layer);
        this.table = new JXTable((TableModel)this.model);
        pane.add((Component)new JScrollPane((Component)this.table), "Center");
        this.table.setColumnControlVisible(true);
        this.setContentPane(pane);
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
        this.setVisible(true);
    }

    private void addNewUser(MySqlDataLayer layer) {
        String id = JOptionPane.showInputDialog(this, (Object)"Saisissez l'identifiant de l'utilisateur \u00e0 cr\u00e9er :");
        if (id != null) {
            DgcpUser user = new DgcpUser(id, 1);
            try {
                Manager manager = (Manager)AuthenticationFactory.getManager((MainWindow)((MainWindow)this.getOwner()));
                if (!manager.create(user)) {
                    JOptionPane.showMessageDialog(this, "Cet utilisateur existe d\u00e9j\u00e0.", "Attention", 2);
                } else {
                    this.model.refresh();
                    this.table.tableChanged(new TableModelEvent(this.model));
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UsersModel
    extends AbstractTableModel {
        private Vector<DgcpUser> users = null;
        private MySqlDataLayer layer = null;

        public UsersModel(MySqlDataLayer layer) {
            this.layer = layer;
            this.refresh();
        }

        @Override
        public int getColumnCount() {
            return 8;
        }

        @Override
        public int getRowCount() {
            return this.users.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            DgcpUser user = this.users.elementAt(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return user.getId();
                }
                case 1: {
                    return new Boolean((user.getAuth(null) & 1) > 0);
                }
                case 2: {
                    return new Boolean((user.getAuth(null) & 0x10) > 0);
                }
                case 3: {
                    return new Boolean((user.getAuth(null) & 0x20) > 0);
                }
                case 4: {
                    return new Boolean((user.getAuth(null) & 0x40) > 0);
                }
                case 5: {
                    return new Boolean((user.getAuth(null) & 2) > 0);
                }
                case 6: {
                    return new Boolean((user.getAuth(null) & 4) > 0);
                }
                case 7: {
                    return new Boolean((user.getAuth(null) & 0x1000) > 0);
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return String.class;
            }
            return Boolean.class;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Identifiant";
                }
                case 1: {
                    return "Connection";
                }
                case 2: {
                    return "Chercher";
                }
                case 3: {
                    return "Naviguer";
                }
                case 4: {
                    return "Exporter";
                }
                case 5: {
                    return "Importer";
                }
                case 6: {
                    return "Supprimer";
                }
                case 7: {
                    return "Administrer";
                }
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex != 0;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            boolean newValue = (Boolean)aValue;
            int bit = 0;
            switch (columnIndex) {
                case 1: {
                    bit = 1;
                    break;
                }
                case 2: {
                    bit = 16;
                    break;
                }
                case 3: {
                    bit = 32;
                    break;
                }
                case 4: {
                    bit = 64;
                    break;
                }
                case 5: {
                    bit = 2;
                    break;
                }
                case 6: {
                    bit = 4;
                    break;
                }
                case 7: {
                    bit = 4096;
                }
            }
            if (bit == 0) {
                return;
            }
            DgcpUser user = this.users.elementAt(rowIndex);
            int auth = newValue ? user.getAuth(null) | bit : ~bit & user.getAuth(null);
            user.setAuth(auth);
            try {
                Manager manager = (Manager)AuthenticationFactory.getManager((MainWindow)((MainWindow)DlgAdminUsers.this.getOwner()));
                manager.updateAuthUser(user);
                this.users.setElementAt(user, rowIndex);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void refresh() {
            Connection con = null;
            Statement st = null;
            ResultSet rs = null;
            try {
                this.users = new Vector();
                con = this.layer.getConnection();
                String sql = "SELECT LOGIN, ACCESS FROM DGCP_USERS ORDER BY LOGIN";
                st = con.createStatement();
                rs = st.executeQuery(sql);
                while (rs.next()) {
                    this.users.add(new DgcpUser(rs.getString(1), rs.getInt(2)));
                }
            }
            catch (SQLException sqlEx) {
                sqlEx.printStackTrace();
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (Throwable t) {}
                }
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (Throwable t) {}
                }
                if (con != null) {
                    this.layer.releaseConnection(con);
                }
            }
        }
    }
}

