/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.auth.ldap;

import fr.gouv.finances.cp.xemelios.auth.AbstractAuthenticationManager;
import fr.gouv.finances.cp.xemelios.auth.AuthChecker;
import fr.gouv.finances.cp.xemelios.auth.AuthProvider;
import fr.gouv.finances.cp.xemelios.auth.AuthenticationConfigurationException;
import fr.gouv.finances.cp.xemelios.auth.XemeliosUser;
import fr.gouv.finances.cp.xemelios.auth.ldap.LdapProvider;
import fr.gouv.finances.cp.xemelios.auth.ldap.LdapUser;
import fr.gouv.finances.cp.xemelios.data.DataAccessException;
import fr.gouv.finances.cp.xemelios.ui.MainWindow;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;

public class LdapManager
extends AbstractAuthenticationManager
implements AuthChecker {
    private String baseUrl = null;
    private String userDN = null;
    private String readAccessDN = null;
    private String writeAccessDN = null;
    private AuthProvider provider = null;

    public boolean authenticate(XemeliosUser user) throws DataAccessException, AuthenticationConfigurationException {
        LdapUser lu = null;
        if (!(user instanceof LdapUser)) {
            throw new AuthenticationConfigurationException("can only authenticate LdapUser");
        }
        lu = (LdapUser)user;
        String login = user.getId().toUpperCase();
        String bindDN = this.userDN.replaceAll("%LOGIN%", login);
        String readDN = this.readAccessDN == null ? null : this.readAccessDN.replaceAll("%LOGIN%", login);
        String writeDN = this.writeAccessDN == null ? null : this.writeAccessDN.replaceAll("%LOGIN%", login);
        Hashtable<String, String> ht = new Hashtable<String, String>();
        ht.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        ht.put("java.naming.security.authentication", "simple");
        ht.put("java.naming.security.principal", bindDN);
        ht.put("java.naming.security.credentials", lu.getPassword());
        ht.put("java.naming.provider.url", this.baseUrl);
        ht.put("com.sun.jndi.ldap.connect.pool", "false");
        ht.put("com.sun.jndi.ldap.connect.timeout", "60000");
        int auth = 0;
        try {
            Attributes transaction;
            InitialDirContext context = new InitialDirContext(ht);
            try {
                transaction = context.getAttributes(readDN);
                if (transaction.size() > 0) {
                    auth += 113;
                }
            }
            catch (NamingException e) {
                e.printStackTrace();
            }
            try {
                transaction = context.getAttributes(writeDN);
                if (transaction.size() > 0) {
                    auth += 6;
                }
            }
            catch (NamingException e) {
                e.printStackTrace();
            }
            context.close();
        }
        catch (NamingException e) {
            System.out.println("Bad password ? : " + e.getMessage());
            e.printStackTrace();
        }
        lu.setAuth(auth);
        return auth != 0;
    }

    public LdapManager(MainWindow mw) {
        this.setMainWindow(mw);
    }

    public AuthChecker getChecker() {
        return this;
    }

    public AuthProvider getProvider() {
        if (this.provider == null) {
            this.provider = new LdapProvider(this.getMainWindow());
        }
        return this.provider;
    }

    public String getAuthenticationManagerName() {
        return "Authentification LDAP (CHRU Strasbourg)";
    }

    public void setProperties(Properties props) {
        super.setProperties(props);
        this.baseUrl = (String)this.getProperty("auth.ldap.baseUrl");
        this.userDN = (String)this.getProperty("auth.ldap.userDN");
        this.readAccessDN = (String)this.getProperty("auth.ldap.readAccessDN");
        this.writeAccessDN = (String)this.getProperty("auth.ldap.writeAccessDN");
    }
}

