/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.data.impl.sqlconfig;

import fr.gouv.finances.cp.utils.xml.marshal.InvalidXmlDefinition;
import fr.gouv.finances.cp.utils.xml.marshal.XmlAttributes;
import fr.gouv.finances.cp.utils.xml.marshal.XmlMarshallable;
import fr.gouv.finances.cp.utils.xml.marshal.XmlOutputter;
import java.sql.Date;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.StringTokenizer;
import org.xml.sax.SAXException;

public class TSqlIndex
implements XmlMarshallable {
    public static final String TAG = "sql-index";
    private SimpleDateFormat[] sdfs;
    private String id;
    private String tableId;
    private String path;
    private String format;
    private String datatype;
    private String column;

    public TSqlIndex(String tagName) {
    }

    public void addCharacterData(String cData) throws SAXException {
    }

    public void addChild(XmlMarshallable child, String tagName) throws SAXException {
    }

    public XmlMarshallable getAttributes(XmlAttributes attributes) throws SAXException {
        this.id = attributes.getValue("id");
        this.tableId = attributes.getValue("table");
        this.path = attributes.getValue("path");
        this.format = attributes.getValue("format");
        this.datatype = attributes.getValue("datatype");
        this.column = attributes.getValue("column");
        return this;
    }

    public void marshall(XmlOutputter output) {
    }

    public void validate() throws InvalidXmlDefinition {
    }

    public TSqlIndex clone() {
        return this;
    }

    public String getColumn() {
        return this.column;
    }

    public void setColumn(String column) {
        this.column = column;
    }

    public String getDatatype() {
        return this.datatype;
    }

    public void setDatatype(String datatype) {
        this.datatype = datatype;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getTableId() {
        return this.tableId;
    }

    public void setTableId(String tableId) {
        this.tableId = tableId;
    }

    public String getFormattedStringValue(String value) {
        if (this.format != null) {
            if ("uppercase".equals(this.format)) {
                return value.toUpperCase();
            }
            if ("lowercase".equals(this.format)) {
                return value.toLowerCase();
            }
            if ("normalize-month".equals(this.format)) {
                return value.length() == 1 ? "0" + value : value;
            }
        }
        return value;
    }

    public Date getDateValue(String value) throws ParseException {
        int count;
        if (!"date".equals(this.datatype)) {
            return null;
        }
        if (this.sdfs == null) {
            StringTokenizer tokenizer = new StringTokenizer(this.format, ";");
            this.sdfs = new SimpleDateFormat[tokenizer.countTokens()];
            for (count = 0; count < this.sdfs.length; ++count) {
                String s = tokenizer.nextToken();
                this.sdfs[count] = new SimpleDateFormat(s);
            }
        }
        Date ret = null;
        count = 0;
        while (ret == null && count < this.sdfs.length) {
            try {
                ret = new Date(this.sdfs[count].parse(value).getTime());
            }
            catch (ParseException pEx) {
                ++count;
            }
        }
        if (ret == null) {
            throw new ParseException(value + " does not match any of following date patterns : " + this.format, 0);
        }
        return ret;
    }
}

