/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.data.impl;

import fr.gouv.finances.cp.xemelios.common.DematTransform;
import fr.gouv.finances.cp.xemelios.data.impl.MySqlDataLayer;
import fr.gouv.finances.cp.xemelios.data.ui.PatchProgress;
import fr.gouv.finances.cp.xemelios.utils.FileUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

class VersementPatch32 {
    public static final transient String PARAM_VERSEMENT_PATCH_32 = "versement.patch.3.2.applied";
    private static final Logger logger = Logger.getLogger(VersementPatch32.class);
    private DocumentBuilderFactory domFactory;
    private MySqlDataLayer impl = null;

    public VersementPatch32(MySqlDataLayer impl) {
        logger.debug((Object)"instanciating");
        this.impl = impl;
        this.domFactory = DocumentBuilderFactory.newInstance();
        this.domFactory.setNamespaceAware(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        logger.debug((Object)"run");
        String paramValue = this.impl.getParameterValue(PARAM_VERSEMENT_PATCH_32);
        if (paramValue == null) {
            Connection con = null;
            try {
                con = this.impl.getConnection();
                boolean isVersementDocumentTableExists = true;
                try {
                    con.createStatement().executeQuery("SELECT 1 FROM VERS_ETATVERS_DOCUMENTS LIMIT 1");
                }
                catch (SQLException sqlEx) {
                    if (sqlEx.getErrorCode() == 1146) {
                        isVersementDocumentTableExists = false;
                    }
                    throw sqlEx;
                }
                boolean isNatureDocumentTableExists = true;
                try {
                    con.createStatement().executeQuery("SELECT 1 FROM VERS_ETATREPARTITION_DOCUMENTS LIMIT 1");
                }
                catch (SQLException sqlEx) {
                    if (sqlEx.getErrorCode() == 1146) {
                        isNatureDocumentTableExists = false;
                    }
                    throw sqlEx;
                }
                if (isVersementDocumentTableExists) {
                    this.patchVersementDocuments(con);
                }
                if (isNatureDocumentTableExists) {
                    this.patchRepartitionDocuments(con);
                }
                this.impl.setParameterValue(PARAM_VERSEMENT_PATCH_32, "applied");
            }
            catch (Throwable t) {
                logger.error((Object)"in run()", t);
            }
            finally {
                if (con != null) {
                    this.impl.releaseConnection(con);
                }
            }
        }
    }

    private String loadXsltBuffer() {
        String ret = null;
        File f = new File(System.getProperty("xemelios.documents.def.dir"), "versement/patch32versement.xsl");
        try {
            String xslEncoding = FileUtils.getFileEncoding((File)f);
            ret = FileUtils.readTextFile((File)f, (String)xslEncoding);
        }
        catch (IOException ioEx) {
            logger.error((Object)"in loadXsltBuffer :", (Throwable)ioEx);
        }
        return ret;
    }

    private void patchVersementDocuments(Connection con) throws SQLException {
        logger.debug((Object)"patchVersementDocuments");
        this.patchTableDocuments(con, "VERS_ETATVERS_DOCUMENTS", "Etat de versement");
    }

    private void patchRepartitionDocuments(Connection con) throws SQLException {
        logger.debug((Object)"patchRepartitionDocuments");
        this.patchTableDocuments(con, "VERS_ETATREPARTITION_DOCUMENTS", "R\u00e9partition par nature (Versement)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void patchTableDocuments(Connection con, String tableName, String tableLibelle) throws SQLException {
        SQLException sqlExToThrow;
        block93: {
            Throwable t222222;
            Connection con2;
            ResultSet rs2;
            ResultSet rs;
            Statement ps3;
            Statement ps2;
            Statement ps;
            Statement st2;
            Statement st;
            block75: {
                st = null;
                st2 = null;
                ps = null;
                ps2 = null;
                ps3 = null;
                rs = null;
                rs2 = null;
                sqlExToThrow = null;
                con2 = null;
                st = con.createStatement();
                rs = st.executeQuery("SELECT COUNT(*) FROM " + tableName);
                rs.next();
                long nbRecords = rs.getLong(1);
                PatchProgress progress = this.impl.getPatchProgress();
                progress.setMaxProgress(nbRecords);
                progress.startProgress(tableLibelle);
                String xsltBuffer = this.loadXsltBuffer();
                con2 = this.impl.getConnection();
                rs = st.executeQuery("SELECT COLLECTIVITE, BUDGET, DOC_ID FROM " + tableName);
                st2 = con2.createStatement();
                st2.executeUpdate("LOCK TABLES " + tableName + " WRITE");
                ps2 = con2.prepareStatement("SELECT DOC, ENCODING FROM " + tableName + " WHERE BUDGET=? AND COLLECTIVITE=? AND DOC_ID=?");
                ps3 = con2.prepareStatement("UPDATE " + tableName + " SET DOC=? WHERE BUDGET=? AND COLLECTIVITE=? AND DOC_ID=?");
                while (rs.next()) {
                    String collectivite = rs.getString(1);
                    String budget = rs.getString(2);
                    String docId = rs.getString(3);
                    ps2.setString(1, budget);
                    ps2.setString(2, collectivite);
                    ps2.setString(3, docId);
                    rs2 = ps2.executeQuery();
                    if (rs2.next()) {
                        String encoding = rs2.getString(2);
                        try {
                            byte[] buff = new byte[512];
                            ByteArrayOutputStream baos = new ByteArrayOutputStream();
                            InputStream is = rs2.getAsciiStream(1);
                            int length = is.read(buff);
                            while (length > 0) {
                                baos.write(buff, 0, length);
                                length = is.read(buff);
                            }
                            DocumentBuilder builder = this.domFactory.newDocumentBuilder();
                            byte[] byteArray = baos.toByteArray();
                            ByteArrayInputStream bis = new ByteArrayInputStream(byteArray);
                            Document ret = builder.parse(bis);
                            String localBuffer = xsltBuffer.replaceAll("##output-encoding##", encoding);
                            InputStream transformed = DematTransform.transform((Node)ret, (InputStream)new ByteArrayInputStream(localBuffer.getBytes("ISO-8859-1")));
                            ps3.setString(2, budget);
                            ps3.setString(3, collectivite);
                            ps3.setString(4, docId);
                            ps3.setBinaryStream(1, transformed, transformed.available());
                            ps3.executeUpdate();
                        }
                        catch (IOException ioEx) {
                            logger.error((Object)"ioEx", (Throwable)ioEx);
                        }
                        catch (ParserConfigurationException pcEx) {
                            logger.error((Object)"pcEx", (Throwable)pcEx);
                        }
                        catch (SAXException saxEx) {
                            logger.error((Object)"saxEx", (Throwable)saxEx);
                        }
                    }
                    progress.pushProgress();
                }
                Object var32_34 = null;
                if (ps3 == null) break block75;
                try {
                    ps3.close();
                }
                catch (Throwable t222222) {
                    // empty catch block
                }
            }
            if (rs2 != null) {
                try {
                    rs2.close();
                }
                catch (Throwable t222222) {
                    // empty catch block
                }
            }
            if (ps2 != null) {
                try {
                    ps2.close();
                }
                catch (Throwable t222222) {
                    // empty catch block
                }
            }
            if (con2 != null) {
                if (st2 == null) {
                    try {
                        st2 = con2.createStatement();
                    }
                    catch (Throwable t222222) {
                        // empty catch block
                    }
                }
                try {
                    st2.executeUpdate("UNLOCK TABLES");
                }
                catch (Throwable t222222) {
                    // empty catch block
                }
                try {
                    st2.close();
                }
                catch (Throwable t222222) {
                    // empty catch block
                }
                try {
                    con2.commit();
                }
                catch (Throwable t222222) {
                    // empty catch block
                }
                this.impl.releaseConnection(con2);
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Throwable t222222) {
                    // empty catch block
                }
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t222222) {
                    // empty catch block
                }
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (Throwable t222222) {}
            }
            break block93;
            {
                catch (SQLException sqlEx) {
                    Throwable t222222;
                    sqlExToThrow = sqlEx;
                    Object var32_35 = null;
                    if (ps3 != null) {
                        try {
                            ps3.close();
                        }
                        catch (Throwable t222222) {
                            // empty catch block
                        }
                    }
                    if (rs2 != null) {
                        try {
                            rs2.close();
                        }
                        catch (Throwable t222222) {
                            // empty catch block
                        }
                    }
                    if (ps2 != null) {
                        try {
                            ps2.close();
                        }
                        catch (Throwable t222222) {
                            // empty catch block
                        }
                    }
                    if (con2 != null) {
                        if (st2 == null) {
                            try {
                                st2 = con2.createStatement();
                            }
                            catch (Throwable t222222) {
                                // empty catch block
                            }
                        }
                        try {
                            st2.executeUpdate("UNLOCK TABLES");
                        }
                        catch (Throwable t222222) {
                            // empty catch block
                        }
                        try {
                            st2.close();
                        }
                        catch (Throwable t222222) {
                            // empty catch block
                        }
                        try {
                            con2.commit();
                        }
                        catch (Throwable t222222) {
                            // empty catch block
                        }
                        this.impl.releaseConnection(con2);
                    }
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable t222222) {
                            // empty catch block
                        }
                    }
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable t222222) {
                            // empty catch block
                        }
                    }
                    if (st != null) {
                        try {
                            st.close();
                        }
                        catch (Throwable t222222) {}
                    }
                }
            }
            catch (Throwable throwable) {
                Throwable t222222;
                Object var32_36 = null;
                if (ps3 != null) {
                    try {
                        ps3.close();
                    }
                    catch (Throwable t222222) {
                        // empty catch block
                    }
                }
                if (rs2 != null) {
                    try {
                        rs2.close();
                    }
                    catch (Throwable t222222) {
                        // empty catch block
                    }
                }
                if (ps2 != null) {
                    try {
                        ps2.close();
                    }
                    catch (Throwable t222222) {
                        // empty catch block
                    }
                }
                if (con2 != null) {
                    if (st2 == null) {
                        try {
                            st2 = con2.createStatement();
                        }
                        catch (Throwable t222222) {
                            // empty catch block
                        }
                    }
                    try {
                        st2.executeUpdate("UNLOCK TABLES");
                    }
                    catch (Throwable t222222) {
                        // empty catch block
                    }
                    try {
                        st2.close();
                    }
                    catch (Throwable t222222) {
                        // empty catch block
                    }
                    try {
                        con2.commit();
                    }
                    catch (Throwable t222222) {
                        // empty catch block
                    }
                    this.impl.releaseConnection(con2);
                }
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (Throwable t222222) {
                        // empty catch block
                    }
                }
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (Throwable t222222) {
                        // empty catch block
                    }
                }
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (Throwable t222222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        if (sqlExToThrow != null) {
            throw sqlExToThrow;
        }
    }
}

