/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.plugin.signerfichier;

import fr.gouv.finances.cp.xemelios.plugin.signerfichier.IFileSigner;
import java.util.Hashtable;
import javax.xml.namespace.NamespaceContext;
import org.apache.log4j.Logger;

public class FileSignerFactory {
    static Logger logger = Logger.getLogger(FileSignerFactory.class);
    private Hashtable<Integer, Object> attributes = new Hashtable();
    private NamespaceContext nsCtx;
    public static int MAX_FILE_SIZE_APACHEXMLSEC = 0;
    public static int ACTUAL_FILE_SIZE = 1;
    public static int USE_APACHEXMLSEC = 2;
    public static int USE_LIBXML2 = 3;
    public static int DO_POSTTRAIT = 4;
    public static int VALIDATE_SCHEMA_OR_DTD = 5;
    public static int EXTERNAL_DTD = 6;
    public static int SIGNATURE_XPATH = 7;

    protected FileSignerFactory() {
    }

    public static FileSignerFactory newInstance() {
        FileSignerFactory svf = new FileSignerFactory();
        return svf;
    }

    public void setNsCtx(NamespaceContext ctx) {
        this.nsCtx = ctx;
    }

    protected IFileSigner getFileSignerByName(String svName) {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            if (loader == null) {
                loader = this.getClass().getClassLoader();
            }
            Class<?> scClass = Class.forName(svName, true, loader);
            IFileSigner sv = (IFileSigner)scClass.newInstance();
            return sv;
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        catch (Error e) {
            e.printStackTrace();
            return null;
        }
    }

    public IFileSigner newFileSigner() throws Exception {
        IFileSigner signer = null;
        boolean useApache = this.getAttributeAsBoolean(USE_APACHEXMLSEC);
        boolean useLibXml = this.getAttributeAsBoolean(USE_LIBXML2);
        boolean doPostrait = this.getAttributeAsBoolean(DO_POSTTRAIT);
        boolean doSchemaValidation = this.getAttributeAsBoolean(VALIDATE_SCHEMA_OR_DTD);
        String externalDTD = this.getAttributeAsString(EXTERNAL_DTD);
        String signatureXPath = this.getAttributeAsString(SIGNATURE_XPATH);
        int maxFileSizeApacheXmlSec = this.getAttributeAsInt(MAX_FILE_SIZE_APACHEXMLSEC);
        int actualFileSize = this.getAttributeAsInt(ACTUAL_FILE_SIZE);
        if (useApache && useLibXml) {
            useLibXml = false;
        }
        if (!useApache && !useLibXml) {
            useApache = true;
        }
        if (useApache && maxFileSizeApacheXmlSec != Integer.MIN_VALUE && actualFileSize != Integer.MIN_VALUE && actualFileSize > maxFileSizeApacheXmlSec) {
            useApache = false;
            useLibXml = true;
        }
        if (useApache) {
            signer = this.getFileSignerByName("fr.gouv.finances.cp.xemelios.plugin.signerfichier.APXSFileSigner");
        }
        signer.setNsCtx(this.nsCtx);
        logger.debug((Object)signer.getClass().getName());
        return signer;
    }

    public void setAttribute(int attribute, String value) {
        this.attributes.put(new Integer(attribute), value);
    }

    public void setAttribute(int attribute, int value) {
        this.attributes.put(new Integer(attribute), new Integer(value));
    }

    public void setAttribute(int attribute, boolean value) {
        this.attributes.put(new Integer(attribute), new Boolean(value));
    }

    public Object getAttribute(int attribute) {
        if (this.attributes.containsKey(attribute)) {
            return this.attributes.get(attribute);
        }
        return null;
    }

    public boolean getAttributeAsBoolean(int attribute) {
        Object o;
        if (this.attributes.containsKey(attribute) && (o = this.attributes.get(attribute)) instanceof Boolean) {
            return (Boolean)o;
        }
        return false;
    }

    public int getAttributeAsInt(int attribute) {
        Object o;
        if (this.attributes.containsKey(attribute) && (o = this.attributes.get(attribute)) instanceof Integer) {
            return (Integer)o;
        }
        return Integer.MIN_VALUE;
    }

    public String getAttributeAsString(int attribute) {
        Object o;
        if (this.attributes.containsKey(attribute) && (o = this.attributes.get(attribute)) instanceof String) {
            return (String)o;
        }
        return null;
    }
}

