/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.plugin.signerfichier;

import fr.gouv.finances.cp.xemelios.plugin.signerfichier.IFileSigner;
import java.io.File;
import java.util.Vector;
import javax.xml.namespace.NamespaceContext;

public abstract class FileSigner
implements IFileSigner {
    protected File inputFile;
    protected File outputFile;
    protected File keystoreFile;
    protected String keystorePassword;
    protected String alias;
    protected String aliasPassword;
    protected String keystoreType;
    protected String algorithm;
    protected NamespaceContext nsCtx;
    protected Vector<String> subtractFilters = new Vector();
    protected Vector<String> intersectFilters = new Vector();
    public static final int SIGN_GOOD = 0;
    public static final int SIGN_BAD = 1;
    public static final int SIGN_VERYBAD = 2;
    protected int status = 0;
    public static final int PARSEOK = 1;
    public static final int LOADKSOK = 2;
    public static final int LOADPKOK = 4;
    public static final int ALGOIDOK = 8;
    public static final int SIGNOK = 16;
    public static final int WRITEOK = 32;

    public void setNsCtx(NamespaceContext ctx) {
        this.nsCtx = ctx;
    }

    public boolean parseOK() {
        return (this.status & 1) != 0;
    }

    public boolean loadKsOK() {
        return (this.status & 2) != 0;
    }

    public boolean loadPkOK() {
        return (this.status & 4) != 0;
    }

    public boolean algoIdOK() {
        return (this.status & 8) != 0;
    }

    public boolean signOK() {
        return (this.status & 0x10) != 0;
    }

    public boolean writeOK() {
        return (this.status & 0x20) != 0;
    }

    protected void setParseOK(boolean b) {
        this.status = b ? (this.status |= 1) : (this.status &= 0xFFFFFFFE);
    }

    protected void setLoadKsOK(boolean b) {
        this.status = b ? (this.status |= 2) : (this.status &= 0xFFFFFFFD);
    }

    protected void setLoadPkOK(boolean b) {
        this.status = b ? (this.status |= 4) : (this.status &= 0xFFFFFFFB);
    }

    protected void setAlgoIdOK(boolean b) {
        this.status = b ? (this.status |= 8) : (this.status &= 0xFFFFFFF7);
    }

    protected void setSignOK(boolean b) {
        this.status = b ? (this.status |= 0x10) : (this.status &= 0xFFFFFFEF);
    }

    protected void setWriteOK(boolean b) {
        this.status = b ? (this.status |= 0x20) : (this.status &= 0xFFFFFFDF);
    }

    public File getInputFile() {
        return this.inputFile;
    }

    public void setInputFile(File inputFile) {
        this.inputFile = inputFile;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    public File getKeystoreFile() {
        return this.keystoreFile;
    }

    public void setKeystoreFile(File keystoreFile) {
        this.keystoreFile = keystoreFile;
    }

    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    public void setKeystorePassword(String keystorePassword) {
        this.keystorePassword = keystorePassword;
    }

    public String getDetails(String rawalias) {
        return rawalias;
    }

    public String getIssuedFor(String rawalias) {
        return rawalias;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getAliasPassword() {
        return this.aliasPassword;
    }

    public void setAliasPassword(String aliasPassword) {
        this.aliasPassword = aliasPassword;
    }

    protected void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    protected String getAlgorithm() {
        return this.algorithm;
    }

    protected static String kstypeFromSuffix(String suffix) {
        if (suffix == null) {
            return "PKCS12";
        }
        if (suffix.equalsIgnoreCase("jks") || suffix.equalsIgnoreCase("ks")) {
            return "JKS";
        }
        if (suffix.equalsIgnoreCase("jce")) {
            return "JCEKS";
        }
        if (suffix.equalsIgnoreCase("p12") || suffix.equalsIgnoreCase("pfx")) {
            return "PKCS12";
        }
        return "PKCS12";
    }

    public String getKeystoreType() {
        if (this.keystoreFile != null) {
            int n = this.keystoreFile.getName().lastIndexOf(46);
            String extension = this.keystoreFile.getName().substring(n + 1);
            this.keystoreType = FileSigner.kstypeFromSuffix(extension);
        }
        return this.keystoreType;
    }

    public void addSubtractFilter(String xpath) {
        this.subtractFilters.add(xpath);
    }

    public void addIntersectFilter(String xpath) {
        this.intersectFilters.add(xpath);
    }

    public String getStatusAsString() {
        StringBuffer sb = new StringBuffer();
        if (!this.parseOK()) {
            sb.append("Le fichier n'est pas un fichier XML correct \n");
        } else if (this.loadKsOK()) {
            sb.append("Le magasin de cl\u00e9s est correctement charg\u00e9\n");
            if (this.loadPkOK()) {
                sb.append("La cle d'alias " + this.getAlias() + " est correctement charg\u00e9e\n");
                if (this.algoIdOK()) {
                    sb.append("Algorithme de signature reconnu : " + this.getAlgorithm() + "\n");
                } else {
                    sb.append("Algorithme de signature INCONNU ou non support\u00e9 : " + this.getAlgorithm() + "\n");
                }
            } else {
                sb.append("La cle d'alias " + this.getAlias() + " N'A PAS PU ETRE CHARGEE\n");
            }
            if (this.signOK()) {
                sb.append("La signatures a r\u00e9ussi!\n");
                if (this.writeOK()) {
                    sb.append("L'\u00e9criture du fichier de sortie " + this.getOutputFile().getName() + " a r\u00e9ussi!\n");
                } else {
                    sb.append("L'\u00e9criture du fichier de sortie " + this.getOutputFile().getName() + " a ECHOUE\n");
                }
            } else {
                sb.append("La  signature a ECHOUE\n ");
            }
        } else {
            sb.append("Impossible de charger magasin de cles " + this.getKeystoreFile().getName() + " \n");
        }
        return sb.toString();
    }

    public int getStatusAsSeverity() {
        if (!this.parseOK()) {
            return 2;
        }
        if (this.loadKsOK()) {
            if (!this.signOK()) {
                return 2;
            }
            if (!this.writeOK()) {
                return 2;
            }
            return 0;
        }
        return 1;
    }

    public void dispose() {
    }
}

