/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.plugin.signerfichier;

import fr.gouv.finances.cp.xemelios.plugin.signerfichier.FileSigner;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.xml.security.Init;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.transforms.params.XPath2FilterContainer;
import org.apache.xml.security.utils.HelperNodeList;
import org.apache.xml.security.utils.IgnoreAllErrorHandler;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.apache.xml.security.utils.resolver.implementations.ResolverFragment;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;

public class APXSFileSigner
extends FileSigner {
    PrivateKey privateKey = null;
    KeyStore ks = null;
    Transforms transforms = null;
    Document doc = null;
    Element root = null;
    static NamespaceContext staticNsCtx = null;

    public void loadKeystore() throws Exception {
        this.setLoadKsOK(false);
        this.ks = KeyStore.getInstance(this.getKeystoreType());
        FileInputStream fis = new FileInputStream(this.keystoreFile);
        this.ks.load(fis, this.keystorePassword.toCharArray());
        this.setLoadKsOK(true);
    }

    public void loadInputFile() throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        db.setErrorHandler((ErrorHandler)new IgnoreAllErrorHandler());
        this.doc = db.parse(new FileInputStream(this.inputFile));
        this.root = this.doc.getDocumentElement();
        this.setParseOK(true);
    }

    public Enumeration getAliases() throws Exception {
        return this.ks.aliases();
    }

    static void fixNameSpaces(XPath2FilterContainer c) throws Exception {
        String URI2;
        if (staticNsCtx != null && (URI2 = staticNsCtx.getNamespaceURI("n")) != null) {
            c.setXPathNamespaceContext("n", URI2);
        }
    }

    public static NodeList newInstances(Document doc, String[][] filters) throws Exception {
        HelperNodeList nl = new HelperNodeList();
        nl.appendChild((Node)doc.createTextNode("\n"));
        for (int i = 0; i < filters.length; ++i) {
            XPath2FilterContainer c;
            String type = filters[i][0];
            String xpath = filters[i][1];
            if (type.equals("intersect")) {
                c = XPath2FilterContainer.newInstanceIntersect((Document)doc, (String)xpath);
                APXSFileSigner.fixNameSpaces(c);
                nl.appendChild((Node)c.getElement());
                nl.appendChild((Node)doc.createTextNode("\n"));
            }
            if (type.equals("subtract")) {
                c = XPath2FilterContainer.newInstanceSubtract((Document)doc, (String)xpath);
                APXSFileSigner.fixNameSpaces(c);
                nl.appendChild((Node)c.getElement());
                nl.appendChild((Node)doc.createTextNode("\n"));
            }
            if (!type.equals("union")) continue;
            c = XPath2FilterContainer.newInstanceUnion((Document)doc, (String)xpath);
            APXSFileSigner.fixNameSpaces(c);
            nl.appendChild((Node)c.getElement());
            nl.appendChild((Node)doc.createTextNode("\n"));
        }
        return nl;
    }

    public void loadAlias() {
        try {
            if (!this.ks.isKeyEntry(this.alias)) {
                this.setLoadPkOK(false);
                return;
            }
            this.privateKey = (PrivateKey)this.ks.getKey(this.alias, this.aliasPassword.toCharArray());
            this.setLoadPkOK(true);
        }
        catch (Exception e) {
            this.setLoadPkOK(false);
        }
    }

    private static String prettyPrint(X509Certificate c) {
        String result = "Pour:\t" + c.getSubjectDN();
        result = result + "\nEmis par:\t" + c.getIssuerDN();
        result = result + "\nValidit\u00e9:\tdu " + c.getNotBefore() + "\n\tau " + c.getNotAfter();
        result = result + "\nAlgorithme:\t" + c.getSigAlgName();
        result = result + "\nNum\u00e9ro:\t" + c.getSerialNumber();
        return result;
    }

    private static String issuedFor(X509Certificate c) {
        String dn = c.getSubjectX500Principal().getName();
        String cn = null;
        String uid = null;
        StringTokenizer tokenizer = new StringTokenizer(dn, ",");
        while (tokenizer.hasMoreTokens()) {
            String tok = tokenizer.nextToken();
            if (tok.startsWith("CN=")) {
                cn = tok.substring(3);
            }
            if (!tok.startsWith("UID=")) continue;
            uid = tok.substring(4);
        }
        if (uid != null) {
            return uid;
        }
        if (cn != null) {
            return cn;
        }
        return dn;
    }

    public String getIssuedFor(String rawalias) {
        try {
            X509Certificate cert = (X509Certificate)this.ks.getCertificate(rawalias);
            if (cert != null) {
                return APXSFileSigner.issuedFor(cert);
            }
            return rawalias;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "Exception " + rawalias;
        }
    }

    public String getDetails(String rawalias) {
        try {
            X509Certificate cert = (X509Certificate)this.ks.getCertificate(rawalias);
            if (cert != null) {
                return APXSFileSigner.prettyPrint(cert);
            }
            return rawalias;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "Exception " + rawalias;
        }
    }

    public void sign() throws Exception {
        String BaseURI = this.outputFile.toURL().toString();
        String pkAlgo = this.privateKey.getAlgorithm();
        this.setAlgorithm(pkAlgo);
        String algoId = null;
        if (pkAlgo.equals("RSA")) {
            algoId = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
        } else if (pkAlgo.equals("DSA")) {
            algoId = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
        }
        if (algoId == null) {
            System.err.println("Algorithme inconnu ou non support\u00e9 " + pkAlgo);
            this.setAlgoIdOK(false);
            return;
        }
        this.setAlgoIdOK(true);
        XMLSignature sig = new XMLSignature(this.doc, BaseURI, algoId);
        this.root.appendChild(sig.getElement());
        ResolverFragment fragmentResolver = new ResolverFragment();
        sig.addResourceResolver((ResourceResolverSpi)fragmentResolver);
        this.transforms = new Transforms(this.doc);
        this.transforms.addTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
        staticNsCtx = this.nsCtx;
        if (this.subtractFilters.size() + this.intersectFilters.size() > 0) {
            String[][] filters = new String[this.subtractFilters.size() + this.intersectFilters.size()][2];
            int i = 0;
            for (String subs : this.subtractFilters) {
                filters[i][0] = "subtract";
                filters[i][1] = subs;
                ++i;
            }
            for (String inters : this.intersectFilters) {
                filters[i][0] = "intersect";
                filters[i][1] = inters;
                ++i;
            }
            this.transforms.addTransform("http://www.w3.org/2002/06/xmldsig-filter2", APXSFileSigner.newInstances(this.doc, filters));
        }
        this.transforms.addTransform("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments");
        sig.addDocument("", this.transforms, "http://www.w3.org/2000/09/xmldsig#sha1");
        X509Certificate cert = (X509Certificate)this.ks.getCertificate(this.alias);
        sig.addKeyInfo(cert);
        sig.addKeyInfo(cert.getPublicKey());
        try {
            sig.sign((Key)this.privateKey);
            this.setSignOK(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        try {
            FileOutputStream f = new FileOutputStream(this.outputFile);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer t = tf.newTransformer();
            t.setOutputProperty("encoding", "ISO-8859-1");
            t.setOutputProperty("method", "xml");
            t.transform(new DOMSource(this.doc), new StreamResult(f));
            f.flush();
            f.close();
            this.setWriteOK(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        catch (Error e) {
            e.printStackTrace();
            return;
        }
    }

    public void dispose() {
        this.doc = null;
        this.root = null;
    }

    public String getNomBonhomme(String rawAlias) {
        try {
            X509Certificate cert = (X509Certificate)this.ks.getCertificate(rawAlias);
            if (cert != null) {
                String dn = cert.getSubjectDN().getName();
                StringTokenizer tokenizer = new StringTokenizer(dn, ",");
                while (tokenizer.hasMoreTokens()) {
                    String tok = tokenizer.nextToken().trim();
                    if (!tok.startsWith("CN=")) continue;
                    return tok.substring(3);
                }
                return "<non d\u00e9finit>";
            }
            return rawAlias;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "Exception " + rawAlias;
        }
    }

    public String getEmetteur(String rawAlias) {
        try {
            X509Certificate cert = (X509Certificate)this.ks.getCertificate(rawAlias);
            if (cert != null) {
                String dn = cert.getIssuerX500Principal().getName();
                StringTokenizer tokenizer = new StringTokenizer(dn, ",");
                while (tokenizer.hasMoreTokens()) {
                    String tok = tokenizer.nextToken().trim();
                    if (!tok.startsWith("CN=")) continue;
                    return tok.substring(3);
                }
                return "<non d\u00e9finit>";
            }
            return rawAlias;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "Exception " + rawAlias;
        }
    }

    public Date getDebutValidite(String rawAlias) {
        try {
            X509Certificate cert = (X509Certificate)this.ks.getCertificate(rawAlias);
            if (cert != null) {
                return cert.getNotBefore();
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Date getFinValidite(String rawAlias) {
        try {
            X509Certificate cert = (X509Certificate)this.ks.getCertificate(rawAlias);
            if (cert != null) {
                return cert.getNotAfter();
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        Init.init();
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

