/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.plugin.generatorPesPjs;

import fr.gouv.finances.cp.xemelios.plugin.generatorPesPjs.RefCompta;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableModelRefCompta
extends AbstractTableModel {
    private Vector<RefCompta> data;

    public TableModelRefCompta(Vector<RefCompta> data) {
        this.data = data;
    }

    public TableModelRefCompta() {
        this(new Vector<RefCompta>());
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        RefCompta refCompta = this.data.get(row);
        switch (col) {
            case 0: {
                return refCompta.getDomaine();
            }
            case 1: {
                return refCompta.getTypePiece().key + " - " + refCompta.getTypePiece().libelle;
            }
            case 2: {
                return refCompta.getNumPiece();
            }
        }
        return "<error>";
    }

    public Class getColumnClass(int c) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "Domaine";
            }
            case 1: {
                return "Type de Pi\u00e8ce";
            }
            case 2: {
                return "Num\u00e9ro de Mandat";
            }
        }
        return "<error>";
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    public void add(RefCompta rc) {
        this.data.add(rc);
        System.out.println("RefCompta ajout\u00e9e");
        this.fireTableRowsInserted(0, this.data.size());
    }

    public void remove(int pos) {
        this.data.removeElementAt(pos);
        System.out.println("RefCompta supprim\u00e9e");
        this.fireTableRowsDeleted(0, this.data.size());
    }

    public void refresh() {
        this.fireTableRowsUpdated(0, this.data.size());
    }

    public RefCompta getData(int pos) {
        return this.data.get(pos);
    }
}

