/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.plugin.generatorPesPjs;

import fr.gouv.finances.cp.xemelios.plugin.generatorPesPjs.DlgMakePJ;
import fr.gouv.finances.cp.xemelios.plugin.generatorPesPjs.PJ;
import fr.gouv.finances.cp.xemelios.plugin.generatorPesPjs.RefCompta;
import fr.gouv.finances.cp.xemelios.plugin.generatorPesPjs.TableModelPJ;
import fr.gouv.finances.cp.xemelios.ui.MainWindow;
import fr.gouv.finances.dgfip.utils.Base64;
import fr.gouv.finances.dgfip.utils.Pair;
import fr.gouv.finances.dgfip.utils.xml.NamespaceContextImpl;
import fr.gouv.finances.dgfip.xemelios.common.config.DocumentModel;
import fr.gouv.finances.dgfip.xemelios.common.config.DocumentsModel;
import fr.gouv.finances.dgfip.xemelios.common.config.Loader;
import fr.gouv.finances.dgfip.xemelios.importers.EtatImporteur;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.filechooser.FileFilter;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.jdesktop.layout.GroupLayout;
import org.jdesktop.swingx.action.AbstractActionExt;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DlgGenPesPjs
extends JDialog {
    private JFrame parentWindow;
    private TableModelPJ tableModel = new TableModelPJ();
    private static final String NAMESPACE_PES_ALLER = "http://www.minefi.gouv.fr/cp/helios/pes_v2/Rev0/aller";
    private static final String NAMESPACE_ENCRYPTED_DATA = "http://www.w3.org/2001/04/xmlenc#";
    private static final String NAMESPACE_PES_FACTURE = "http://www.minefi.gouv.fr/cp/helios/pes_v2/facture";
    private Action escapeAction;
    private Action enterAction;
    private DocumentsModel docModels;
    private DocumentBuilderFactory domFactory;
    private JButton AddPJ;
    private JPanel PanelGeneral;
    private JPanel PanelPieces;
    private JButton browse_button;
    private JButton close_button;
    private JTextField codBudg;
    private JTextField codColl;
    private JButton deletePJ;
    private JButton editPJ;
    private JTextField fileToGenerate;
    private JTextField finess;
    private JTextField idColl;
    private JTextField idPost;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JScrollPane jScrollPane1;
    private JTextField libCollBudg;
    private JTabbedPane onglets;
    private JButton save_button;
    private JTable tablePjs;

    public DlgGenPesPjs(JFrame parent, boolean modal) {
        super((Frame)parent, modal);
        this.parentWindow = parent;
        this.initComponents();
        if (MainWindow.instance != null) {
            this.docModels = MainWindow.instance.getDocModels();
        }
        this.initTextFields();
        this.tablePjs.setSelectionMode(0);
        this.setLocationRelativeTo(parent);
        this.domFactory = DocumentBuilderFactory.newInstance();
    }

    private void initComponents() {
        this.onglets = new JTabbedPane();
        this.PanelGeneral = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.fileToGenerate = new JTextField();
        this.idPost = new JTextField();
        this.idColl = new JTextField();
        this.finess = new JTextField();
        this.codColl = new JTextField();
        this.codBudg = new JTextField();
        this.libCollBudg = new JTextField();
        this.browse_button = new JButton();
        this.PanelPieces = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.tablePjs = new JTable(){

            public void valueChanged(ListSelectionEvent evt) {
                super.valueChanged(evt);
                DlgGenPesPjs.this.showHideButtons(evt);
            }
        };
        this.AddPJ = new JButton();
        this.editPJ = new JButton();
        this.deletePJ = new JButton();
        this.close_button = new JButton();
        this.save_button = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("G\u00e9n\u00e9rateur de flux PES PJ");
        this.onglets.setEnabled(false);
        this.onglets.setMaximumSize(new Dimension(1024, 768));
        this.onglets.setMinimumSize(new Dimension(300, 300));
        this.jLabel1.setText("Fichier \u00e0 g\u00e9n\u00e9rer");
        this.jLabel2.setText("Identifiant du poste");
        this.jLabel3.setText("Identifiant Collectivit\u00e9");
        this.jLabel4.setText("Finess Juridique");
        this.jLabel5.setText("Code Collectivit\u00e9");
        this.jLabel6.setText("Code Budget");
        this.jLabel7.setText("Libell\u00e9 Collectivit\u00e9 Budget");
        this.fileToGenerate.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent evt) {
                DlgGenPesPjs.this.fileToGenerateCaretUpdate(evt);
            }
        });
        this.idPost.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent evt) {
                DlgGenPesPjs.this.idPostCaretUpdate(evt);
            }
        });
        this.codColl.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent evt) {
                DlgGenPesPjs.this.codCollCaretUpdate(evt);
            }
        });
        this.codBudg.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent evt) {
                DlgGenPesPjs.this.codBudgCaretUpdate(evt);
            }
        });
        this.browse_button.setText("...");
        this.browse_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DlgGenPesPjs.this.browse_buttonActionPerformed(evt);
            }
        });
        GroupLayout PanelGeneralLayout = new GroupLayout((Container)this.PanelGeneral);
        this.PanelGeneral.setLayout((LayoutManager)PanelGeneralLayout);
        PanelGeneralLayout.setHorizontalGroup((GroupLayout.Group)PanelGeneralLayout.createParallelGroup(1).add((GroupLayout.Group)PanelGeneralLayout.createSequentialGroup().add(49, 49, 49).add((GroupLayout.Group)PanelGeneralLayout.createParallelGroup(2).add((Component)this.jLabel7).add((Component)this.jLabel2).add((Component)this.jLabel3).add((Component)this.jLabel4).add((Component)this.jLabel5).add((Component)this.jLabel6).add((Component)this.jLabel1)).addPreferredGap(0).add((GroupLayout.Group)PanelGeneralLayout.createParallelGroup(1).add((Component)this.idPost, -1, 335, Short.MAX_VALUE).add((Component)this.idColl, -1, 335, Short.MAX_VALUE).add((Component)this.finess, -1, 335, Short.MAX_VALUE).add((Component)this.codColl, -1, 335, Short.MAX_VALUE).add((Component)this.codBudg, -1, 335, Short.MAX_VALUE).add((Component)this.libCollBudg, -1, 335, Short.MAX_VALUE).add(2, (GroupLayout.Group)PanelGeneralLayout.createSequentialGroup().add((Component)this.fileToGenerate, -1, 272, Short.MAX_VALUE).add(18, 18, 18).add((Component)this.browse_button))).addContainerGap()));
        PanelGeneralLayout.setVerticalGroup((GroupLayout.Group)PanelGeneralLayout.createParallelGroup(1).add((GroupLayout.Group)PanelGeneralLayout.createSequentialGroup().add(27, 27, 27).add((GroupLayout.Group)PanelGeneralLayout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.browse_button).add((Component)this.fileToGenerate, -2, -1, -2)).add(12, 12, 12).add((GroupLayout.Group)PanelGeneralLayout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.idPost, -2, -1, -2)).add(18, 18, 18).add((GroupLayout.Group)PanelGeneralLayout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.idColl, -2, -1, -2)).add(18, 18, 18).add((GroupLayout.Group)PanelGeneralLayout.createParallelGroup(3).add((Component)this.jLabel4).add((Component)this.finess, -2, -1, -2)).add(18, 18, 18).add((GroupLayout.Group)PanelGeneralLayout.createParallelGroup(3).add((Component)this.jLabel5).add((Component)this.codColl, -2, -1, -2)).add(18, 18, 18).add((GroupLayout.Group)PanelGeneralLayout.createParallelGroup(3).add((Component)this.jLabel6).add((Component)this.codBudg, -2, -1, -2)).add(18, 18, 18).add((GroupLayout.Group)PanelGeneralLayout.createParallelGroup(3).add((Component)this.jLabel7).add((Component)this.libCollBudg, -2, -1, -2)).addContainerGap(39, Short.MAX_VALUE)));
        this.onglets.addTab("G\u00e9n\u00e9ralit\u00e9s", this.PanelGeneral);
        this.tablePjs.setModel(this.tableModel);
        this.tablePjs.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                DlgGenPesPjs.this.tablePjsMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.tablePjs);
        this.AddPJ.setText("Ajouter");
        this.AddPJ.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DlgGenPesPjs.this.AddPJActionPerformed(evt);
            }
        });
        this.editPJ.setText("Editer");
        this.editPJ.setEnabled(false);
        this.editPJ.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DlgGenPesPjs.this.editPJActionPerformed(evt);
            }
        });
        this.deletePJ.setText("Supprimer");
        this.deletePJ.setEnabled(false);
        this.deletePJ.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DlgGenPesPjs.this.deletePJActionPerformed(evt);
            }
        });
        GroupLayout PanelPiecesLayout = new GroupLayout((Container)this.PanelPieces);
        this.PanelPieces.setLayout((LayoutManager)PanelPiecesLayout);
        PanelPiecesLayout.setHorizontalGroup((GroupLayout.Group)PanelPiecesLayout.createParallelGroup(1).add((GroupLayout.Group)PanelPiecesLayout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -1, 361, Short.MAX_VALUE).add(18, 18, 18).add((GroupLayout.Group)PanelPiecesLayout.createParallelGroup(1).add((Component)this.deletePJ, -1, 120, Short.MAX_VALUE).add((Component)this.editPJ, -1, 120, Short.MAX_VALUE).add((Component)this.AddPJ, -1, 120, Short.MAX_VALUE)).addContainerGap()));
        PanelPiecesLayout.setVerticalGroup((GroupLayout.Group)PanelPiecesLayout.createParallelGroup(1).add(2, (GroupLayout.Group)PanelPiecesLayout.createSequentialGroup().add(51, 51, 51).add((Component)this.jScrollPane1, -1, 221, Short.MAX_VALUE).add(33, 33, 33)).add(2, (GroupLayout.Group)PanelPiecesLayout.createSequentialGroup().addContainerGap(104, Short.MAX_VALUE).add((Component)this.AddPJ).add(27, 27, 27).add((Component)this.editPJ).add(27, 27, 27).add((Component)this.deletePJ).add(78, 78, 78)));
        this.onglets.addTab("Pi\u00e8ces Justificatives", this.PanelPieces);
        this.close_button.setText("Fermer");
        this.close_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DlgGenPesPjs.this.close_buttonActionPerformed(evt);
            }
        });
        this.save_button.setText("Enregistrer");
        this.save_button.setEnabled(false);
        this.save_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DlgGenPesPjs.this.save_buttonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.onglets, -1, -1, Short.MAX_VALUE).addContainerGap()).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.close_button).add(18, 18, 18).add((Component)this.save_button).add(14, 14, 14)))));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.onglets, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.save_button).add((Component)this.close_button)).addContainerGap()));
        this.pack();
    }

    private void fileToGenerateCaretUpdate(CaretEvent evt) {
        this.doCheck();
    }

    private void idPostCaretUpdate(CaretEvent evt) {
        this.doCheck();
    }

    private void codCollCaretUpdate(CaretEvent evt) {
        this.doCheck();
    }

    private void codBudgCaretUpdate(CaretEvent evt) {
        this.doCheck();
    }

    private void AddPJActionPerformed(ActionEvent evt) {
        DlgMakePJ makePj = new DlgMakePJ(this.parentWindow, true);
        makePj.setIdCollIdPostCodBud(this.idColl.getText(), this.idPost.getText(), this.codColl.getText(), this.codBudg.getText());
        if (makePj.run()) {
            this.tableModel.add(makePj.getPiece_justificative());
        }
    }

    private void editPJActionPerformed(ActionEvent evt) {
        this.editPJ();
    }

    private void deletePJActionPerformed(ActionEvent evt) {
        this.tableModel.remove(this.tablePjs.getSelectedRow());
    }

    private void close_buttonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void save_buttonActionPerformed(ActionEvent evt) {
        this.saveFluxPESPJ();
    }

    private void browse_buttonActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser();
        fc.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory() || f.getName().toUpperCase().endsWith("XML");
            }

            public String getDescription() {
                return "Document XML";
            }
        });
        int reponse = fc.showOpenDialog(this);
        if (reponse == 0) {
            this.fileToGenerate.setText(fc.getSelectedFile().getAbsolutePath().toUpperCase().contains(".XML") ? fc.getSelectedFile().getAbsolutePath() : fc.getSelectedFile().getAbsolutePath() + ".xml");
        }
    }

    private void tablePjsMouseClicked(MouseEvent evt) {
        if (this.tablePjs.getSelectedRow() != -1 && evt.getClickCount() == 2 && evt.getButton() == 1) {
            this.editPJ();
        }
    }

    private void editPJ() {
        DlgMakePJ dlgMakePJ = new DlgMakePJ(this.parentWindow, true);
        int rowSeleted = this.tablePjs.getSelectedRow();
        if (dlgMakePJ.runEdit(this.tableModel.getData(rowSeleted))) {
            this.tableModel.refresh();
        }
    }

    private void saveFluxPESPJ() {
        if (this.formIsValid()) {
            try {
                this.startVentilateur();
                this.setPropertiesGeneratorPESPJs();
                Document doc = this.createDOMdoc();
                TransformerFactory tf = TransformerFactory.newInstance();
                Transformer trans = tf.newTransformer();
                Properties props = new Properties();
                props.setProperty("encoding", "ISO-8859-1");
                props.setProperty("indent", "yes");
                props.setProperty("method", "xml");
                trans.setOutputProperties(props);
                trans.transform(new DOMSource(doc), new StreamResult(new File(this.fileToGenerate.getText())));
                this.stopVentilateur();
                if (MainWindow.instance != null) {
                    int response = JOptionPane.showConfirmDialog(this.parentWindow, "Le flux PES PJ \u00e0 bien \u00e9t\u00e9 g\u00e9n\u00e9r\u00e9.\n\nD\u00e9sirez vous l'importer ?", "Importation du flux PES PJ g\u00e9n\u00e9r\u00e9", 0);
                    if (0 == response) {
                        this.importer(this.docModels.getDocumentById("PES_Aller"), new Pair(this.idColl.getText(), this.libCollBudg.getText()), new Pair(this.codBudg.getText(), this.libCollBudg.getText()), new File(this.fileToGenerate.getText()));
                        this.setVisible(false);
                    }
                } else {
                    JOptionPane.showMessageDialog(this.parentWindow, "Le flux PES PJ \u00e0 bien \u00e9t\u00e9 g\u00e9n\u00e9r\u00e9.", "G\u00e9n\u00e9ration du flux PES PJ", 0);
                }
                this.resetDialog();
            }
            catch (TransformerException ex) {
                Logger.getLogger(DlgGenPesPjs.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importer(DocumentModel dm, Pair coll, Pair budg, File f) {
        try {
            Class<?> clazz = Class.forName(dm.getImportClass());
            Object obj = clazz.newInstance();
            if (!(obj instanceof EtatImporteur)) {
                JOptionPane.showMessageDialog((Component)MainWindow.instance, "Cette classe n'est pas un importeur.\nLe fichier de configuration qui vous a \u00e9t\u00e9 livr\u00e9 est certainement invalide.\nVeuillez contacter votre fournisseur.\n", "Erreur", 0);
                return;
            }
            EtatImporteur ei = (EtatImporteur)obj;
            ei.setDocument(dm, coll, budg);
            ArrayList<File> array = new ArrayList<File>();
            array.add(f);
            MainWindow.ImportContent fToImport = new MainWindow.ImportContent();
            fToImport.setFilesToImport(array);
            MainWindow.instance.doImport(ei, fToImport, dm, true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected DocumentsModel getDocumentsInfosGenPesPjs(String repertoires) {
        DocumentsModel ret = null;
        try {
            ret = Loader.getDocumentsInfos((String)repertoires);
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
        return ret;
    }

    private void setPropertiesGeneratorPESPJs() {
        FileOutputStream fos = null;
        try {
            File f = new File(System.getProperty("user.home"), "xemelios-PJ-generator.properties");
            System.out.println("fichier de proprietes dans : " + f.getAbsolutePath());
            Properties props = new Properties();
            if (f.exists()) {
                FileInputStream fis = new FileInputStream(f);
                props.load(fis);
                fis.close();
            }
            fos = new FileOutputStream(f);
            props.setProperty("idpost", this.idPost.getText());
            props.setProperty("idcoll", this.idColl.getText());
            props.setProperty("finess", this.finess.getText());
            props.setProperty("codcoll", this.codColl.getText());
            props.setProperty("codbudg", this.codBudg.getText());
            props.setProperty("libcodbudg", this.libCollBudg.getText());
            props.store(fos, "");
            fos.flush();
            fos.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void resetDialog() {
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            this.tableModel.remove(i);
        }
        this.onglets.setSelectedIndex(0);
        this.fileToGenerate.setText("");
        this.onglets.setEnabled(false);
        this.doCheck();
    }

    private void showHideButtons(ListSelectionEvent evt) {
        if (evt.getFirstIndex() >= 0 && this.tablePjs.getSelectedRow() != -1) {
            this.editPJ.setEnabled(true);
            this.deletePJ.setEnabled(true);
        } else {
            this.editPJ.setEnabled(false);
            this.deletePJ.setEnabled(false);
        }
    }

    private Document createDOMdoc() {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.newDocument();
            Element root = doc.createElementNS(NAMESPACE_PES_ALLER, "n:PES_Aller");
            root.setAttribute("xmlns:n", NAMESPACE_PES_ALLER);
            doc.appendChild(root);
            this.createEnveloppe(doc);
            this.createEntetePES(doc);
            if (this.tableModel.getRowCount() > 0) {
                this.createPES_PJ(doc);
            }
            return doc;
        }
        catch (ParserConfigurationException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private void createEnveloppe(Document doc) {
        Element enveloppe = doc.createElementNS("", "Enveloppe");
        Element parametre = doc.createElementNS("", "Parametres");
        Element version = doc.createElementNS("", "Version");
        version.setAttribute("V", "01");
        Element typeFic = doc.createElementNS("", "TypFic");
        typeFic.setAttribute("V", "PES_PJ");
        Element nomFic = doc.createElementNS("", "NomFic");
        nomFic.setAttribute("V", new File(this.fileToGenerate.getText()).getName());
        parametre.appendChild(version);
        parametre.appendChild(typeFic);
        parametre.appendChild(nomFic);
        enveloppe.appendChild(parametre);
        doc.getChildNodes().item(0).appendChild(enveloppe);
    }

    private void createEntetePES(Document doc) {
        Element entetePES = doc.createElementNS("", "EnTetePES");
        Element dteStr = doc.createElementNS("", "DteStr");
        dteStr.setAttribute("V", new SimpleDateFormat("yyyy-MM-dd").format(new Date()));
        Element idPoste = null;
        if (this.idPost.getText().length() != 0) {
            idPoste = doc.createElementNS("", "IdPost");
            idPoste.setAttribute("V", this.idPost.getText());
        }
        Element idCollec = null;
        if (this.idColl.getText().length() != 0) {
            idCollec = doc.createElementNS("", "IdColl");
            idCollec.setAttribute("V", this.idColl.getText());
        }
        Element finJur = null;
        if (this.finess.getText().length() != 0) {
            finJur = doc.createElementNS("", "FinJur");
            finJur.setAttribute("V", this.finess.getText());
        }
        Element codCollec = null;
        if (this.codColl.getText().length() != 0) {
            codCollec = doc.createElementNS("", "CodCol");
            codCollec.setAttribute("V", this.codColl.getText());
        }
        Element codBud = null;
        if (this.codBudg.getText().length() != 0) {
            codBud = doc.createElementNS("", "CodBud");
            codBud.setAttribute("V", this.codBudg.getText());
        }
        Element libelleColBud = null;
        if (this.libCollBudg.getText().length() != 0) {
            libelleColBud = doc.createElementNS("", "LibelleColBud");
            libelleColBud.setAttribute("V", this.libCollBudg.getText());
        }
        entetePES.appendChild(dteStr);
        if (idPoste != null) {
            entetePES.appendChild(idPoste);
        }
        if (idCollec != null) {
            entetePES.appendChild(idCollec);
        }
        if (finJur != null) {
            entetePES.appendChild(finJur);
        }
        if (codCollec != null) {
            entetePES.appendChild(codCollec);
        }
        if (codBud != null) {
            entetePES.appendChild(codBud);
        }
        if (libelleColBud != null) {
            entetePES.appendChild(libelleColBud);
        }
        doc.getChildNodes().item(0).appendChild(entetePES);
    }

    private void createPES_PJ(Document doc) {
        try {
            Element PES_PJ = doc.createElementNS("", "PES_PJ");
            Element entetePES_PJ = doc.createElementNS("", "EnTetePES_PJ");
            Element idVer = doc.createElementNS("", "IdVer");
            idVer.setAttribute("V", "1");
            entetePES_PJ.appendChild(idVer);
            PES_PJ.appendChild(entetePES_PJ);
            this.createPJs(doc, PES_PJ);
            doc.getChildNodes().item(0).appendChild(PES_PJ);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void createPJs(Document doc, Element pes_pj) throws IOException {
        Vector<Element> vpce = new Vector<Element>();
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            PJ pj = this.tableModel.getData(i);
            Element contenu = doc.createElementNS("", "Contenu");
            Element pce = doc.createElementNS("", "PJ");
            if (!pj.getTypePJ().contains("Facture")) {
                Element fichier = doc.createElementNS("", "Fichier");
                fichier.setAttributeNS("", "MIMEType", pj.getPjFile().getName().substring(pj.getPjFile().getName().length() - 3, pj.getPjFile().getName().length()));
                FileInputStream fis = new FileInputStream(pj.getPjFile());
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                GZIPOutputStream gzo = new GZIPOutputStream(baos);
                byte[] bTmp = new byte[2048];
                int read = 0;
                do {
                    if ((read = fis.read(bTmp)) <= 0) continue;
                    gzo.write(bTmp, 0, read);
                } while (read > 0);
                fis.close();
                gzo.finish();
                gzo.flush();
                gzo.close();
                Text txt = doc.createTextNode(Base64.encodeBytes((byte[])baos.toByteArray(), (boolean)true));
                fichier.appendChild(txt);
                baos.close();
                contenu.appendChild(fichier);
                pce.appendChild(contenu);
            } else {
                try {
                    FileInputStream fis = new FileInputStream(pj.getPjFile());
                    DocumentBuilder domBuilder = this.domFactory.newDocumentBuilder();
                    Document document = domBuilder.parse(new InputSource(fis));
                    XPathFactory xpf = XPathFactory.newInstance();
                    XPath xp = xpf.newXPath();
                    NamespaceContextImpl ns = new NamespaceContextImpl();
                    ns.addMapping("", NAMESPACE_PES_FACTURE);
                    ns.addMapping("n", NAMESPACE_PES_FACTURE);
                    xp.setNamespaceContext((NamespaceContext)ns);
                    Element pesFacture = (Element)xp.evaluate("/n:PESFacture", document, XPathConstants.NODE);
                    if (pesFacture == null) {
                        throw new SAXException("ce n'est pas un PES Facture");
                    }
                    Node node = doc.adoptNode(pesFacture);
                    contenu.appendChild(node);
                    pce.appendChild(contenu);
                }
                catch (ParserConfigurationException pcEx) {
                    Logger.getLogger(DlgGenPesPjs.class.getName()).log(Level.SEVERE, "while instanciating new dom parser", pcEx);
                }
                catch (Exception ex) {
                    Element fichier = doc.createElementNS("", "Fichier");
                    fichier.setAttributeNS("", "MIMEType", pj.getPjFile().getName().substring(pj.getPjFile().getName().length() - 3, pj.getPjFile().getName().length()));
                    FileInputStream fis = new FileInputStream(pj.getPjFile());
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    GZIPOutputStream gzo = new GZIPOutputStream(baos);
                    byte[] bTmp = new byte[2048];
                    int read = 0;
                    do {
                        if ((read = fis.read(bTmp)) <= 0) continue;
                        gzo.write(bTmp, 0, read);
                    } while (read > 0);
                    fis.close();
                    gzo.finish();
                    gzo.flush();
                    gzo.close();
                    Text txt = doc.createTextNode(Base64.encodeBytes((byte[])baos.toByteArray(), (boolean)true));
                    fichier.appendChild(txt);
                    baos.close();
                    contenu.appendChild(fichier);
                    pce.appendChild(contenu);
                }
            }
            Element idUnique = doc.createElementNS("", "IdUnique");
            idUnique.setAttribute("V", pj.getIdentifiant());
            Element nomPJ = doc.createElementNS("", "NomPJ");
            nomPJ.setAttribute("V", pj.getPjFile().getName());
            Element typePJ = doc.createElementNS("", "TypePJ");
            typePJ.setAttribute("V", pj.getTypePJ().split(" - ")[0]);
            Element desc = doc.createElementNS("", "Description");
            desc.setAttribute("V", pj.getDescription());
            pce.appendChild(idUnique);
            pce.appendChild(nomPJ);
            pce.appendChild(typePJ);
            pce.appendChild(desc);
            this.createRefsComptas(doc, pj, pce);
            vpce.add(pce);
        }
        for (Element e : vpce) {
            pes_pj.appendChild(e);
        }
    }

    private void createRefsComptas(Document doc, PJ pj, Element pce) {
        for (RefCompta rc : pj.getVRefsComptas()) {
            Element idTiers;
            Element codProd;
            Element complId;
            Element refCompta = doc.createElementNS("", "RefCompta");
            Element domaine = doc.createElementNS("", "Domaine");
            domaine.setAttribute("V", rc.getDomaine().split(" - ")[0]);
            Element exer = doc.createElementNS("", "Exercice");
            exer.setAttribute("V", rc.getExercice().toString());
            Element typObj = doc.createElementNS("", "TypeObjet");
            typObj.setAttribute("V", rc.getTypePiece().key);
            Element id = doc.createElementNS("", "Identifiant");
            id.setAttribute("V", rc.getNumPiece().toString());
            if (rc.getNumLignePiece().length() != 0) {
                complId = doc.createElementNS("", "ComplementIdentifiant");
                complId.setAttribute("V", rc.getNumLignePiece().toString());
            } else {
                complId = null;
            }
            if (rc.getCodeProduit().length() != 0) {
                codProd = doc.createElementNS("", "CodProd");
                codProd.setAttribute("V", rc.getCodeProduit());
            } else {
                codProd = null;
            }
            if (rc.getIdTiers().length() != 0) {
                idTiers = doc.createElementNS("", "IdTiers");
                idTiers.setAttribute("V", rc.getIdTiers());
            } else {
                idTiers = null;
            }
            refCompta.appendChild(domaine);
            refCompta.appendChild(exer);
            refCompta.appendChild(typObj);
            refCompta.appendChild(id);
            if (complId != null) {
                refCompta.appendChild(complId);
            }
            if (codProd != null) {
                refCompta.appendChild(codProd);
            }
            if (idTiers != null) {
                refCompta.appendChild(idTiers);
            }
            pce.appendChild(refCompta);
        }
    }

    private void initTextFields() {
        String configFileName = System.getProperty("user.home");
        File f = new File(configFileName, "xemelios-PJ-generator.properties");
        if (f.exists()) {
            Properties props = new Properties();
            System.out.println("in initTextFields()");
            try {
                props.load(new FileInputStream(f));
                this.idPost.setText(props.getProperty("idpost"));
                this.idColl.setText(props.getProperty("idcoll"));
                this.finess.setText(props.getProperty("finess"));
                this.codColl.setText(props.getProperty("codcoll"));
                this.codBudg.setText(props.getProperty("codbudg"));
                this.libCollBudg.setText(props.getProperty("libcollbudg"));
            }
            catch (FileNotFoundException ex) {
                System.out.println("Fichier " + configFileName + " introuvable!");
            }
            catch (IOException ex) {
                ex.getMessage();
            }
        }
        this.doCheck();
    }

    private void doCheck() {
        if (this.fileToGenerate.getText().length() > 0 && this.idPost.getText().length() > 0 && this.codColl.getText().length() > 0 && this.codBudg.getText().length() > 0) {
            this.onglets.setEnabled(true);
            this.save_button.setEnabled(true);
        } else {
            this.onglets.setEnabled(false);
            this.save_button.setEnabled(false);
        }
    }

    private boolean formIsValid() {
        String message = "";
        JTextField jtf = null;
        if (!this.fileToGenerate.getText().toUpperCase().endsWith(".XML")) {
            message = "Le nom du fichier est incorrect.\nIl doit se terminer pas .XML";
            jtf = this.fileToGenerate;
        } else if (this.idPost.getText().length() > 7) {
            message = "L'identifiant du poste ne peut exc\u00e9der 7 caract\u00e8res.";
            jtf = this.idPost;
        } else if (this.idPost.getText().length() == 0) {
            message = "L'identifiant du poste est obligatoire.";
            jtf = this.idPost;
        } else if (this.codColl.getText().length() == 0) {
            message = "Le code de la collectivit\u00e9 est obligatoire.";
            jtf = this.codColl;
        } else if (this.codColl.getText().length() > 3) {
            message = "Le code de la collectivit\u00e9 ne peut exc\u00e9der 3 caract\u00e8res.";
            jtf = this.codColl;
        } else if (!this.codColl.getText().matches("[0-9a-zA-Z]*")) {
            message = "Le code de la collectivit\u00e9 ne peut contenir que les caract\u00e8res suivants:\n\nDes chiffres de 0 \u00e0 9\nDes lettres de a \u00e0 z ou de A \u00e0 Z";
            jtf = this.codColl;
        } else if (this.codBudg.getText().length() == 0) {
            message = "Le code du budget est obligatoire.";
            jtf = this.codBudg;
        } else if (this.codBudg.getText().length() > 2) {
            message = "Le code du budget ne peut exc\u00e9der 2 caract\u00e8res.";
            jtf = this.codBudg;
        } else if (!this.codBudg.getText().matches("[0-9a-zA-Z]*")) {
            message = "Le code du budget ne peut contenir que les caract\u00e8res suivants:\n\nDes chiffres de 0 \u00e0 9\nDes lettres de a \u00e0 z ou de A \u00e0 Z";
            jtf = this.codBudg;
        } else {
            return true;
        }
        JOptionPane.showMessageDialog(this, message, "Erreur de saisie d'informations", 0);
        if (this.onglets.getSelectedIndex() == 1) {
            this.onglets.setSelectedIndex(0);
        }
        jtf.requestFocus();
        return false;
    }

    public void stopVentilateur() {
        this.getGlassPane().setVisible(false);
    }

    public void startVentilateur() {
        this.getGlassPane().setVisible(true);
    }

    public void run() {
        this.setVisible(true);
    }

    protected JRootPane createRootPane() {
        KeyStroke ksEsc = KeyStroke.getKeyStroke(27, 0);
        KeyStroke ksEnter = KeyStroke.getKeyStroke(10, 0);
        JRootPane rp = new JRootPane();
        this.escapeAction = new AbstractActionExt("Fermer"){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent evt) {
                DlgGenPesPjs.this.setVisible(false);
            }

            public void itemStateChanged(ItemEvent e) {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        };
        this.enterAction = new AbstractActionExt("Save"){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent evt) {
                DlgGenPesPjs.this.saveFluxPESPJ();
            }

            public void itemStateChanged(ItemEvent e) {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        };
        rp.registerKeyboardAction(this.escapeAction, "TOTOTOTO", ksEsc, 2);
        rp.registerKeyboardAction(this.enterAction, "TOTOTOTO", ksEnter, 2);
        return rp;
    }
}

