/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.plugin.generatorPesPjs;

import fr.gouv.finances.cp.xemelios.plugin.generatorPesPjs.RefCompta;
import fr.gouv.finances.dgfip.utils.Pair;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.jdesktop.layout.GroupLayout;
import org.jdesktop.swingx.action.AbstractActionExt;

public class DlgEditRefCompta
extends JDialog {
    private boolean isEdit = false;
    private boolean bRet;
    private RefCompta referenceComptable;
    private Action escapeAction;
    private Action enterAction;
    private JButton cancel_button;
    private JTextField code_produit;
    private JComboBox domaines;
    private JTextField exercice;
    private JTextField id_tiers;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JSeparator jSeparator1;
    private JLabel label_code_produit;
    private JLabel label_id_tiers;
    private JLabel label_num_ligne_piece;
    private JLabel label_num_piece;
    private JLabel label_type_piece;
    private JTextField num_ligne_piece;
    private JTextField num_piece;
    private JButton save_button;
    private JComboBox type_piece;

    public DlgEditRefCompta(JFrame parent, boolean modal) {
        super((Frame)parent, modal);
        this.initComponents();
        this.setLocationRelativeTo(parent);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.domaines = new JComboBox();
        this.jLabel2 = new JLabel();
        this.exercice = new JTextField();
        this.label_type_piece = new JLabel();
        this.type_piece = new JComboBox();
        this.label_num_piece = new JLabel();
        this.num_piece = new JTextField();
        this.label_num_ligne_piece = new JLabel();
        this.num_ligne_piece = new JTextField();
        this.label_code_produit = new JLabel();
        this.code_produit = new JTextField();
        this.label_id_tiers = new JLabel();
        this.id_tiers = new JTextField();
        this.jSeparator1 = new JSeparator();
        this.cancel_button = new JButton();
        this.save_button = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Cr\u00e9ation d'une R\u00e9f\u00e9rence Comptable");
        this.jLabel1.setText("Domaine");
        this.domaines.setModel(new DefaultComboBoxModel<String>(new String[]{"01 - D\u00e9pense", "02 - Recette", "04 - Budget", "06 - March\u00e9"}));
        this.domaines.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                DlgEditRefCompta.this.domainesItemStateChanged(evt);
            }
        });
        this.jLabel2.setText("Exercice");
        this.exercice.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent evt) {
                DlgEditRefCompta.this.exerciceCaretUpdate(evt);
            }
        });
        this.label_type_piece.setText("Type de pi\u00e8ce");
        this.label_num_piece.setText("Num\u00e9ro de Mandat");
        this.num_piece.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent evt) {
                DlgEditRefCompta.this.num_pieceCaretUpdate(evt);
            }
        });
        this.label_num_ligne_piece.setText("Num\u00e9ro de Ligne de Mandat");
        this.label_code_produit.setText("Code Produit");
        this.label_id_tiers.setText("Identifiant Tiers");
        this.cancel_button.setText("Annuler");
        this.cancel_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DlgEditRefCompta.this.cancel_buttonActionPerformed(evt);
            }
        });
        this.save_button.setText("Enregistrer");
        this.save_button.setEnabled(false);
        this.save_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DlgEditRefCompta.this.save_buttonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(10, 10, 10).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.label_code_produit).add((Component)this.label_num_ligne_piece).add((Component)this.label_num_piece).add((Component)this.label_type_piece).add((Component)this.jLabel1).add((Component)this.jLabel2).add((Component)this.label_id_tiers)).add(18, 18, 18).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.type_piece, 0, 353, Short.MAX_VALUE).add((Component)this.exercice, -1, 353, Short.MAX_VALUE).add((Component)this.num_piece, -1, 353, Short.MAX_VALUE).add((Component)this.num_ligne_piece, -1, 353, Short.MAX_VALUE).add((Component)this.code_produit, -1, 353, Short.MAX_VALUE).add((Component)this.id_tiers, -1, 353, Short.MAX_VALUE).add((Component)this.domaines, 0, 353, Short.MAX_VALUE)).addContainerGap()).add((Component)this.jSeparator1, -1, 525, Short.MAX_VALUE).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap(343, Short.MAX_VALUE).add((Component)this.cancel_button).add(18, 18, 18).add((Component)this.save_button).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.domaines, -2, -1, -2)).add(15, 15, 15).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.exercice, -2, -1, -2).add((Component)this.jLabel2)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.label_type_piece).add((Component)this.type_piece, -2, -1, -2)).add(12, 12, 12).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.label_num_piece).add((Component)this.num_piece, -2, -1, -2)).add(18, 18, 18).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.label_num_ligne_piece).add((Component)this.num_ligne_piece, -2, -1, -2)).add(18, 18, 18).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.label_code_produit).add((Component)this.code_produit, -2, -1, -2)).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(17, 17, 17).add((Component)this.id_tiers, -2, -1, -2)).add((GroupLayout.Group)layout.createSequentialGroup().add(18, 18, 18).add((Component)this.label_id_tiers)))).add((GroupLayout.Group)layout.createSequentialGroup().add(224, 224, 224).add((Component)this.jSeparator1, -2, 10, -2))).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.save_button).add((Component)this.cancel_button)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void domainesItemStateChanged(ItemEvent evt) {
        this.initComportement();
    }

    private void cancel_buttonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void save_buttonActionPerformed(ActionEvent evt) {
        this.saveRefCompta();
    }

    private void saveRefCompta() {
        if (this.isValidForm()) {
            String[] tabpce = this.type_piece.getSelectedItem().toString().contains("-") ? this.type_piece.getSelectedItem().toString().split(" - ") : new String[]{"", ""};
            Pair typce = new Pair(tabpce[0], tabpce[1]);
            if (!this.isEdit) {
                this.referenceComptable = new RefCompta(this.domaines.getSelectedItem().toString(), Integer.parseInt(this.exercice.getText()), typce, this.num_piece.getText(), this.num_ligne_piece.getText(), this.code_produit.getText(), this.id_tiers.getText());
            } else {
                this.referenceComptable.modifRefCompta(this.domaines.getSelectedItem().toString(), Integer.parseInt(this.exercice.getText()), typce, this.num_piece.getText(), this.num_ligne_piece.getText(), this.code_produit.getText(), this.id_tiers.getText());
            }
            this.bRet = true;
            this.setVisible(false);
        }
    }

    private void exerciceCaretUpdate(CaretEvent evt) {
        this.doCheck();
    }

    private void num_pieceCaretUpdate(CaretEvent evt) {
        this.doCheck();
    }

    public boolean run() {
        this.initComportement();
        this.setVisible(true);
        return this.bRet;
    }

    public boolean runEdit(RefCompta rc) {
        this.isEdit = true;
        this.referenceComptable = rc;
        this.initComportement();
        this.initDlg();
        this.setVisible(true);
        return this.bRet;
    }

    private void initComportement() {
        String domaine = this.domaines.getSelectedItem().toString();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
        this.exercice.setText(sdf.format(new Date()));
        this.type_piece.removeAllItems();
        if (domaine.contains("D\u00e9pense")) {
            this.type_piece.addItem("01 - Mandat ordinaire");
            this.type_piece.addItem("02 - Mandat correctif");
            this.type_piece.addItem("03 - Mandat d'ordre budg\u00e9taire");
            this.type_piece.addItem("04 - Mandat d'ordre mixte");
            this.type_piece.addItem("05 - Mandat \u00e9mis apr\u00e8s paiement");
            this.type_piece.addItem("06 - Mandat global");
            this.type_piece.addItem("07 - Mandat d'admission en non valeurs");
            this.type_piece.addItem("08 - Mandat collectif");
            this.type_piece.addItem("09 - Mandat sur march\u00e9");
            this.type_piece.addItem("10 - Mandat de rattachement");
            this.type_piece.addItem("11 - Ordre de paiement");
            this.type_piece.addItem("12 - Demande \u00e9mission mandat");
            this.type_piece.addItem("13 - Charges constat\u00e9es d'avance");
            this.changeLabelPiece("Num\u00e9ro de Mandat");
            this.changeLabelLignePiece("Num\u00e9ro de ligne de Mandat");
            this.enabledLignePiece();
            this.disabledCodeProduit();
            this.disabledIdTiers();
        } else if (domaine.contains("Recette")) {
            this.type_piece.addItem("01 - Titre ordinaire");
            this.type_piece.addItem("02 - Titre correctif");
            this.type_piece.addItem("03 - Titre d'ordre budg\u00e9taire");
            this.type_piece.addItem("04 - Titre d'ordre mixte");
            this.type_piece.addItem("05 - Titre \u00e9mis apr\u00e8s encaissement");
            this.type_piece.addItem("06 - Titre r\u00e9capitulatif avec r\u00f4le");
            this.type_piece.addItem("07 - Titre r\u00e9capitulatif sans r\u00f4le");
            this.type_piece.addItem("08 - R\u00f4le titre");
            this.type_piece.addItem("09 - Titre de majoration");
            this.type_piece.addItem("10 - Titre en plusieurs ann\u00e9es");
            this.type_piece.addItem("11 - Titre de rattachement");
            this.type_piece.addItem("12 - Ordre de recette ordonnateur");
            this.type_piece.addItem("13 - Demande \u00e9mission de titre (P503)");
            this.type_piece.addItem("14 - Produits constat\u00e9s d'avance");
            this.changeLabelPiece("Num\u00e9ro de Titre ou de R\u00f4le");
            this.changeLabelLignePiece("Num\u00e9ro de ligne de Titre ou de R\u00f4le");
            this.enabledLignePiece();
            this.enabledCodeProduit();
            this.disabledIdTiers();
        } else if (domaine.contains("Budget")) {
            this.type_piece.addItem("01 - Budget primitif, (autorisation budg\u00e9taire)");
            this.type_piece.addItem("02 - D\u00e9cision modificative");
            this.type_piece.addItem("03 - Budget suppl\u00e9mentaire");
            this.type_piece.addItem("04 - Virement de cr\u00e9dit");
            this.type_piece.addItem("05 - Restes \u00e0 r\u00e9aliser (reports de cr\u00e9dit )");
            this.type_piece.addItem("06 - D\u00e9lib\u00e9ration sp\u00e9ciale");
            this.type_piece.addItem("07 - Budget de r\u00e9f\u00e9rence");
            this.type_piece.addItem("08 - Budget de saisine");
            this.type_piece.addItem("09 - Compte administratif");
            this.disabledLignePiece();
            this.disabledCodeProduit();
            this.disabledIdTiers();
        } else if (domaine.contains("March\u00e9")) {
            this.type_piece.addItem("01 - Contrat initial");
            this.type_piece.addItem("02 - Avenant sans impact financier");
            this.type_piece.addItem("03 - Avenant positif");
            this.type_piece.addItem("04 - Avenant n\u00e9gatif");
            this.type_piece.addItem("05 - Avenant mixte positif");
            this.type_piece.addItem("06 - Avenant mixte n\u00e9gatif");
            this.type_piece.addItem("07 - Avenant de transfert");
            this.type_piece.addItem("08 - Acte sp\u00e9cial");
            this.type_piece.addItem("09 - D\u00e9cision de poursuivre");
            this.disabledLignePiece();
            this.enabledCodeProduit();
            this.enabledIdTiers();
        }
    }

    private void doCheck() {
        if (this.exercice.getText().length() == 4 && this.num_piece.getText().length() > 0) {
            this.save_button.setEnabled(true);
        } else {
            this.save_button.setEnabled(false);
        }
    }

    private void changeLabelPiece(String text) {
        this.label_num_piece.setText(text);
    }

    private void changeLabelLignePiece(String text) {
        this.label_num_ligne_piece.setText(text);
    }

    private void enabledLignePiece() {
        this.num_ligne_piece.setEditable(true);
        this.label_num_ligne_piece.setEnabled(true);
    }

    private void disabledLignePiece() {
        this.num_ligne_piece.setEditable(false);
        this.num_ligne_piece.setText("");
        this.label_num_ligne_piece.setEnabled(false);
    }

    private void enabledCodeProduit() {
        this.code_produit.setEnabled(true);
        this.label_code_produit.setEnabled(true);
    }

    private void disabledCodeProduit() {
        this.code_produit.setEnabled(false);
        this.code_produit.setText("");
        this.label_code_produit.setEnabled(false);
    }

    private void enabledIdTiers() {
        this.id_tiers.setEnabled(true);
        this.label_id_tiers.setEnabled(true);
    }

    private void disabledIdTiers() {
        this.id_tiers.setEnabled(false);
        this.id_tiers.setText("");
        this.label_id_tiers.setEnabled(false);
    }

    private boolean isValidForm() {
        JTextField jtf;
        String message = "";
        Date d = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
        if (!this.exercice.getText().matches("[0-9][0-9][0-9][0-9]")) {
            message = "L'exercice doit contenir 4 chiffres de 0 \u00e0 9.";
            jtf = this.exercice;
        } else if (Integer.parseInt(this.exercice.getText()) > Integer.parseInt(sdf.format(d))) {
            message = "L'exercice ne peut \u00eatre sup\u00e9rieur \u00e0 l'ann\u00e9e en cours.";
            jtf = this.exercice;
        } else if (this.num_piece.getText().length() == 0) {
            message = "Le num\u00e9ro de mandat est obligatoire.";
            jtf = this.num_piece;
        } else {
            if (Math.abs(Integer.parseInt(this.exercice.getText()) - Integer.parseInt(sdf.format(d))) > 3) {
                JOptionPane.showMessageDialog(this, "Attention, l'exercice saisit a plus de trois ans.", "Avertissement", 1);
                return true;
            }
            return true;
        }
        JOptionPane.showMessageDialog(this, message, "Erreur de saisie d'informations", 0);
        jtf.requestFocus();
        return false;
    }

    public RefCompta getReferenceComptable() {
        return this.referenceComptable;
    }

    private void initDlg() {
        int i;
        for (i = 0; i < this.domaines.getItemCount(); ++i) {
            if (!this.domaines.getItemAt(i).equals(this.referenceComptable.getDomaine())) continue;
            this.domaines.setSelectedIndex(i);
        }
        this.exercice.setText(this.referenceComptable.getExercice().toString());
        for (i = 0; i < this.type_piece.getItemCount(); ++i) {
            if (!this.type_piece.getItemAt(i).toString().contains(this.referenceComptable.getTypePiece().key)) continue;
            this.type_piece.setSelectedIndex(i);
        }
        this.num_piece.setText(this.referenceComptable.getNumPiece());
        this.num_ligne_piece.setText(this.referenceComptable.getNumLignePiece());
        this.code_produit.setText(this.referenceComptable.getCodeProduit());
        this.id_tiers.setText(this.referenceComptable.getIdTiers());
    }

    protected JRootPane createRootPane() {
        KeyStroke ksEsc = KeyStroke.getKeyStroke(27, 0);
        KeyStroke ksEnter = KeyStroke.getKeyStroke(10, 0);
        JRootPane rp = new JRootPane();
        this.escapeAction = new AbstractActionExt("Fermer"){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent evt) {
                DlgEditRefCompta.this.setVisible(false);
            }

            public void itemStateChanged(ItemEvent e) {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        };
        this.enterAction = new AbstractActionExt("Save"){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent evt) {
                DlgEditRefCompta.this.saveRefCompta();
            }

            public void itemStateChanged(ItemEvent e) {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        };
        rp.registerKeyboardAction(this.escapeAction, "TOTOTOTO", ksEsc, 2);
        rp.registerKeyboardAction(this.enterAction, "TOTOTOTO", ksEnter, 2);
        return rp;
    }
}

