/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.ui.xhtmlviewer;

import fr.gouv.finances.cp.xemelios.ui.MainWindow;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Point;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.xhtmlrenderer.css.style.CssContext;
import org.xhtmlrenderer.css.style.derived.RectPropertySet;
import org.xhtmlrenderer.event.DocumentListener;
import org.xhtmlrenderer.extend.UserAgentCallback;
import org.xhtmlrenderer.render.Box;
import org.xhtmlrenderer.swing.ScalableXHTMLPanel;

public class XemeliosXhtmlPanel
extends ScalableXHTMLPanel {
    private static final Logger logger = Logger.getLogger(XemeliosXhtmlPanel.class);
    private JInternalFrame iframe;
    private JFrame frame;

    public XemeliosXhtmlPanel(UserAgentCallback uac, JInternalFrame frame) {
        super(uac);
        this.iframe = frame;
        this.addDocumentListener();
        this.addMonospacedFont();
    }

    public XemeliosXhtmlPanel(UserAgentCallback uac, JFrame frame) {
        super(uac);
        this.frame = frame;
        this.addDocumentListener();
        this.addMonospacedFont();
    }

    protected void setDocumentRelative(String filename) {
        String url = this.getSharedContext().getUac().resolveURI(filename);
        if (url != null) {
            if (this.isAnchorInCurrentDocument(filename)) {
                String id = this.getAnchorId(filename);
                Box box = this.getSharedContext().getBoxById(id);
                if (box != null) {
                    Point pt;
                    if (box.getStyle().isInline()) {
                        pt = new Point(box.getAbsX(), box.getAbsY());
                    } else {
                        RectPropertySet margin = box.getMargin((CssContext)this.getLayoutContext());
                        pt = new Point(box.getAbsX() + (int)margin.left(), box.getAbsY() + (int)margin.top());
                    }
                    this.scrollTo(pt);
                    return;
                }
            }
            Document dom = this.loadDocument(url);
            this.setDocument(dom, url);
        }
    }

    private boolean isAnchorInCurrentDocument(String str) {
        return str.charAt(0) == '#';
    }

    private String getAnchorId(String url) {
        return url.substring(1, url.length());
    }

    private void addMonospacedFont() {
        try {
            if (MainWindow.instance != null && !MainWindow.instance.getEnvProperties().replace("${xemelios.resources.location}").equals("${xemelios.resources.location}")) {
                Font font = Font.createFont(0, new File(new File(MainWindow.instance.getEnvProperties().replace("${xemelios.resources.location}")), "couri.ttf"));
                this.getSharedContext().setFontMapping("monospace", font);
            }
        }
        catch (FontFormatException ex) {
            logger.error((Object)ex);
        }
        catch (IOException ex) {
            logger.error((Object)ex);
        }
        catch (NullPointerException npEx) {
            logger.error((Object)npEx);
        }
    }

    private void addDocumentListener() {
        this.addDocumentListener(new DocumentListener(){

            public void documentLoaded() {
                String sUrl = XemeliosXhtmlPanel.this.getSharedContext().getUac().getBaseURL();
                try {
                    URL __url = new URL(sUrl);
                    String url = __url.toExternalForm();
                    int sharpPos = url.indexOf(35);
                    if (sharpPos >= 0) {
                        String anchorName = url.substring(sharpPos + 1);
                        Box box = XemeliosXhtmlPanel.this.getSharedContext().getBoxById(anchorName);
                        if (box != null) {
                            Point pt;
                            if (box.getStyle().isInline()) {
                                pt = new Point(box.getAbsX(), box.getAbsY());
                            } else {
                                RectPropertySet margin = box.getMargin((CssContext)XemeliosXhtmlPanel.this.getLayoutContext());
                                pt = new Point(box.getAbsX() + (int)margin.left(), box.getAbsY() + (int)margin.top());
                            }
                            Point transPoint = new Point((int)(pt.getX() / XemeliosXhtmlPanel.this.getScale()), (int)(pt.getY() / XemeliosXhtmlPanel.this.getScale()));
                            XemeliosXhtmlPanel.this.scrollTo(transPoint);
                            XemeliosXhtmlPanel.this.repaint();
                            return;
                        }
                        logger.error((Object)("anchor not found: " + anchorName));
                    }
                    XemeliosXhtmlPanel.this.displayTitle(XemeliosXhtmlPanel.this.getDocumentTitle());
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }

            public void onLayoutException(Throwable throwable) {
            }

            public void onRenderException(Throwable throwable) {
            }

            public void documentStarted() {
            }
        });
    }

    public JInternalFrame getFrame() {
        return this.iframe;
    }

    protected void displayTitle(String title) {
        if (title != null) {
            if (this.frame != null) {
                this.frame.setTitle(title);
            }
            if (this.iframe != null) {
                this.iframe.setTitle(title);
            }
        }
    }

    public void setDocument(File file) throws Exception {
        this.setScalePolicy(1);
        super.setDocument(file);
    }

    public void setDocument(Document doc, String url) {
        this.setScalePolicy(1);
        super.setDocument(doc, url);
    }

    public void setDocument(InputStream stream, String url) throws Exception {
        this.setScalePolicy(1);
        super.setDocument(stream, url);
    }
}

