/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.ui.search;

import fr.gouv.finances.cp.utils.ui.DisplayExceptionDlg;
import fr.gouv.finances.cp.xemelios.ui.SearchWindow;
import fr.gouv.finances.cp.xemelios.ui.search.ResultDisplayerThread;
import fr.gouv.finances.dgfip.utils.Pair;
import fr.gouv.finances.dgfip.xemelios.auth.XemeliosUser;
import fr.gouv.finances.dgfip.xemelios.common.config.CritereModel;
import fr.gouv.finances.dgfip.xemelios.common.config.ElementModel;
import fr.gouv.finances.dgfip.xemelios.common.config.ListeResultatModel;
import fr.gouv.finances.dgfip.xemelios.data.DataLayerManager;
import fr.gouv.finances.dgfip.xemelios.data.DataResultSet;
import java.util.Vector;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.jdesktop.swingworker.SwingWorker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPathExecuter
extends SwingWorker<DataResultSet, String> {
    private static Logger logger = Logger.getLogger(XPathExecuter.class);
    private ListeResultatModel lrm;
    private long start;
    private String xPathQuery;
    private ElementModel elementModel;
    private Pair collectivite;
    private Pair budget;
    private Vector<CritereModel> models = null;
    private SearchWindow sw;
    private XemeliosUser user;
    private Throwable errorWhileSearching;

    public XPathExecuter(ElementModel elementModel, String xPathQuery, Vector<CritereModel> models, Pair collectivite, Pair budget, ListeResultatModel lrm, long start, SearchWindow sw) {
        this.xPathQuery = xPathQuery;
        this.models = models;
        this.lrm = lrm;
        this.start = start;
        this.elementModel = elementModel;
        this.collectivite = collectivite;
        this.budget = budget;
        this.sw = sw;
        this.user = sw.getUser();
    }

    public DataResultSet doInBackground() {
        try {
            logger.debug((Object)("XQuery=" + this.xPathQuery));
            DataResultSet rs = DataLayerManager.getImplementation().search(this.elementModel, this.collectivite, this.budget, this.xPathQuery, this.lrm, this.models, this.user);
            return rs;
        }
        catch (Throwable t) {
            logger.error((Object)"une erreur est survenue.", t);
            try {
                this.errorWhileSearching = t;
                return DataLayerManager.getImplementation().getEmptyDataResultSet();
            }
            catch (Throwable throwable) {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void done() {
        try {
            if (this.errorWhileSearching != null) {
                Runnable code = new Runnable(){

                    public void run() {
                        DisplayExceptionDlg.displayException(((XPathExecuter)XPathExecuter.this).sw.parentFrame, XPathExecuter.this.errorWhileSearching);
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    code.run();
                } else {
                    SwingUtilities.invokeLater(code);
                }
            } else {
                DataResultSet rs = (DataResultSet)this.get();
                ResultDisplayerThread code = new ResultDisplayerThread(rs, this.lrm, this.start, this.elementModel, this.sw);
                if (SwingUtilities.isEventDispatchThread()) {
                    code.run();
                } else {
                    try {
                        SwingUtilities.invokeAndWait(code);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            this.firePropertyChange("COMPLETED", Boolean.FALSE, Boolean.TRUE);
        }
        catch (Throwable t) {
            DisplayExceptionDlg.displayException(this.sw.parentFrame, t);
        }
        finally {
            this.sw.parentFrame.stopWaiter();
        }
    }
}

