/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.ui.resulttable;

import fr.gouv.finances.cp.utils.StartUrl;
import fr.gouv.finances.cp.utils.ui.DisplayExceptionDlg;
import fr.gouv.finances.cp.utils.ui.IhmFactory;
import fr.gouv.finances.cp.xemelios.ui.SearchWindow;
import fr.gouv.finances.cp.xemelios.ui.ia.JTRIS;
import fr.gouv.finances.cp.xemelios.ui.resulttable.EtatResultTableModel;
import fr.gouv.finances.cp.xemelios.widgets.AbstractWidget;
import fr.gouv.finances.dgfip.utils.Amount;
import fr.gouv.finances.dgfip.utils.Pair;
import fr.gouv.finances.dgfip.xemelios.auth.UnauthorizedException;
import fr.gouv.finances.dgfip.xemelios.auth.XemeliosUser;
import fr.gouv.finances.dgfip.xemelios.common.DematTransform;
import fr.gouv.finances.dgfip.xemelios.common.PJRef;
import fr.gouv.finances.dgfip.xemelios.common.ToolException;
import fr.gouv.finances.dgfip.xemelios.common.config.DocumentModel;
import fr.gouv.finances.dgfip.xemelios.common.config.ElementModel;
import fr.gouv.finances.dgfip.xemelios.common.config.HiddenModel;
import fr.gouv.finances.dgfip.xemelios.common.config.PJRefInfo;
import fr.gouv.finances.dgfip.xemelios.common.config.PjRefHandler;
import fr.gouv.finances.dgfip.xemelios.common.config.PluginModel;
import fr.gouv.finances.dgfip.xemelios.common.config.WidgetModel;
import fr.gouv.finances.dgfip.xemelios.data.DataAccessException;
import fr.gouv.finances.dgfip.xemelios.data.DataConfigurationException;
import fr.gouv.finances.dgfip.xemelios.data.DataHandler;
import fr.gouv.finances.dgfip.xemelios.data.DataImpl;
import fr.gouv.finances.dgfip.xemelios.data.DataLayerManager;
import fr.gouv.finances.dgfip.xemelios.utils.XmlUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ResultTable
extends JXTable {
    private static final long serialVersionUID = 3311785168156347546L;
    private static Icon iconPapier = IhmFactory.getIconFromResource("fr/gouv/finances/cp/xemelios/ui/resources/pj-paper.png");
    private static Icon iconDvd = IhmFactory.getIconFromResource("fr/gouv/finances/cp/xemelios/ui/resources/pj-dvd.png");
    private static Icon iconOnline = IhmFactory.getIconFromResource("fr/gouv/finances/cp/xemelios/ui/resources/pj-online.png");
    private static Icon iconAvailable = IhmFactory.getIconFromResource("fr/gouv/finances/cp/xemelios/ui/resources/pj-available.png");
    private static Icon iconUnavailable = IhmFactory.getIconFromResource("fr/gouv/finances/cp/xemelios/ui/resources/pj-unavailable.png");
    private static Logger logger = Logger.getLogger(ResultTable.class);
    private ElementModel em;
    private SearchWindow searchWindow;
    private DataImpl impl = null;
    protected XemeliosUser user;

    public ResultTable(TableModel model, final SearchWindow sw, final ElementModel em, final XemeliosUser user) {
        super(model);
        this.em = em;
        this.searchWindow = sw;
        this.user = user;
        AmountRenderer amrenderer = new AmountRenderer();
        this.setDefaultRenderer(Amount.class, amrenderer);
        DateRenderer drenderer = new DateRenderer();
        this.setDefaultRenderer(Date.class, drenderer);
        PjRenderer renderer = new PjRenderer();
        this.setDefaultRenderer(PjRefHandler.class, renderer);
        this.setDefaultEditor(PjRefHandler.class, new PjEditor(sw.getCurrentCollectivite(), sw.getCurrentBudget()));
        this.setAutoResizeMode(0);
        this.setColumnControlVisible(true);
        this.setRolloverEnabled(true);
        if (!"remove".equals(System.getProperty("xemelios.jxtable.highlighter"))) {
            Color selectedColor = new Color(184, 207, 229);
            ColorHighlighter whiteOne = new ColorHighlighter(HighlightPredicate.EVEN, Color.WHITE, Color.BLACK, selectedColor, Color.BLACK);
            ColorHighlighter greyOne = new ColorHighlighter(HighlightPredicate.ODD, new Color(240, 240, 224), Color.BLACK, new Color(191, 207, 229), Color.BLACK);
            this.setHighlighters(new Highlighter[]{whiteOne, greyOne});
        }
        InputMap im = this.getInputMap();
        KeyStroke ks = KeyStroke.getKeyStroke("control P");
        im.put(ks, "print");
        im.put(KeyStroke.getKeyStroke("control T"), "TT");
        ActionMap am = this.getActionMap();
        am.put("TT", new AbstractAction(){

            public void actionPerformed(ActionEvent evt) {
                JTRIS tetris = new JTRIS(sw.getParentFrame());
                ((Dialog)tetris).setVisible(true);
            }
        });
        PopupListener popupListener = new PopupListener();
        this.getTableHeader().addMouseListener(popupListener);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                block17: {
                    Point p = evt.getPoint();
                    int row = sw.getTable().rowAtPoint(p);
                    if (row >= 0 && evt.getClickCount() == 2 && evt.getButton() == 1) {
                        if (em.getXslt() == null || em.getXslt().length() == 0) {
                            return;
                        }
                        try {
                            Document repository;
                            row = ((JXTable)sw.getTable()).convertRowIndexToModel(row);
                            EtatResultTableModel etrm = (EtatResultTableModel)ResultTable.this.getModel();
                            DataHandler dh = etrm.getRowAt(row, 0);
                            Document doc = dh.getDocument();
                            XPath xp = XPathFactory.newInstance().newXPath();
                            Hashtable<String, Object> parameters = new Hashtable<String, Object>();
                            parameters.put("browser-destination", em.getParent().useExternalBrowser() ? "external" : "internal");
                            for (int pos = 0; pos < etrm.getHiddens().size(); ++pos) {
                                HiddenModel hm = etrm.getHiddens().get(pos);
                                if (!hm.getName().startsWith("xsl-param:")) continue;
                                String paramName = hm.getName().substring("xsl-param:".length());
                                Object paramValue = dh.getValueAtColumn(etrm.getListeChamps().size() + pos);
                                if (paramValue == null) continue;
                                parameters.put(paramName, paramValue);
                            }
                            xp.setNamespaceContext((NamespaceContext)em.getParent().getParent().getNamespaces());
                            String idRepository = null;
                            if (em.getParent().getParent().getReferenceNomenclaturePath() != null && em.getParent().getParent().getReferenceNomenclaturePath().getCodePath() != null) {
                                idRepository = (String)xp.evaluate(em.getParent().getParent().getReferenceNomenclaturePath().getCodePath().getPath(), doc.getDocumentElement(), XPathConstants.STRING);
                            }
                            if (idRepository != null && idRepository.length() <= 0) {
                                idRepository = null;
                            }
                            if ((repository = DataLayerManager.getImplementation().getRepositoryAsDom(em.getParent().getParent(), sw.getCurrentCollectivite(), idRepository, user)) != null) {
                                parameters.put("repository", repository);
                            }
                            parameters.put("config", ResultTable.this.searchWindow.getParentFrame().getDocModels().getSmallDOM());
                            parameters.put("collectivite", sw.getCurrentCollectivite().key);
                            parameters.put("budget", sw.getCurrentBudget().key);
                            parameters.put("collectivite-lib", sw.getCurrentCollectivite().libelle);
                            parameters.put("budget-lib", sw.getCurrentBudget().libelle);
                            File f = null;
                            f = new File(new File(new File(System.getProperty("user.home")), "xemelios/documents-def-ovrrd"), em.getXslt());
                            if (!f.exists()) {
                                f = new File(em.getParent().getParent().getBaseDirectory(), em.getXslt());
                            }
                            FileInputStream is = new FileInputStream(f);
                            InputStream htmlStream = DematTransform.transform((Node)doc, (InputStream)is, parameters, (String)f.getParentFile().toURI().toURL().toExternalForm());
                            sw.parentFrame.displayHtmlStream(htmlStream, em.getParent(), sw.getDesktopPane());
                        }
                        catch (Exception ex) {
                            Container comp2;
                            for (comp2 = sw.getTable(); comp2 != null && !(comp2 instanceof JFrame); comp2 = comp2.getParent()) {
                            }
                            if (comp2 != null) {
                                new DisplayExceptionDlg((Frame)((JFrame)comp2), (Throwable)ex);
                                break block17;
                            }
                            ex.printStackTrace();
                        }
                    } else if (evt.getButton() == 2 || evt.getButton() == 3) {
                        EtatResultTableModel etrm = (EtatResultTableModel)ResultTable.this.getModel();
                        JPopupMenu pm = new JPopupMenu();
                        for (WidgetModel wm : etrm.getListeResultat().getWidgets()) {
                            AbstractWidget aw = null;
                            try {
                                Class<?> clazz = Class.forName(wm.getClassName());
                                Constructor<?> cc = clazz.getConstructor(WidgetModel.class, ElementModel.class);
                                aw = (AbstractWidget)cc.newInstance(wm, em);
                            }
                            catch (Exception ex) {
                                new DisplayExceptionDlg((Frame)sw.getParentFrame(), (Throwable)ex);
                            }
                            if (aw == null) continue;
                            WidgetAction wa = new WidgetAction(aw, etrm, ((JXTable)sw.getTable()).convertRowIndexToModel(row));
                            pm.add(new JMenuItem(wa));
                        }
                        if (pm.getComponentCount() > 0) {
                            pm.show(evt.getComponent(), evt.getX(), evt.getY());
                        }
                    }
                }
            }
        });
        try {
            this.impl = DataLayerManager.getImplementation();
        }
        catch (Throwable t) {
            // empty catch block
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StringIterator<String>
    implements Iterator<String> {
        private String s;
        private boolean get = false;

        public StringIterator(String s) {
            this.s = s;
        }

        @Override
        public boolean hasNext() {
            return !this.get;
        }

        @Override
        public String next() {
            this.get = true;
            return this.s;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private static class LocalNSCtx
    implements NamespaceContext {
        private static String URI;

        public LocalNSCtx(String uri) {
            URI = uri;
        }

        public String getNamespaceURI(String prefix) {
            if ("".equals(prefix)) {
                return "";
            }
            if ("n".equals(prefix)) {
                return URI;
            }
            if ("xml".equals(prefix)) {
                return "http://www.w3.org/XML/1998/namespace";
            }
            if ("xmlns".equals(prefix)) {
                return "http://www.w3.org/2000/xmlns/";
            }
            return "";
        }

        public String getPrefix(String namespaceURI) {
            if (URI.equals(namespaceURI)) {
                return "n";
            }
            if ("http://www.w3.org/XML/1998/namespace".equals(namespaceURI)) {
                return "xml";
            }
            if ("http://www.w3.org/2000/xmlns/".equals(namespaceURI)) {
                return "xmlns";
            }
            return "";
        }

        public Iterator getPrefixes(String namespaceURI) {
            return new StringIterator<String>(this.getPrefix(namespaceURI));
        }
    }

    private class WidgetAction
    extends AbstractAction {
        private AbstractWidget aw;
        private EtatResultTableModel etrm;
        private int row;

        public WidgetAction(AbstractWidget aw, EtatResultTableModel etrm, int row) {
            super(aw.getWidgetModel().getLibelle());
            this.aw = aw;
            this.etrm = etrm;
            this.row = row;
        }

        public void actionPerformed(ActionEvent evt) {
            this.aw.run(this.etrm, this.row);
        }
    }

    private class PjDisplayAction
    implements ActionListener {
        private Pair collectivite;
        private Pair budget;
        private PJRefInfo pj;

        public PjDisplayAction(Pair collectivite, Pair budget, PJRefInfo pj) {
            this.collectivite = collectivite;
            this.budget = budget;
            this.pj = pj;
        }

        public void actionPerformed(ActionEvent evt) {
            try {
                DataImpl impl = DataLayerManager.getImplementation();
                PJRef pjRef = impl.getPj(this.collectivite, this.pj.getNom(), ResultTable.this.user);
                if (pjRef != null) {
                    File tmpDir = new File(System.getProperty("java.io.tmpdir"));
                    File tmpFile = File.createTempFile("tmp-", pjRef.getFileName(), tmpDir);
                    FileOutputStream fos = new FileOutputStream(tmpFile);
                    fos.write(pjRef.getData());
                    fos.flush();
                    fos.close();
                    StartUrl.startUrl(tmpFile.toURL().toString());
                } else {
                    JOptionPane.showMessageDialog(null, "Pi\u00e8ce non trouv\u00e9e.");
                }
            }
            catch (UnauthorizedException ex) {
                JOptionPane.showMessageDialog(ResultTable.this.getParent(), ex.getMessage(), "Droits insuffisants", 2);
            }
            catch (DataConfigurationException e) {
                e.printStackTrace();
            }
            catch (DataAccessException daEx) {
                daEx.printStackTrace();
            }
            catch (IOException ioEx) {
                ioEx.printStackTrace();
            }
            catch (ToolException tEx) {
                tEx.printStackTrace();
            }
        }
    }

    class PjEditor
    extends DefaultCellEditor {
        protected JButton button;
        private Object data;
        private boolean isPushed;
        private Pair collectivite;
        private Pair budget;
        private Point point;
        private JTable table;

        public PjEditor(Pair collectivite, Pair budget) {
            super(new JCheckBox());
            this.collectivite = collectivite;
            this.budget = budget;
            this.button = new JButton("...");
            this.button.setOpaque(true);
            this.button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PjEditor.this.fireEditingStopped();
                }
            });
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.button.setForeground(table.getSelectionForeground());
            this.button.setBackground(table.getSelectionBackground());
            this.data = value;
            Rectangle rect = table.getCellRect(row, column, false);
            this.point = rect.getLocation();
            this.table = table;
            this.isPushed = true;
            return this.button;
        }

        public Object getCellEditorValue() {
            if (this.isPushed) {
                JPopupMenu popup = new JPopupMenu("Pi\u00e8ces jointes");
                if (this.data instanceof PjRefHandler) {
                    PjRefHandler pjs = (PjRefHandler)this.data;
                    int count = 0;
                    for (PJRefInfo pj : pjs.getPjs()) {
                        ++count;
                        Icon icon = null;
                        boolean available = false;
                        if ("02".equals(pj.getSupport())) {
                            icon = iconPapier;
                        } else if ("00".equals(pj.getSupport())) {
                            icon = iconOnline;
                        } else if ("01".equals(pj.getSupport()) || "10".equals(pj.getSupport()) || "03".equals(pj.getSupport())) {
                            try {
                                available = ResultTable.this.impl.isPjAvailable(this.collectivite, pj.getNom(), ResultTable.this.user);
                            }
                            catch (Throwable t) {
                                // empty catch block
                            }
                            icon = available ? iconAvailable : iconUnavailable;
                        }
                        JMenuItem mnu = new JMenuItem(pj.getNom(), icon);
                        if (available) {
                            mnu.addActionListener(new PjDisplayAction(this.collectivite, this.budget, pj));
                        }
                        popup.add(mnu);
                    }
                } else {
                    logger.debug((Object)(this.data.getClass().getName() + " --> " + this.data.toString()));
                }
                popup.show(this.table, this.point.x, this.point.y);
            }
            this.isPushed = false;
            return "...";
        }

        public boolean stopCellEditing() {
            this.isPushed = false;
            return super.stopCellEditing();
        }

        protected void fireEditingStopped() {
            super.fireEditingStopped();
        }
    }

    class DateRenderer
    extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component parent = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            JLabel lbl = (JLabel)parent;
            if (value != null && value instanceof Date) {
                Date d = (Date)value;
                SimpleDateFormat sdf = new SimpleDateFormat(System.getProperty("xemelios.date.format", "yyyy-MM-dd"));
                lbl.setText(sdf.format(d));
                lbl.setHorizontalAlignment(2);
            }
            return parent;
        }
    }

    class AmountRenderer
    extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component parent = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            JLabel lbl = (JLabel)parent;
            if (value != null && value instanceof Amount) {
                Amount am = (Amount)value;
                lbl.setText(am.stringRepresentation());
                lbl.setHorizontalAlignment(4);
            }
            return parent;
        }
    }

    class PjRenderer
    extends JButton
    implements TableCellRenderer {
        public PjRenderer() {
            this.setOpaque(true);
            this.setText("...");
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setForeground(table.getSelectionForeground());
            this.setBackground(table.getSelectionBackground());
            if (value != null && value instanceof PjRefHandler) {
                PjRefHandler h = (PjRefHandler)value;
                this.setToolTipText(Integer.toString(h.getPjCount()) + " PJ");
            } else {
                this.setToolTipText(null);
            }
            return this;
        }
    }

    class PopupListener
    extends MouseAdapter
    implements ActionListener {
        Pair[] operators;
        HashMap<String, String> operatorList = new HashMap();
        int columnIndex = 0;

        PopupListener() {
        }

        public void mouseReleased(MouseEvent e) {
            if (!e.isConsumed()) {
                this.maybeShowPopup(e);
            }
        }

        public void mousePressed(MouseEvent e) {
            if (!e.isConsumed()) {
                this.maybeShowPopup(e);
            }
        }

        private void maybeShowPopup(MouseEvent e) {
            Point p = e.getPoint();
            if (e.isPopupTrigger()) {
                e.consume();
                EtatResultTableModel etrm = (EtatResultTableModel)ResultTable.this.searchWindow.getTable().getModel();
                this.columnIndex = ResultTable.this.convertColumnIndexToModel(ResultTable.this.columnAtPoint(p));
                boolean showPopup = etrm.isSumOperationPermittedOnColumn(this.columnIndex);
                PluginModel pm = ResultTable.this.searchWindow.getPluginModel();
                if (pm != null) {
                    showPopup = showPopup && pm.isSumPossible();
                }
                try {
                    if (showPopup) {
                        DataImpl impl = DataLayerManager.getImplementation();
                        this.operators = impl.getAggregateOperators(etrm.getColumnDatatype(this.columnIndex));
                        if (this.operators.length > 0) {
                            JPopupMenu popup = new JPopupMenu();
                            for (Pair ope : this.operators) {
                                JMenuItem menuItem = new JMenuItem(ope.libelle);
                                menuItem.addActionListener(this);
                                popup.add(menuItem);
                                this.operatorList.put(ope.libelle, ope.key);
                            }
                            popup.show(e.getComponent(), e.getX(), e.getY());
                        }
                    }
                }
                catch (DataConfigurationException dce) {
                    dce.printStackTrace();
                    logger.debug((Object)"DataLayer not implemented");
                }
            }
        }

        public void actionPerformed(ActionEvent ae) {
            JMenuItem item = (JMenuItem)ae.getSource();
            try {
                EtatResultTableModel etrm = (EtatResultTableModel)ResultTable.this.searchWindow.getTable().getModel();
                DocumentModel dm = ResultTable.this.em.getParent().getParent();
                String xpath = etrm.getColumnXPath(this.columnIndex);
                xpath = XmlUtils.normalizeNS((String)xpath, (NamespaceContext)dm.getNamespaces());
                logger.debug((Object)xpath);
                final String resultat = DataLayerManager.getImplementation().calculateAggregate(ResultTable.this.searchWindow.getDocumentModel(), ResultTable.this.em.getParent(), xpath, this.operatorList.get(item.getText()), etrm.getListeChamps().get(this.columnIndex), etrm.getResultSet(), ResultTable.this.user);
                final JDialog dialog = new JDialog();
                dialog.setTitle(ResultTable.this.searchWindow.getTitle());
                JLabel texte = new JLabel(item.getText() + " de " + etrm.getColumnHeader(this.columnIndex) + " : " + resultat);
                JButton boutonFermer = new JButton("Fermer");
                JButton boutonCopier = new JButton("Copier");
                boutonCopier.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        Clipboard system = Toolkit.getDefaultToolkit().getSystemClipboard();
                        StringSelection ss = new StringSelection(resultat);
                        system.setContents(ss, ss);
                    }
                });
                boutonFermer.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        dialog.setVisible(false);
                        dialog.dispose();
                    }
                });
                Box haut = Box.createVerticalBox();
                Box bas = Box.createHorizontalBox();
                bas.add(boutonFermer);
                bas.add(Box.createHorizontalStrut(20));
                bas.add(boutonCopier);
                texte.setAlignmentX(0.5f);
                bas.setAlignmentX(0.5f);
                haut.add(texte);
                haut.add(Box.createVerticalStrut(20));
                haut.add(bas);
                dialog.add(haut);
                dialog.pack();
                dialog.setLocation(600, 500);
                dialog.setVisible(true);
            }
            catch (UnauthorizedException ex) {
                JOptionPane.showMessageDialog(ResultTable.this.getParent(), ex.getMessage(), "Droits insuffisants", 2);
            }
            catch (DataConfigurationException dce) {
                dce.printStackTrace();
            }
            catch (DataAccessException dataAccessException) {
                // empty catch block
            }
        }
    }
}

