/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.ui;

import fr.gouv.finances.cp.xemelios.ui.MainWindow;
import fr.gouv.finances.cp.xemelios.ui.ia.core.DlgCore;
import fr.gouv.finances.dgfip.xemelios.common.config.EnvironmentDomain;
import fr.gouv.finances.dgfip.xemelios.common.config.VariableModel;
import fr.gouv.finances.dgfip.xemelios.data.DataConfigurationException;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.apache.log4j.Logger;
import org.jdesktop.layout.GroupLayout;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.treetable.AbstractTreeTableModel;
import org.jdesktop.swingx.treetable.TreeTableModel;

public class DlgEditEnvironment
extends JDialog {
    private static final String TITLE = "Environnement";
    private static Logger logger = Logger.getLogger(DlgEditEnvironment.class);
    private boolean ret = false;
    private EnvironmentDomain documents;
    private TreeTableModel myModel;
    private int domain;
    private Action action;
    private JScrollPane jScrollPane1;
    private JButton pbOk;
    private JXTreeTable treeTable;

    public DlgEditEnvironment(Frame parent, EnvironmentDomain documents, int domain) {
        super(parent, true);
        this.setTitle(TITLE);
        this.documents = documents;
        this.domain = domain;
        this.myModel = this.createModel();
        this.initComponents();
        this.setLocationRelativeTo(this.getParent());
        this.treeTable.setTreeTableModel(this.myModel);
        this.treeTable.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
            }

            public void treeExpanded(TreeExpansionEvent event) {
                DlgEditEnvironment.this.treeTable.packAll();
            }
        });
    }

    protected JRootPane createRootPane() {
        JRootPane rp = super.createRootPane();
        this.action = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                DlgCore dlg = new DlgCore(MainWindow.instance);
                dlg.setVisible(true);
                DlgEditEnvironment.this.setVisible(false);
            }
        };
        rp.getActionMap().put("SS", this.action);
        rp.getInputMap().put(KeyStroke.getKeyStroke("control shift S"), "SS");
        return rp;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.treeTable = new JXTreeTablePropertyEditor();
        this.pbOk = new JButton();
        this.setDefaultCloseOperation(2);
        this.treeTable.setAutoResizeMode(3);
        this.jScrollPane1.setViewportView((Component)this.treeTable);
        this.pbOk.setText("Fermer");
        this.pbOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DlgEditEnvironment.this.pbOkClick(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.jScrollPane1, -1, 356, Short.MAX_VALUE).add(2, (Component)this.pbOk)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -1, 419, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.pbOk).addContainerGap()));
        this.pack();
    }

    private void pbOkClick(ActionEvent evt) {
        if (this.treeTable.isEditing()) {
            this.treeTable.getCellEditor(this.treeTable.getEditingRow(), this.treeTable.getEditingColumn()).stopCellEditing();
        }
        this.ret = true;
        this.setVisible(false);
    }

    private TreeTableModel createModel() {
        return new EnvironmentTreeModel(this.documents, this.domain);
    }

    private static class JXTreeTablePropertyEditor
    extends JXTreeTable {
        private TableCellEditor booleanEditor = new DefaultCellEditor(new JCheckBox()){

            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                Component c = super.getTableCellEditorComponent(table, value, isSelected, row, column);
                JCheckBox chk = (JCheckBox)this.editorComponent;
                chk.setSelected((Boolean)value);
                chk.setBackground(c.getBackground());
                return chk;
            }
        };
        private TableCellEditor integerEditor = new DefaultCellEditor(new JTextField()){

            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                JTextField txt = (JTextField)this.editorComponent;
                txt.setHorizontalAlignment(4);
                txt.setText(value.toString());
                return txt;
            }
        };
        private TableCellRenderer booleanRenderer = new DefaultTableCellRenderer(){
            private JCheckBox chk = new JCheckBox();

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel lbl = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                this.chk.setSelected((Boolean)value);
                this.chk.setBackground(lbl.getBackground());
                this.chk.setBorder(lbl.getBorder());
                return this.chk;
            }
        };
        private TableCellRenderer integerRenderer = new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel txt = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                txt.setHorizontalAlignment(4);
                txt.setText(value.toString());
                return txt;
            }
        };

        public TableCellEditor getCellEditor(int row, int column) {
            if (column == 1 && this.getTreeTableModel() instanceof EnvironmentTreeModel) {
                EnvironmentTreeModel model = (EnvironmentTreeModel)this.getTreeTableModel();
                Object node = this.getPathForRow(row).getLastPathComponent();
                if (node instanceof VariableModel) {
                    VariableModel vm = (VariableModel)node;
                    String type = vm.getType();
                    if ("integer".equals(type)) {
                        return this.integerEditor;
                    }
                    if ("boolean".equals(type)) {
                        return this.booleanEditor;
                    }
                }
                return super.getCellEditor(row, column);
            }
            return super.getCellEditor(row, column);
        }

        public TableCellRenderer getCellRenderer(int row, int column) {
            if (column == 1 && this.getTreeTableModel() instanceof EnvironmentTreeModel) {
                EnvironmentTreeModel model = (EnvironmentTreeModel)this.getTreeTableModel();
                Object node = this.getPathForRow(row).getLastPathComponent();
                if (node instanceof VariableModel) {
                    VariableModel vm = (VariableModel)node;
                    String type = vm.getType();
                    if ("integer".equals(type)) {
                        return this.integerRenderer;
                    }
                    if ("boolean".equals(type)) {
                        return this.booleanRenderer;
                    }
                }
                return super.getCellRenderer(row, column);
            }
            return super.getCellRenderer(row, column);
        }
    }

    private static class EnvironmentTreeModel
    extends AbstractTreeTableModel {
        private EnvironmentDomain env;
        private int domain;

        public EnvironmentTreeModel(EnvironmentDomain env, int domain) {
            this.env = env;
            this.domain = domain;
        }

        public boolean isLeaf(Object node) {
            if (node instanceof EnvironmentDomain) {
                EnvironmentDomain ed = (EnvironmentDomain)node;
                return !ed.hasEnvironment(this.domain) && ed.getChildCount(this.domain) <= 0;
            }
            return true;
        }

        public int getChildCount(Object parent) {
            if (parent instanceof EnvironmentDomain) {
                EnvironmentDomain ed = (EnvironmentDomain)parent;
                int ret = 0;
                if (ed.hasEnvironment(this.domain)) {
                    Enumeration enumer = ed.getVariables(this.domain);
                    while (enumer.hasMoreElements()) {
                        ++ret;
                        enumer.nextElement();
                    }
                }
                return ed.getChildCount(this.domain) + ret;
            }
            return 0;
        }

        public String getColumnName(int i) {
            switch (i) {
                case 0: {
                    return "Propri\u00e9t\u00e9";
                }
                case 1: {
                    return "Valeur";
                }
            }
            return "";
        }

        public Class getColumnClass(int i) {
            if (i == 1) {
                return String.class;
            }
            return super.getColumnClass(i);
        }

        public Object getValueAt(Object object, int i) {
            if (i == 0) {
                return object.toString();
            }
            if (object instanceof VariableModel) {
                VariableModel vm = (VariableModel)object;
                try {
                    if (vm.getReference() != null) {
                        return vm.getReference().getValue(this.env);
                    }
                    return "<unset>";
                }
                catch (DataConfigurationException dcEx) {
                    logger.error((Object)dcEx);
                    return dcEx.getMessage();
                }
            }
            return "";
        }

        public void setValueAt(Object value, Object node, int column) {
            VariableModel vm;
            if (node instanceof VariableModel && (vm = (VariableModel)node).getReference() != null) {
                try {
                    vm.getReference().setValue(this.env, value);
                }
                catch (DataConfigurationException dcEx) {
                    logger.error((Object)dcEx);
                }
            }
        }

        public Object getChild(Object parent, int index) {
            if (parent instanceof EnvironmentDomain) {
                EnvironmentDomain ed = (EnvironmentDomain)parent;
                int childCount = ed.getChildCount(this.domain);
                if (index < childCount) {
                    return ed.getChildAt(this.domain, index);
                }
                int i2 = index - childCount;
                Enumeration enumer = ed.getVariables(this.domain);
                for (int count = 0; count < i2 && enumer.hasMoreElements(); ++count) {
                    enumer.nextElement();
                }
                return enumer.nextElement();
            }
            return null;
        }

        public boolean isCellEditable(Object object, int i) {
            return i == 1 && object instanceof VariableModel;
        }

        public int getIndexOfChild(Object parent, Object child) {
            return 0;
        }

        public Object getRoot() {
            return this.env;
        }

        public int getColumnCount() {
            return 2;
        }
    }
}

