/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.patches;

import fr.gouv.finances.cp.utils.xml.marshal.XmlOutputter;
import fr.gouv.finances.cp.xemelios.patches.Core4_0_0_21;
import fr.gouv.finances.cp.xemelios.ui.MainWindow;
import fr.gouv.finances.cp.xemelios.updater.AbstractConfigurator;
import fr.gouv.finances.dgfip.xemelios.common.config.ConfigModelPatcher;
import fr.gouv.finances.dgfip.xemelios.common.config.PersonnalConfigParser;
import fr.gouv.finances.dgfip.xemelios.common.config.PersonnalConfigurationModel;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class Core_4_0_0_42
extends AbstractConfigurator {
    private static final Logger logger = Logger.getLogger(Core_4_0_0_42.class);

    public void run() throws Exception {
        File[] sharedFiles;
        File f = new File(System.getProperty("user.home"));
        File fProp = new File(f, "xemelios-config.xml");
        ArrayList<File> filesToPatch = new ArrayList<File>();
        if (fProp.exists()) {
            filesToPatch.add(fProp);
        }
        for (File share : sharedFiles = f.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.startsWith("xemelios-config.xml".substring(0, "xemelios-config.xml".indexOf(46)) + "-");
            }
        })) {
            filesToPatch.add(share);
        }
        for (File ftp : filesToPatch) {
            this.patchFile(ftp);
        }
        if (MainWindow.instance != null) {
            MainWindow.instance.reloadPersonnalConfig();
        }
        this.setPreviousConfigurator(new Core4_0_0_21());
    }

    private void patchFile(File f) {
        try {
            PersonnalConfigParser parser = new PersonnalConfigParser();
            parser.parse(f);
            PersonnalConfigurationModel sharedConfig = (PersonnalConfigurationModel)parser.getMarshallable();
            ConfigModelPatcher.patchSharedConfig((PersonnalConfigurationModel)sharedConfig);
            Charset cs = Charset.forName("ISO-8859-1");
            FileOutputStream fos = new FileOutputStream(f);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, cs);
            XmlOutputter output = new XmlOutputter(osw, cs.name());
            sharedConfig.marshall(output);
            osw.flush();
            osw.close();
        }
        catch (Exception ex) {
            logger.error((Object)("patching " + f.getAbsolutePath()), (Throwable)ex);
        }
    }
}

