/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.patches;

import fr.gouv.finances.cp.xemelios.patches.Core4_0_0_17;
import fr.gouv.finances.cp.xemelios.updater.AbstractConfigurator;
import java.io.File;
import java.io.FileOutputStream;
import org.apache.log4j.Logger;

public class Core4_0_0_21
extends AbstractConfigurator {
    private static final Logger logger = Logger.getLogger(Core4_0_0_21.class);

    public void run() throws Exception {
        block12: {
            logger.info((Object)("executing " + this.getClass().getName()));
            try {
                if (System.getProperty("os.name").toLowerCase().contains("windows")) {
                    logger.info((Object)"os.name contains windows");
                    String allUserHome = System.getenv("ALLUSERSPROFILE");
                    logger.info((Object)("ALLUSERPROFILE=" + allUserHome));
                    File home = new File(allUserHome);
                    if (home.exists()) {
                        logger.info((Object)(allUserHome + " exists"));
                        File startMenu = new File(home, "Menu D\u00e9marrer");
                        if (!(startMenu.exists() && startMenu.isDirectory() || (startMenu = new File(home, "Start Menu")).exists() && startMenu.isDirectory())) {
                            startMenu = null;
                        }
                        if (startMenu != null) {
                            logger.info((Object)("startMenu exists and is " + startMenu.getAbsolutePath()));
                            File programs = new File(startMenu, "Programmes");
                            if (!(programs.exists() && programs.isDirectory() || (programs = new File(startMenu, "Programs")).exists() && programs.isDirectory())) {
                                programs = null;
                            }
                            if (programs != null) {
                                logger.info((Object)("programs exists and is " + programs.getAbsolutePath()));
                                File xemelios = new File(programs, "Xemelios");
                                if (xemelios.exists() && xemelios.isDirectory()) {
                                    logger.info((Object)("xemelios exists and is a Directory : " + xemelios.getAbsolutePath()));
                                    try {
                                        File xemeliosReader = new File(xemelios, "Xemelios Reader.lnk");
                                        if (!xemeliosReader.exists()) {
                                            logger.info((Object)("creating shortcut at " + xemeliosReader.getAbsolutePath()));
                                            this.createShortcut(xemeliosReader);
                                            break block12;
                                        }
                                        logger.info((Object)(xemeliosReader.getAbsolutePath() + " exists"));
                                    }
                                    catch (Throwable t) {
                                        logger.error((Object)"while newFile(xemelios,\"Xemelios Reader.lnk\")", t);
                                    }
                                    break block12;
                                }
                                logger.warn((Object)("xemelios program folder does not exists at " + xemelios.getAbsolutePath()));
                                break block12;
                            }
                            logger.warn((Object)("programs dir not found in " + startMenu.getAbsolutePath() + "\n\tlooking for \"Programmes\", \"Programs\""));
                            break block12;
                        }
                        logger.warn((Object)("start menu not found in " + allUserHome + "\n\tlooking for \"Menu D\u00e9marrer\", \"Start Menu\""));
                        break block12;
                    }
                    logger.warn((Object)(allUserHome + " does not exists"));
                    break block12;
                }
                logger.warn((Object)("ce n'est pas un windows: " + System.getProperty("os.name")));
            }
            catch (Exception ex) {
                logger.error((Object)"while patching", (Throwable)ex);
            }
        }
        this.setPreviousConfigurator(new Core4_0_0_17());
    }

    private void createShortcut(File target) {
        logger.info((Object)("createShortcut(" + target.getAbsolutePath() + ")"));
        String CRLF = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        sb.append("Set oWS = WScript.CreateObject(\"WScript.Shell\")").append(CRLF);
        sb.append("sLinkFile = \"").append(target.getAbsolutePath()).append("\"").append(CRLF);
        sb.append("Set oLink = oWS.CreateShortcut(sLinkFile)").append(CRLF);
        File root = new File(new File(this.props.replace("${xemelios.prg}")), "root");
        File xemeliosReader = new File(root, "viewdoc.cmd");
        sb.append("oLink.TargetPath = \"").append(xemeliosReader.getAbsolutePath()).append("\"").append(CRLF);
        sb.append("oLink.Description = \"Xemelios Reader\"").append(CRLF);
        File icon = new File(root, "xemelios.ico");
        sb.append("oLink.IconLocation = \"").append(icon.getAbsolutePath()).append("\"").append(CRLF);
        sb.append("oLink.WindowStyle = \"7\"").append(CRLF);
        sb.append("oLink.WorkingDirectory = \"").append(root.getAbsolutePath()).append("\"").append(CRLF);
        sb.append("oLink.Save").append(CRLF);
        File script = new File(root, "xemelios-reader.vbs");
        try {
            FileOutputStream fos = new FileOutputStream(script);
            fos.write(sb.toString().getBytes());
            fos.flush();
            fos.close();
        }
        catch (Exception ex) {
            logger.error((Object)"while writting script", (Throwable)ex);
        }
        logger.info((Object)(script.getAbsolutePath() + " written\n" + sb.toString()));
        String[] cmd = new String[]{"CSCRIPT", script.getAbsolutePath()};
        logger.info((Object)"running script");
        try {
            Process p = Runtime.getRuntime().exec(cmd);
            p.waitFor();
            int ret = p.exitValue();
            script.delete();
            logger.info((Object)("script -> " + ret));
        }
        catch (Exception ex) {
            logger.error((Object)"while running script", (Throwable)ex);
            logger.error((Object)(script.getAbsolutePath() + " is still available"));
        }
    }
}

