/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.controls.tech;

import fr.gouv.finances.cp.xemelios.controls.Anomalie;
import fr.gouv.finances.cp.xemelios.controls.IdGenerator;
import fr.gouv.finances.cp.xemelios.controls.Node;
import fr.gouv.finances.cp.xemelios.controls.models.DocumentControlModel;
import fr.gouv.finances.dgfip.xemelios.common.config.DocumentModel;
import fr.gouv.finances.dgfip.xemelios.common.config.TextModel;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TECH03
extends DefaultHandler {
    private static final Logger logger = Logger.getLogger(TECH03.class);
    public static final transient String CTRL_ID = "TECH03";
    private Vector<Anomalie> anos = new Vector();
    private Vector<String> regsExp = new Vector();
    private DocumentModel docModel;
    private DocumentControlModel docControlModel;
    private String domainesControles;
    private String localNameTreated = "";
    public int MAX_ANOS = 300;

    @Override
    public void startDocument() throws SAXException {
        logger.info((Object)"In TECH03");
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.localNameTreated = qName;
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        this.createAnomalie(e);
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        this.createAnomalie(e);
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        this.createAnomalie(e);
    }

    private void createAnomalie(SAXParseException e) {
        if (this.isValidError(e) && this.isAnomalieToReturn(e)) {
            Anomalie ano = new Anomalie(IdGenerator.nextId(), CTRL_ID, "Contr\u00f4le de la conformance au sch\u00e9ma de : " + this.docModel.getTitre() + ".", CTRL_ID, this.domainesControles, "", "", "", "", "&lt;b&gt;Line n\u00b0" + e.getLineNumber() + " : &lt;/b&gt;" + e.getMessage().substring(e.getMessage().indexOf(":") + 2, e.getMessage().length()).replaceAll("<", "").replaceAll(">", "").replaceAll("/", ""), "Le fichier doit \u00eatre conforme au sch\u00e9ma : " + this.docModel.getTitre() + ".", "BLOQUANT", "xpath namespacise", new Hashtable<String, Object>());
            ano.addNode(new Node(null));
            if (this.anos.size() <= this.MAX_ANOS) {
                this.anos.add(ano);
            }
        }
    }

    public Vector<Anomalie> getAnomalies() {
        return this.anos;
    }

    public void setDocumentModel(DocumentModel dm) {
        this.docModel = dm;
    }

    public void setDocumentControlModel(DocumentControlModel dcm) {
        this.docControlModel = dcm;
    }

    public void setDomainesControles(String dc) {
        this.domainesControles = dc;
    }

    public boolean isValidError(SAXParseException ex) {
        return !ex.getMessage().contains("processing instruction");
    }

    private boolean isAnomalieToReturn(SAXParseException ex) {
        boolean ret = true;
        if (this.docControlModel.getControlTechById(CTRL_ID).getIgnoreRegexp().size() > 0) {
            for (TextModel textModel : this.docControlModel.getControlTechById(CTRL_ID).getIgnoreRegexp()) {
                if (!ex.getMessage().matches(textModel.getData())) continue;
                ret = false;
                break;
            }
        }
        return ret;
    }
}

