/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.controls.editors;

import fr.gouv.finances.cp.xemelios.controls.AbstractControlContentHandler;
import fr.gouv.finances.cp.xemelios.controls.ControlProgressListener;
import fr.gouv.finances.cp.xemelios.controls.MainControl;
import fr.gouv.finances.cp.xemelios.controls.models.DocumentControlModel;
import fr.gouv.finances.cp.xemelios.controls.models.ParamModel;
import fr.gouv.finances.cp.xemelios.ui.MainWindow;
import fr.gouv.finances.dgfip.utils.Pair;
import fr.gouv.finances.dgfip.xemelios.auth.UnauthorizedException;
import fr.gouv.finances.dgfip.xemelios.auth.XemeliosUser;
import fr.gouv.finances.dgfip.xemelios.common.ToolException;
import fr.gouv.finances.dgfip.xemelios.common.config.DocumentModel;
import fr.gouv.finances.dgfip.xemelios.common.config.DocumentsModel;
import fr.gouv.finances.dgfip.xemelios.common.config.Loader;
import java.io.File;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.TransformerFactoryImpl;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Controller
implements ControlProgressListener {
    MainControl mc;
    DocumentsModel config = Loader.getDocumentsInfos((String)System.getProperty("xemelios.documents.def.dir"));
    DocumentModel pesConfig;
    DocumentModel rapportConfig;

    public Controller(String typeDoc) throws Exception {
        this.pesConfig = this.config.getDocumentById(typeDoc);
        this.rapportConfig = this.config.getDocumentById("DocumentRapport");
        this.mc = new MainControl(this.pesConfig, this.config){

            @Override
            public AbstractControlContentHandler getControlContentHandler(DocumentModel dm, DocumentControlModel docCtrlMod, Hashtable<String, Object> parameters, MainWindow frame, String file, ControlProgressListener cpl) {
                AbstractControlContentHandler cch = new AbstractControlContentHandler(dm, docCtrlMod, parameters, null, file, cpl){

                    public Pair getCollectivite(DocumentModel dm, String fileName) throws ToolException {
                        return new Pair("xxxxxxxxxxx", "Collectivit\u00e9 d'analyse");
                    }

                    public Pair getBudget(DocumentModel dm, Pair collectivite, String fileName) throws ToolException, UnauthorizedException {
                        return new Pair("00", "Budget principal");
                    }
                };
                return cch;
            }
        };
    }

    public boolean checkParameters(Hashtable<String, Object> hashParams) {
        boolean ret = true;
        DocumentControlModel dcm = this.mc.getDocumentControl();
        for (ParamModel param : dcm.getParams()) {
            Object val = hashParams.get(param.getId());
            if (val != null) continue;
            System.err.println("ERROR: Mandatory parameter " + param.getId() + " Not found ");
            ret = false;
        }
        return ret;
    }

    public void listMandatoryParameters() {
        DocumentControlModel dcm = this.mc.getDocumentControl();
        System.err.println("Mandatory parameters are:");
        for (ParamModel param : dcm.getParams()) {
            System.err.println(param.getId() + "( " + param.getDatatype() + ")");
        }
    }

    public String getParameterDataType(String paramId) {
        DocumentControlModel dcm = this.mc.getDocumentControl();
        ParamModel param = dcm.getParamById(paramId);
        if (param != null) {
            return param.getDatatype();
        }
        return null;
    }

    public Hashtable<String, Document> controle(File fileToRead, Hashtable<String, Object> parameters) throws Exception {
        Hashtable<String, Document> domDocuments = new Hashtable<String, Document>();
        if (!this.checkParameters(parameters)) {
            this.listMandatoryParameters();
            return domDocuments;
        }
        File rapport = File.createTempFile("rapport", "xml");
        File tmpEnrichi = File.createTempFile("pesv2-enrichi", "xml");
        this.mc.setControlProgressListener(this);
        this.mc.setParameters(parameters);
        this.mc.setFileToControl(fileToRead);
        this.mc.setFichierEnrichiLocation(tmpEnrichi.getAbsolutePath());
        this.mc.setRapportLocation(rapport.getAbsolutePath());
        this.mc.run();
        if (this.mc.getControlStatus() != -1) {
            DOMResult result;
            Transformer tr;
            TransformerFactory tFactory;
            if (this.mc.getControlStatus() > 3) {
                tFactory = TransformerFactoryImpl.newInstance();
                tr = tFactory.newTransformer(new StreamSource(new File(this.pesConfig.getBaseDirectory(), this.pesConfig.getGlobalImportXsltFile())));
                result = new DOMResult();
                tr.transform(new StreamSource(tmpEnrichi), result);
                tmpEnrichi.delete();
                domDocuments.put("DocumentEnrichi", (Document)result.getNode());
            }
            if (this.rapportConfig.getGlobalImportXsltFile() != null && this.rapportConfig.getGlobalImportXsltFile().length() > 0) {
                tFactory = TransformerFactoryImpl.newInstance();
                tr = tFactory.newTransformer(new StreamSource(new File(this.rapportConfig.getBaseDirectory(), this.rapportConfig.getGlobalImportXsltFile())));
                result = new DOMResult();
                tr.transform(new StreamSource(rapport), result);
                domDocuments.put("Rapport", (Document)result.getNode());
            } else {
                DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
                Document drapport = dFactory.newDocumentBuilder().parse(rapport);
                domDocuments.put("Rapport", drapport);
                rapport.delete();
            }
        }
        return domDocuments;
    }

    @Override
    public void notifyImportFinished(MainControl.Triplet triplet) {
    }

    @Override
    public void notifyImportInterrupted(boolean hide) {
    }

    @Override
    public void stopWaiting() {
    }

    @Override
    public void notifyTechniqueValidationFailed() {
    }

    public static class LocalUser
    implements XemeliosUser {
        public String getId() {
            return "local";
        }

        public String getDisplayName() {
            return this.getId();
        }

        public boolean hasRole(String arg0) {
            return true;
        }

        public boolean hasDocument(String arg0) {
            return true;
        }

        public boolean hasCollectivite(String arg0, DocumentModel dm) {
            return true;
        }
    }
}

