/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.controls.editors;

import fr.gouv.finances.cp.xemelios.controls.editors.Controller;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.math.BigDecimal;
import java.util.Hashtable;
import java.util.Properties;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.TransformerFactoryImpl;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLineController {
    static Controller controller;

    protected static Object controlParameterFromString(String paramId, String paramValue) {
        String dataType = controller.getParameterDataType(paramId);
        if (dataType == null) {
            System.err.println("Unknown parameter :" + paramId);
            return null;
        }
        if ("string".equals(dataType)) {
            if (paramValue.matches("\\{.*\\}")) {
                int i1 = paramValue.indexOf("{");
                int i2 = paramValue.lastIndexOf("}");
                paramValue = paramValue.substring(i1 + 1, i2);
                System.err.println("Splitting :" + paramValue);
                return paramValue.split(" *, *");
            }
            return paramValue;
        }
        if ("boolean".equals(dataType)) {
            return new Boolean(paramValue);
        }
        if ("decimal".equals(dataType)) {
            return new BigDecimal(Long.parseLong(paramValue));
        }
        if ("integer".equals(dataType)) {
            return new Integer(Integer.parseInt(paramValue));
        }
        System.err.println("Unknown data type :" + dataType);
        return null;
    }

    protected static Hashtable<String, Object> getControlParameters(String propertiesFile) throws Exception {
        Properties properties = new Properties();
        properties.load(new FileInputStream(propertiesFile));
        Hashtable<String, Object> ret = new Hashtable<String, Object>();
        for (Object obk : properties.keySet()) {
            String sk = obk.toString();
            ret.put(sk, CommandLineController.controlParameterFromString(sk, properties.getProperty(sk)));
        }
        return ret;
    }

    public static void main(String[] args) {
        try {
            if (args.length < 4) {
                System.err.println("Usage : CommandLineController DocType FileToParse GenerationDirectory PropertiesFile");
                System.exit(1);
            }
            String typeDoc = args[0];
            String fileToReadPath = args[1];
            String dirToGeneratePath = args[2];
            String propertiesFilePath = args[3];
            File fileToRead = new File(fileToReadPath);
            controller = new Controller(typeDoc);
            Hashtable<String, Document> result = controller.controle(fileToRead, CommandLineController.getControlParameters(propertiesFilePath));
            File dirToGenerate = new File(dirToGeneratePath);
            if (dirToGenerate.exists()) {
                if (!dirToGenerate.isDirectory()) {
                    throw new Exception(dirToGeneratePath + " exists and is not a directory");
                }
            } else {
                dirToGenerate.mkdirs();
            }
            for (String k : result.keySet()) {
                Document doc = result.get(k);
                try {
                    File fn = new File(dirToGenerate, k + ".xml");
                    FileOutputStream f = new FileOutputStream(fn);
                    TransformerFactory tf = TransformerFactoryImpl.newInstance();
                    Transformer t = tf.newTransformer();
                    t.setOutputProperty("encoding", "ISO-8859-1");
                    t.setOutputProperty("method", "xml");
                    t.setOutputProperty("indent", "yes");
                    t.transform(new DOMSource(doc), new StreamResult(f));
                    f.flush();
                    f.close();
                    System.out.println("Generated " + fn.getAbsolutePath() + ".");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                catch (Error e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

