/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.controls;

import fr.gouv.finances.cp.utils.xml.marshal.XmlOutputter;
import fr.gouv.finances.cp.xemelios.controls.AbstractControlContentHandler;
import fr.gouv.finances.cp.xemelios.controls.Anomalie;
import fr.gouv.finances.cp.xemelios.controls.ControlParser;
import fr.gouv.finances.cp.xemelios.controls.ControlProgressListener;
import fr.gouv.finances.cp.xemelios.controls.DefaultControlContentHandler;
import fr.gouv.finances.cp.xemelios.controls.IdGenerator;
import fr.gouv.finances.cp.xemelios.controls.RapportWriter;
import fr.gouv.finances.cp.xemelios.controls.SaxXmlWriter;
import fr.gouv.finances.cp.xemelios.controls.models.ControlsModel;
import fr.gouv.finances.cp.xemelios.controls.models.DocumentControlModel;
import fr.gouv.finances.cp.xemelios.controls.models.ParamModel;
import fr.gouv.finances.cp.xemelios.controls.models.ParamModelTech;
import fr.gouv.finances.cp.xemelios.controls.tech.TECH01;
import fr.gouv.finances.cp.xemelios.controls.tech.TECH02;
import fr.gouv.finances.cp.xemelios.controls.tech.TECH03;
import fr.gouv.finances.cp.xemelios.ui.MainWindow;
import fr.gouv.finances.dgfip.utils.HostUtils;
import fr.gouv.finances.dgfip.utils.Pair;
import fr.gouv.finances.dgfip.xemelios.common.config.DocumentModel;
import fr.gouv.finances.dgfip.xemelios.common.config.DocumentsModel;
import fr.gouv.finances.dgfip.xemelios.txt2xml.Txt2Xml;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import net.sf.saxon.TransformerFactoryImpl;
import org.apache.log4j.Logger;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainControl
implements Runnable {
    public static final int STATUS_NOT_CONTROLLED = -1;
    public static final int STATUS_NOT_XML = 1;
    public static final int STATUS_INVALID_ENCODING = 2;
    public static final int STATUS_NOT_SCHEMA_VALID = 3;
    public static final int STATUS_HAS_UNIT_CONTROL_ERRORS = 4;
    public static final int STATUS_CONTROL_NO_ERROR = 5;
    private static final Logger logger = Logger.getLogger(MainControl.class);
    private File fichierAController;
    private File rapport;
    private File inputXmlFile;
    private DocumentModel documentModel;
    private Hashtable<String, Object> hashParams = new Hashtable();
    private DocumentControlModel dcm;
    private Date datecontrole;
    private NamespaceContext nameSpaces;
    private SaxXmlWriter saxWriter = null;
    public static final String ID_DOCUMENT_RAPPORT = "DocumentRapport";
    private ControlsModel cm;
    private String IDrapport = "";
    private String domainesControles = "";
    private RapportWriter rapportWriter;
    private boolean hasTech01Error = false;
    private AbstractControlContentHandler cch = null;
    private File fichierEnrichi = null;
    private String fichierEnrichiLocation = null;
    private String rapportLocation = null;
    private ControlProgressListener cpl = null;
    private int status = -1;
    private ArrayList<Anomalie> anomaliesTechniques;
    private SAXParserFactory factorySAX = null;

    public MainControl(DocumentModel dm, DocumentsModel docsMod) {
        this.documentModel = dm;
        this.cm = this.getControlsModel();
        this.dcm = this.cm.getDocumentById(dm.getId());
        this.nameSpaces = this.documentModel.getNamespaces();
        this.factorySAX = SAXParserFactory.newInstance();
        this.factorySAX.setNamespaceAware(true);
        this.anomaliesTechniques = new ArrayList();
        this.saxWriter = new SaxXmlWriter();
    }

    public DocumentControlModel getDocumentControl() {
        return this.dcm;
    }

    protected boolean controlXmlSyntax(File inputFile, TECH01 tech01) {
        FileInputStream fisTech = null;
        try {
            fisTech = new FileInputStream(inputFile);
            SAXParser parserXmlTech = this.factorySAX.newSAXParser();
            tech01.setDocModel(this.documentModel);
            parserXmlTech.parse((InputStream)fisTech, (DefaultHandler)tech01);
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.domainesControles = tech01.getDomaines();
        this.anomaliesTechniques.addAll(tech01.getAnomalies());
        if (this.anomaliesTechniques.size() > 0) {
            this.status = 1;
            return false;
        }
        return true;
    }

    @Override
    public void run() {
        Pair pBudg;
        Pair pColl;
        if (this.getDocumentModel().getTextToXmlTransformer() != null) {
            try {
                Class<?> clazz = Class.forName(this.getDocumentModel().getTextToXmlTransformer());
                Txt2Xml transformer = (Txt2Xml)clazz.newInstance();
                if (transformer != null) {
                    this.inputXmlFile = transformer.transform(this.fichierAController);
                }
            }
            catch (Exception ex) {
                logger.error((Object)"while instancying textToXmlTransformer", (Throwable)ex);
            }
        }
        if (this.inputXmlFile == null) {
            this.inputXmlFile = this.fichierAController;
        }
        boolean technicalValidationFailed = false;
        TECH01 tech01 = new TECH01();
        TECH02 tech02 = new TECH02();
        TECH03 tech03 = new TECH03();
        tech03.setDocumentModel(this.documentModel);
        tech03.setDocumentControlModel(this.dcm);
        File tmpDir = new File(System.getProperty("java.io.tmpdir"), "XEMELIOS");
        if (!tmpDir.exists()) {
            tmpDir.mkdirs();
        }
        if (this.rapportLocation == null) {
            this.rapportLocation = new File(tmpDir, "rapport" + this.inputXmlFile.getName()).getAbsolutePath();
        }
        this.rapport = new File(this.rapportLocation);
        logger.debug((Object)("rapport: " + this.rapport.getAbsolutePath()));
        this.datecontrole = new Date();
        Charset cs = Charset.forName("ISO-8859-1");
        OutputStreamWriter fos = null;
        try {
            fos = new OutputStreamWriter((OutputStream)new FileOutputStream(this.rapport), cs);
        }
        catch (Exception e1) {
            logger.error((Object)"while creating fos", (Throwable)e1);
        }
        this.rapportWriter = new RapportWriter(new XmlOutputter(fos, cs.name()));
        this.cch = this.getControlContentHandler(this.documentModel, this.dcm, this.hashParams, MainWindow.instance, this.inputXmlFile.getName(), this.cpl);
        boolean bl = this.hasTech01Error = !this.controlXmlSyntax(this.inputXmlFile, tech01);
        if (!this.hasTech01Error) {
            boolean isEncodingValid;
            boolean shouldContinue = true;
            if (this.dcm.getControlTechById("TECH02") != null && !(isEncodingValid = tech02.encodingValid(this.dcm.getControlTechById("TECH02"), this.inputXmlFile))) {
                Anomalie ano = new Anomalie(IdGenerator.nextId(), "TECH02", "Contr\u00f4le de l'encoding du fichier.", this.documentModel.getId(), "", "", "", "", "", "Le fichier est encod\u00e9 en " + tech02.getInputEncoding() + " alors qu'il devrait \u00eatre encod\u00e9 en " + tech02.getValidEncodings() + ".", "Le fichier doit \u00eatre encod\u00e9 en " + tech02.getValidEncodings() + ".", "BLOQUANT", "xpath namespacise", new Hashtable<String, Object>());
                this.anomaliesTechniques.add(ano);
                shouldContinue = false;
                ParamModelTech param = this.dcm.getControlTechById("TECH02").getParamTechById("failOnError");
                if (param != null && "false".equals(param.getValue())) {
                    shouldContinue = true;
                } else {
                    technicalValidationFailed = true;
                }
                this.status = 2;
            }
            if (shouldContinue && this.dcm.getControlTechById("TECH03") != null) {
                SchemaFactory xmlsf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                File fileSchema = new File(this.documentModel.getBaseDirectory(), this.dcm.getControlTechById("TECH03").getParamTechById("schemaLocation").getValue());
                try {
                    Schema schema = xmlsf.newSchema(fileSchema);
                    Validator validateur = schema.newValidator();
                    FileInputStream fis = new FileInputStream(this.inputXmlFile);
                    SAXSource saxSrc = new SAXSource(new InputSource(fis));
                    tech03.setDomainesControles(this.domainesControles);
                    validateur.setErrorHandler(tech03);
                    validateur.validate(saxSrc);
                    fis.close();
                }
                catch (Exception ex) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter((Writer)sw, true);
                    ex.printStackTrace(pw);
                    Anomalie ano = new Anomalie(IdGenerator.nextId(), "TECH03", "Contr\u00f4le de conformit\u00e9 as sch\u00e9ma du fichier.", this.documentModel.getId(), "", "", "", "", "", "Erreur inattendue lors du chargement du sch\u00e9ma:\n" + sw.toString(), "Le sch\u00e9ma ne peut pas \u00eatre charg\u00e9.", "BLOQUANT", "xpath namespacise", new Hashtable<String, Object>());
                    this.anomaliesTechniques.add(ano);
                }
                if (tech03.getAnomalies().size() > 0) {
                    this.anomaliesTechniques.addAll(tech03.getAnomalies());
                    shouldContinue = false;
                    ParamModelTech param = this.dcm.getControlTechById("TECH03").getParamTechById("failOnError");
                    if (param != null && "false".equals(param.getValue())) {
                        shouldContinue = true;
                    } else {
                        technicalValidationFailed = true;
                    }
                    this.status = 3;
                }
            }
            if (shouldContinue) {
                this.cch.setParameters(this.hashParams);
                this.cch.setControlsModel(this.dcm.getControls());
                try {
                    FileInputStream fis = new FileInputStream(this.inputXmlFile);
                    SAXParser parserXml = this.factorySAX.newSAXParser();
                    this.saxWriter.setNamespaceContext(this.nameSpaces);
                    if (this.fichierEnrichiLocation == null) {
                        this.fichierEnrichiLocation = new File(tmpDir, this.inputXmlFile.getName()).getAbsolutePath();
                    }
                    this.fichierEnrichi = new File(this.fichierEnrichiLocation);
                    DOMResult dr = new DOMResult();
                    this.saxWriter.setResult(dr);
                    this.cch.setSaxWriter(this.saxWriter);
                    this.cch.setNamespaceContext(this.nameSpaces);
                    this.cch.setFileName(this.inputXmlFile.getName());
                    parserXml.parse((InputStream)fis, (DefaultHandler)this.cch);
                    StreamResult sr = new StreamResult(this.fichierEnrichi);
                    TransformerFactory tf = TransformerFactoryImpl.newInstance();
                    Transformer t = tf.newTransformer();
                    t.transform(new DOMSource(dr.getNode()), sr);
                    if (sr.getOutputStream() != null) {
                        sr.getOutputStream().flush();
                        sr.getOutputStream().close();
                    }
                    fis.close();
                    if (this.cch.getVTotalAnomalies().size() > 0) {
                        this.anomaliesTechniques.addAll(this.cch.getVTotalAnomalies());
                        this.status = 4;
                    } else {
                        this.status = 5;
                    }
                }
                catch (Exception ex) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter((Writer)sw, true);
                    ex.printStackTrace(pw);
                    Anomalie ano = new Anomalie(IdGenerator.nextId(), "Contr\u00f4les m\u00e9tier", "Application des contr\u00f4les m\u00e9tier.", this.documentModel.getId(), "", "", "", "", "", "Erreur inattendue lors de l'application des contr\u00f4les m\u00e9tiers:\n" + sw.toString(), ex.getMessage(), "BLOQUANT", "xpath namespacise", new Hashtable<String, Object>());
                    this.anomaliesTechniques.add(ano);
                }
            }
        }
        if ((pColl = this.cch.getCollectivite()) == null || pColl.key == null || pColl.libelle == null) {
            pColl = new Pair("00000000000000", "Collectivite de Contr\u00f4le");
        }
        if ((pBudg = this.cch.getBudget()) == null || pBudg.key == null || pBudg.libelle == null) {
            pBudg = new Pair("00", "Budget de Contr\u00f4le");
        }
        try {
            this.writeRapport(pColl, pBudg, this.anomaliesTechniques, this.cch.MAX_ANOS);
        }
        catch (IOException ioEx) {
            // empty catch block
        }
        this.cpl.stopWaiting();
        if (technicalValidationFailed) {
            this.cpl.notifyTechniqueValidationFailed();
        }
    }

    public Pair getCollectivite() throws IllegalStateException {
        if (this.status == -1) {
            throw new IllegalStateException("You must run control before calling getCollectivite()");
        }
        if (this.cch != null) {
            return this.cch.getCollectivite();
        }
        return null;
    }

    public Pair getBudget() throws IllegalStateException {
        if (this.status == -1) {
            throw new IllegalStateException("You must run control before calling getBudget()");
        }
        if (this.cch != null) {
            return this.cch.getBudget();
        }
        return null;
    }

    public Vector<Anomalie> getTotalAnomalies() throws IllegalStateException {
        if (this.status == -1) {
            throw new IllegalStateException("You must run control before calling getTotalAnomalies()");
        }
        return this.cch != null ? this.cch.getVTotalAnomalies() : new Vector<Anomalie>();
    }

    private ControlsModel getControlsModel() {
        ControlsModel ret = null;
        try {
            ControlParser cp = new ControlParser();
            cp.parse(new File(this.documentModel.getBaseDirectory(), this.documentModel.getControlConfigFile()));
            ControlsModel c = (ControlsModel)cp.getMarshallable();
            c.validate();
            ret = c;
        }
        catch (Exception ex) {
            logger.debug((Object)"Error in getControlsModel()!!!", (Throwable)ex);
        }
        return ret;
    }

    public void setFileToControl(File f) {
        this.fichierAController = f;
    }

    public File getFileToControl() {
        return this.fichierAController;
    }

    public void setParameters(Hashtable<String, Object> params) {
        this.hashParams = params;
    }

    private void writeRapport(Pair collec, Pair budg, ArrayList<Anomalie> vano, int maxanos) throws IOException {
        String[] domaines;
        logger.debug((Object)("writing rapport: \n\tcollectivite = " + collec + "\n\tbuget=" + budg));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String msgAno = "";
        msgAno = vano != null && vano.size() >= maxanos && !vano.get(0).getControleID().startsWith("TECH") ? "true" : "false";
        this.IDrapport = this.datecontrole.getTime() + this.rapport.getName();
        Pair docid = new Pair("V", this.documentModel.getId());
        this.rapportWriter.writeElement("DocId", docid);
        this.rapportWriter.writeElement("NomFichier", new Pair("V", this.fichierAController.getName()), new Pair("fullPath", this.fichierAController.getAbsolutePath()), new Pair("host", HostUtils.getHostName()));
        this.rapportWriter.writeElement("DateControle", new Pair("V", simpleDateFormat.format(this.datecontrole)));
        this.rapportWriter.openElement("Collectivite");
        this.rapportWriter.writeElement("Siret", new Pair("V", collec.key));
        this.rapportWriter.writeElement("Libelle", new Pair("V", collec.libelle));
        this.rapportWriter.closeElement("Collectivite");
        this.rapportWriter.openElement("Budget");
        this.rapportWriter.writeElement("Code", new Pair("V", budg.key));
        this.rapportWriter.writeElement("Libelle", new Pair("V", budg.libelle));
        this.rapportWriter.closeElement("Budget");
        this.rapportWriter.writeElement("TropAnos", new Pair("V", msgAno));
        this.rapportWriter.openElement("Domaines");
        for (String domain : domaines = this.domainesControles.split(" / ")) {
            this.rapportWriter.writeElement("Domaine", new Pair("V", domain));
        }
        this.rapportWriter.closeElement("Domaines");
        this.rapportWriter.openElement("Params");
        this.writeParameters();
        this.rapportWriter.closeElement("Params");
        this.rapportWriter.openElement("DonneesRapport");
        this.rapportWriter.openElement("Rapport");
        this.rapportWriter.writeElement("Id", new Pair("V", this.datecontrole.getTime() + this.rapport.getName()));
        if (vano != null) {
            Collections.sort(vano, Collections.reverseOrder());
            for (Anomalie anomalie : vano) {
                anomalie.marshall(this.rapportWriter);
            }
        }
        this.rapportWriter.closeElement("Rapport");
        this.rapportWriter.closeElement("DonneesRapport");
        if (this.cm.getMessage() != null) {
            this.rapportWriter.openElement("Message");
            this.rapportWriter.writeData(this.cm.getMessage().getHtmlContent());
            this.rapportWriter.closeElement("Message");
        }
        this.rapportWriter.endRapport();
        logger.debug((Object)("Le rapport se trouve dans : " + this.rapport.getParent()));
    }

    @Deprecated
    private void writeAnomalie(Anomalie a) {
        this.rapportWriter.openElement("Anomalie");
        this.rapportWriter.writeElement("Id", new Pair("V", a.getIdAnomalie()));
        this.rapportWriter.writeElement("IdCtrl", new Pair("V", a.getControleID()));
        this.rapportWriter.writeElement("LibelleCtrl", new Pair("V", a.getControleLibelle()));
        this.rapportWriter.writeElement("EtatId", new Pair("V", a.getEtatID()));
        this.rapportWriter.writeElement("ElementImportable", new Pair("V", a.getelementImportable()));
        this.rapportWriter.writeElement("IdElementImportable", new Pair("V", a.getIdElementImportable()));
        this.rapportWriter.writeElement("ElementEnAnomalie", new Pair("V", a.getelementEnAnomalie()));
        this.rapportWriter.writeElement("LibelleLien", new Pair("V", a.getLibelleLien()));
        this.rapportWriter.openElement("Message");
        this.rapportWriter.writeData(a.getMessage().replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("&", "&amp;"));
        this.rapportWriter.closeElement("Message");
        this.rapportWriter.openElement("Regle");
        this.rapportWriter.writeData(a.getRegle().replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("&", "&amp;"));
        this.rapportWriter.closeElement("Regle");
        this.rapportWriter.writeElement("Severity", new Pair("V", a.getSeverity()));
        if (a.getXPath() != null) {
            this.rapportWriter.writeElement("XPath", new Pair("V", a.getXPath()));
        }
        if (a.getXslParams() != null && a.getXslParams().size() > 0) {
            for (String key : a.getXslParams().keySet()) {
                String value = a.getXslParams().get(key).toString();
                this.rapportWriter.openElement("XslParam");
                this.rapportWriter.writeElement("Key", new Pair("V", key));
                this.rapportWriter.writeElement("Value", new Pair("V", value));
                this.rapportWriter.closeElement("XslParam");
            }
        }
        this.rapportWriter.closeElement("Anomalie");
    }

    private String writeParameters() {
        StringBuffer params = new StringBuffer();
        for (ParamModel param : this.dcm.getParams()) {
            String paramValue = "";
            if (this.hashParams.get(param.getId()).getClass().equals(Boolean.class)) {
                paramValue = this.hashParams.get(param.getId()).equals(true) ? "Oui" : (this.hashParams.get(param.getId()).equals(false) ? "Non" : "Nc");
            } else if (this.hashParams.get(param.getId()).getClass().equals(BigDecimal.class)) {
                paramValue = this.hashParams.get(param.getId()).toString();
            } else if (this.hashParams.get(param.getId()).getClass().equals(String.class)) {
                paramValue = this.hashParams.get(param.getId()).toString();
            } else if (this.hashParams.get(param.getId()).getClass().equals(Integer.class)) {
                paramValue = this.hashParams.get(param.getId()).toString();
            } else if (this.hashParams.get(param.getId()) instanceof String[]) {
                if (((String[])this.hashParams.get(param.getId())).length == 0) {
                    paramValue = "Non Renseign\u00e9";
                }
                for (int i = 0; i < ((String[])this.hashParams.get(param.getId())).length; ++i) {
                    paramValue = paramValue + (i != 0 ? ", " : "") + ((String[])this.hashParams.get(param.getId()))[i];
                }
            } else {
                paramValue = this.hashParams.get(param.getId()).getClass().getName();
            }
            this.rapportWriter.writeElement("Param", new Pair("Name", param.getName()), new Pair("Value", paramValue));
        }
        return params.toString();
    }

    public void writeControlConfigFile() throws IOException {
        File output = new File(this.documentModel.getBaseDirectory(), this.documentModel.getControlConfigFile());
        OutputStreamWriter os = new OutputStreamWriter((OutputStream)new FileOutputStream(output), "ISO-8859-1");
        XmlOutputter outputter = new XmlOutputter(os, "ISO-8859-1");
        this.cm.marshall(outputter);
        os.flush();
        os.close();
    }

    public int getControlStatus() {
        return this.status;
    }

    public DocumentModel getDocumentModel() {
        return this.documentModel;
    }

    public File getFichierEnrichi() throws IllegalStateException {
        if (this.status == -1) {
            throw new IllegalStateException("You must run control before calling getFichierEnrichi()");
        }
        return this.fichierEnrichi;
    }

    public File getRapport() throws IllegalStateException {
        if (this.status == -1) {
            throw new IllegalStateException("You must run control before calling getRapport()");
        }
        return this.rapport;
    }

    public String getIdRapport() {
        return this.IDrapport;
    }

    public void setControlProgressListener(ControlProgressListener cpl) {
        this.cpl = cpl;
    }

    public void setFichierEnrichiLocation(String absoluteFileName) throws IllegalStateException {
        if (this.status != -1) {
            throw new IllegalStateException("You must not change fichierEnrichi location after control");
        }
        this.fichierEnrichiLocation = absoluteFileName;
    }

    public void setRapportLocation(String absoluteFileName) throws IllegalStateException {
        if (this.status != -1) {
            throw new IllegalStateException("You must not change rapport location after control");
        }
        this.rapportLocation = absoluteFileName;
    }

    public AbstractControlContentHandler getControlContentHandler(DocumentModel dm, DocumentControlModel docCtrlMod, Hashtable<String, Object> parameters, MainWindow owner, String file, ControlProgressListener cpl) {
        return new DefaultControlContentHandler(dm, docCtrlMod, parameters, owner, file, cpl);
    }

    public static class Triplet {
        public String iDrapport;
        public String codeCollectivite;
        public String codeBudget;

        public Triplet(String idRapport, String codColl, String codBud) {
            this.iDrapport = idRapport;
            this.codeCollectivite = codColl;
            this.codeBudget = codBud;
        }
    }
}

