/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.controls.pesv2.sig;

import fr.gouv.finances.cp.xemelios.controls.AbstractUnitControl;
import fr.gouv.finances.cp.xemelios.controls.Anomalie;
import fr.gouv.finances.cp.xemelios.controls.IdGenerator;
import fr.gouv.finances.cp.xemelios.controls.Node;
import fr.gouv.finances.cp.xemelios.controls.pesv2.ConstantsControlsPESv2;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SIG1
extends AbstractUnitControl
implements ConstantsControlsPESv2 {
    private static final Logger logger = Logger.getLogger(SIG1.class);
    public static final transient String CTRL_ID = "SIG1";
    private Hashtable<String, Object> hParams;
    private String docId = null;
    private String bord_nodeId = null;
    private String bord_Exer = "";
    private String bord_IdBord = "";
    private String bord_TypBord = "";
    private String piece_IdPce = "";
    private String enTete_infodemat = null;
    private String enTete_infodemat_nodeId = "";
    private boolean signature_isPresent = false;
    private static final String MSG_ERREUR = "#MSG_ERREUR#";
    private static final String CHEMIN_BLOCBORDEREAU = "/Bordereau/BlocBordereau/";
    private static final String CHEMIN_BLOCBORDEREAU_EXER = "/Bordereau/BlocBordereau/Exer/";
    private static final String CHEMIN_BLOCBORDEREAU_IDBORD = "/Bordereau/BlocBordereau/IdBord/";
    private static final String CHEMIN_BLOCBORDEREAU_TYPBORD = "/Bordereau/BlocBordereau/TypBord/";
    private static final String CHEMIN_SIGNATURE = "/Signature/";
    private static final String CHEMIN_FIN = "PES_Aller/";
    private static final String RECETTE = "PES_RecetteAller";
    private static final String DEPENSE = "PES_DepenseAller";
    private boolean depense = false;
    private static String CHEMIN_BLOCPIECE = "";
    private static String CHEMIN_BLOCPIECE_IDPCE = "";
    private static String CHEMIN_ENTETE = "";
    private static String CHEMIN_ENTETE_INFODEMATERIALISEE = "";
    private static final String R_CHEMIN_BLOCPIECE = "/Bordereau/Piece/BlocPiece/";
    private static final String R_CHEMIN_BLOCPIECE_IDPCE = "/Bordereau/Piece/BlocPiece/IdPce/";
    private static final String R_CHEMIN_ENTETE = "/EnTeteRecette/";
    private static final String R_CHEMIN_ENTETE_INFODEMATERIALISEE = "/EnTeteRecette/InfoDematerialisee/";
    private static final String D_CHEMIN_BLOCPIECE = "/Bordereau/Piece/BlocPiece/";
    private static final String D_CHEMIN_BLOCPIECE_IDPCE = "/Bordereau/Piece/BlocPiece/InfoPce/IdPce/";
    private static final String D_CHEMIN_ENTETE = "/EnTeteDepense/";
    private static final String D_CHEMIN_ENTETE_INFODEMATERIALISEE = "/EnTeteDepense/InfoDematerialisee/";

    public void startDocument() throws SAXException {
        logger.info((Object)"In SIG1");
    }

    public void setDocId(String docID) {
        this.docId = docID;
    }

    public void startElement(String uri, String localName, String qName, Attributes atts, String xpath) {
        if (xpath.indexOf(DEPENSE) != -1) {
            this.depense = true;
            CHEMIN_BLOCPIECE = "/Bordereau/Piece/BlocPiece/";
            CHEMIN_BLOCPIECE_IDPCE = D_CHEMIN_BLOCPIECE_IDPCE;
            CHEMIN_ENTETE = D_CHEMIN_ENTETE;
            CHEMIN_ENTETE_INFODEMATERIALISEE = D_CHEMIN_ENTETE_INFODEMATERIALISEE;
        }
        if (xpath.indexOf(RECETTE) != -1) {
            this.depense = false;
            CHEMIN_BLOCPIECE = "/Bordereau/Piece/BlocPiece/";
            CHEMIN_BLOCPIECE_IDPCE = R_CHEMIN_BLOCPIECE_IDPCE;
            CHEMIN_ENTETE = R_CHEMIN_ENTETE;
            CHEMIN_ENTETE_INFODEMATERIALISEE = R_CHEMIN_ENTETE_INFODEMATERIALISEE;
        }
        if (xpath.endsWith(CHEMIN_BLOCBORDEREAU)) {
            this.bord_TypBord = "";
            this.bord_IdBord = "";
            this.bord_Exer = "";
            this.bord_nodeId = atts.getValue("ano:node-id");
        }
        if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_EXER)) {
            this.bord_Exer = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_IDBORD)) {
            this.bord_IdBord = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_TYPBORD)) {
            this.bord_TypBord = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_BLOCPIECE)) {
            this.piece_IdPce = "";
        }
        if (xpath.endsWith(CHEMIN_BLOCPIECE_IDPCE)) {
            this.piece_IdPce = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_ENTETE)) {
            this.enTete_infodemat_nodeId = null;
            this.enTete_infodemat = null;
        }
        if (xpath.endsWith(CHEMIN_ENTETE_INFODEMATERIALISEE)) {
            this.enTete_infodemat = atts.getValue("V");
            this.enTete_infodemat_nodeId = atts.getValue("ano:node-id");
        }
        if (xpath.endsWith(CHEMIN_SIGNATURE)) {
            this.signature_isPresent = true;
        }
    }

    public Vector<Anomalie> endElement(String uri, String localName, String qName, String xpath) throws SAXException {
        boolean err = false;
        String erreur = "";
        if (xpath.endsWith(CHEMIN_FIN)) {
            if (("1".equals(this.enTete_infodemat) || "true".equals(this.enTete_infodemat) || "yes".equals(this.enTete_infodemat)) && !this.signature_isPresent) {
                err = true;
                erreur = "La balise InfoDematerialisee est valoris\u00e9e de telle fa\u00e7on que vous attestez la pr\u00e9sence d'une signature \u00e9lectronique, hors elle est absente (signature globale ou individuelle)";
            } else if (("0".equals(this.enTete_infodemat) || "false".equals(this.enTete_infodemat) || "no".equals(this.enTete_infodemat)) && this.signature_isPresent) {
                err = true;
                erreur = "Le flux est sign\u00e9 \u00e9lectroniquement mais la balise InfoDematerialisee n'est pas correctement valoris\u00e9e";
            } else if (this.signature_isPresent && this.enTete_infodemat == null) {
                err = true;
                erreur = "Le flux est sign\u00e9 \u00e9lectroniquement mais la balise InfoDematerialisee  n?est pas pr\u00e9sente";
            }
            if (err) {
                Vector<Anomalie> ano1 = new Vector<Anomalie>();
                String msg = this.getDocumentModel().getControlById(CTRL_ID).getMessage().getHtmlContent();
                msg = msg.replaceAll(MSG_ERREUR, erreur);
                String path = "@added:primary-key='" + this.bord_Exer + "-" + this.bord_TypBord + "-" + this.bord_IdBord + "'";
                String anoId = IdGenerator.nextId();
                String libelleLien = "Bordereau " + this.bord_IdBord + " Mandat " + this.piece_IdPce;
                Hashtable<String, String> xslParams = new Hashtable<String, String>();
                xslParams.put("elementId", "");
                xslParams.put("mandatId", this.piece_IdPce);
                xslParams.put("browser-destination", "internal");
                xslParams.put("anoId", anoId);
                Anomalie ano = new Anomalie(anoId, this.getDocumentModel().getControlById(CTRL_ID).getId(), this.getDocumentModel().getControlById(CTRL_ID).getLibelle(), this.getDocumentModel().getDocumentId(), xpath.split("/")[0], this.depense ? "BordereauDepense" : "BordereauRecette", this.bord_IdBord, localName, libelleLien, msg, this.getDocumentModel().getControlById(CTRL_ID).getRegle().getHtmlContent(), this.getDocumentModel().getControlById(CTRL_ID).getSeverity(), path, xslParams);
                if (this.enTete_infodemat_nodeId != null) {
                    ano.addNode(new Node(this.enTete_infodemat_nodeId));
                }
                ano1.add(ano);
                return ano1;
            }
            return null;
        }
        return null;
    }

    public void endDocument() throws SAXException {
    }

    public void characters(char[] ch, int start, int length, String xpath) {
    }

    public void ignorableWhitespace(char[] ch, int start, int length, String xpath) {
    }

    public void startPrefixMapping(String prefix, String uri, String xpath) {
    }

    public void endPrefixMapping(String prefix, String xpath) {
    }

    public void processingInstruction(String target, String data, String xpath) {
    }

    public void skippedEntity(String name, String xpath) {
    }

    public void setParameters(Hashtable<String, Object> params) {
        this.hParams = params;
    }

    public void setDocumentLocator(Locator locator) {
    }
}

