/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.controls.pesv2.rec;

import fr.gouv.finances.cp.xemelios.controls.AbstractUnitControl;
import fr.gouv.finances.cp.xemelios.controls.Anomalie;
import fr.gouv.finances.cp.xemelios.controls.IdGenerator;
import fr.gouv.finances.cp.xemelios.controls.Node;
import fr.gouv.finances.cp.xemelios.controls.pesv2.ConstantsControlsPESv2;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class REC29
extends AbstractUnitControl
implements ConstantsControlsPESv2 {
    private static final Logger logger = Logger.getLogger(REC29.class);
    public static final transient String CTRL_ID = "REC29";
    private Vector<Anomalie> anos = new Vector();
    private Hashtable<String, Object> hParams;
    private String docId = null;
    private String nodeId = null;
    private static final String FIN_PIECE = "/PES_RecetteAller/Bordereau/Piece/";
    private static final String LIGNEPCE = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/";
    private static final String ON_RETURN_ANOMALIES = "/PES_RecetteAller/Bordereau/Piece/";
    private String bord_IdBord = "";
    private String bord_ExerBord = "";
    private String bord_TypBord = "";
    private String piece_IdPce = "";
    private String piece_TypPce = "";
    private String piece_NatPce = "";
    private String ligne_IdLigne = "";
    private String ligne_Nature = "";
    private String rattachPiece_NatPceOrig = "";
    private String rattachPiece_ExerRat = "";
    private String ligne_IdLigne_NodeId = "";
    private String rattachPiece_NatPceOrig_nodeId = "";
    private String rattachPiece_ExerRat_nodeId = "";
    private boolean rattachPiece_exist = false;
    private static final String MSG_BORD_NUM = "#BORD_NUM#";
    private static final String MSG_PIECE_ID = "#PIECE_IDPCE#";
    private static final String MSG_LIGNE_IDLIGNE = "#LIGNE_IDLIGNE#";
    private static final String MSG_ERREUR = "#ERREUR#";
    private static final String CHEMIN_BLOCBORDEREAU = "/PES_RecetteAller/Bordereau/BlocBordereau/";
    private static final String CHEMIN_PIECE = "/PES_RecetteAller/Bordereau/Piece/";
    private static final String CHEMIN_BLOCBORDEREAU_EXER = "/PES_RecetteAller/Bordereau/BlocBordereau/Exer/";
    private static final String CHEMIN_BLOCBORDEREAU_IDBORD = "/PES_RecetteAller/Bordereau/BlocBordereau/IdBord/";
    private static final String CHEMIN_BLOCBORDEREAU_TYPBORD = "/PES_RecetteAller/Bordereau/BlocBordereau/TypBord/";
    private static final String CHEMIN_BLOCPIECE_NATPIECE = "/PES_RecetteAller/Bordereau/Piece/BlocPiece/NatPce/";
    private static final String CHEMIN_BLOCPIECE_IDPIECE = "/PES_RecetteAller/Bordereau/Piece/BlocPiece/IdPce/";
    private static final String CHEMIN_BLOCPIECE_TYPPIECE = "/PES_RecetteAller/Bordereau/Piece/BlocPiece/TypPce/";
    private static final String CHEMIN_BLOCLIGNEPIECE = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/";
    private static final String CHEMIN_BLOCLIGNEPIECE_RATTACHPIECE = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/RattachPiece/";
    private static final String CHEMIN_RATTACHPIECE_NATPCEORIG = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/RattachPiece/NatPceOrig/";
    private static final String CHEMIN_RATTACHPIECE_EXERRAT = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/RattachPiece/ExerRat/";
    private static final String CHEMIN_INFOLIGNEPIECE_IDLIGNE = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePiece/IdLigne/";
    private static final String CHEMIN_INFOLIGNEPIECE_NATURE = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePiece/Nature/";

    public void startDocument() throws SAXException {
        logger.info((Object)"In REC29");
    }

    public void setDocId(String docID) {
        this.docId = docID;
    }

    public void startElement(String uri, String localName, String qName, Attributes atts, String xpath) {
        if (xpath.endsWith(CHEMIN_BLOCBORDEREAU)) {
            this.bord_TypBord = "";
            this.bord_IdBord = "";
            this.bord_ExerBord = "";
        }
        if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_EXER)) {
            this.bord_ExerBord = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_IDBORD)) {
            this.bord_IdBord = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_TYPBORD)) {
            this.bord_TypBord = atts.getValue("V");
        }
        if (xpath.endsWith("/PES_RecetteAller/Bordereau/Piece/")) {
            if (this.anos != null) {
                this.anos = new Vector();
            }
            this.piece_NatPce = "";
            this.piece_TypPce = "";
            this.piece_IdPce = "";
        }
        if (xpath.endsWith(CHEMIN_BLOCPIECE_IDPIECE)) {
            this.piece_IdPce = atts.getValue("V");
            this.anos.clear();
        }
        if (xpath.endsWith(CHEMIN_BLOCPIECE_TYPPIECE)) {
            this.piece_TypPce = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_BLOCPIECE_NATPIECE)) {
            this.piece_NatPce = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_BLOCLIGNEPIECE)) {
            this.ligne_Nature = "";
            this.ligne_IdLigne = "";
            this.ligne_IdLigne_NodeId = "";
            this.rattachPiece_exist = false;
            this.rattachPiece_NatPceOrig = "";
            this.rattachPiece_ExerRat = "";
            this.rattachPiece_NatPceOrig_nodeId = "";
            this.rattachPiece_ExerRat_nodeId = "";
        }
        if (xpath.endsWith(CHEMIN_BLOCLIGNEPIECE_RATTACHPIECE)) {
            this.rattachPiece_exist = true;
        }
        if (xpath.endsWith(CHEMIN_RATTACHPIECE_NATPCEORIG)) {
            this.rattachPiece_NatPceOrig = atts.getValue("V");
            this.rattachPiece_NatPceOrig_nodeId = atts.getValue("ano:node-id");
        }
        if (xpath.endsWith(CHEMIN_RATTACHPIECE_EXERRAT)) {
            this.rattachPiece_ExerRat = atts.getValue("V");
            this.rattachPiece_ExerRat_nodeId = atts.getValue("ano:node-id");
        }
        if (xpath.endsWith(CHEMIN_INFOLIGNEPIECE_IDLIGNE)) {
            this.ligne_IdLigne = atts.getValue("V");
            this.ligne_IdLigne_NodeId = atts.getValue("ano:node-id");
        }
        if (xpath.endsWith(CHEMIN_INFOLIGNEPIECE_NATURE)) {
            this.ligne_Nature = atts.getValue("V");
        }
    }

    public Vector<Anomalie> endElement(String uri, String localName, String qName, String xpath) throws SAXException {
        Vector<Node> anonodes = new Vector<Node>();
        boolean err = false;
        String erreur = "";
        if (xpath.endsWith(LIGNEPCE)) {
            if (this.haveToTest()) {
                if ((this.piece_TypPce.equals("03") && this.piece_NatPce.equals("01") && this.ligne_Nature.startsWith("79") || this.piece_TypPce.equals("03") && this.piece_NatPce.equals("02") && this.ligne_Nature.startsWith("481")) && (!this.rattachPiece_exist || !this.rattachPiece_NatPceOrig.equals("02") || Integer.parseInt(this.bord_ExerBord) != Integer.parseInt(this.rattachPiece_ExerRat))) {
                    err = true;
                    erreur = "L'exercice de la pi\u00e8ce de rattachement doit \u00eatre \u00e9gal \u00e0 l'exercice du bordereau et la pi\u00e8ce de rattachement est un mandat";
                    if (!this.rattachPiece_exist) {
                        anonodes.add(new Node(this.ligne_IdLigne_NodeId));
                    } else {
                        if (!this.rattachPiece_NatPceOrig.equals("02")) {
                            anonodes.add(new Node(this.rattachPiece_NatPceOrig_nodeId));
                        }
                        if (Integer.parseInt(this.bord_ExerBord) != Integer.parseInt(this.rattachPiece_ExerRat)) {
                            anonodes.add(new Node(this.rattachPiece_ExerRat_nodeId));
                        }
                    }
                }
                if ((this.piece_TypPce.equals("14") && this.piece_NatPce.equals("01") || this.piece_TypPce.equals("02") && this.piece_NatPce.equals("10")) && (!this.rattachPiece_exist || !this.rattachPiece_NatPceOrig.equals("01") || Integer.parseInt(this.bord_ExerBord) - 1 != Integer.parseInt(this.rattachPiece_ExerRat))) {
                    err = true;
                    erreur = "L'exercice de la pi\u00e8ce de rattachement doit \u00eatre \u00e9gal \u00e0 l'exercice pr\u00e9c\u00e9dent celui du bordereau et la pi\u00e8ce de rattachement est un titre";
                    if (!this.rattachPiece_exist) {
                        anonodes.add(new Node(this.ligne_IdLigne_NodeId));
                    } else {
                        if (!this.rattachPiece_NatPceOrig.equals("01")) {
                            anonodes.add(new Node(this.rattachPiece_NatPceOrig_nodeId));
                        }
                        if (Integer.parseInt(this.bord_ExerBord) - 1 != Integer.parseInt(this.rattachPiece_ExerRat)) {
                            anonodes.add(new Node(this.rattachPiece_ExerRat_nodeId));
                        }
                    }
                }
            }
            if (err) {
                String msg = this.getDocumentModel().getControlById(CTRL_ID).getMessage().getHtmlContent();
                msg = msg.replaceAll(MSG_BORD_NUM, this.bord_IdBord);
                msg = msg.replaceAll(MSG_PIECE_ID, this.piece_IdPce);
                msg = msg.replaceAll(MSG_LIGNE_IDLIGNE, this.ligne_IdLigne);
                msg = msg.replaceAll(MSG_ERREUR, erreur);
                String path = "@added:primary-key='" + this.bord_ExerBord + "-" + this.bord_TypBord + "-" + this.bord_IdBord + "'";
                String anoId = IdGenerator.nextId();
                String libelleLien = "Bordereau " + this.bord_IdBord + " Titre " + this.piece_IdPce;
                Hashtable<String, String> xslParams = new Hashtable<String, String>();
                xslParams.put("elementId", "");
                xslParams.put("mandatId", this.piece_IdPce);
                xslParams.put("browser-destination", "internal");
                xslParams.put("anoId", anoId);
                Anomalie ano = new Anomalie(anoId, this.getDocumentModel().getControlById(CTRL_ID).getId(), this.getDocumentModel().getControlById(CTRL_ID).getLibelle(), this.getDocumentModel().getDocumentId(), xpath.split("/")[1], "BordereauRecette", this.bord_IdBord, localName, libelleLien, msg, this.getDocumentModel().getControlById(CTRL_ID).getRegle().getHtmlContent(), this.getDocumentModel().getControlById(CTRL_ID).getSeverity(), path, xslParams);
                ano.addAll(anonodes);
                this.anos.add(ano);
            }
            return null;
        }
        if (xpath.endsWith("/PES_RecetteAller/Bordereau/Piece/")) {
            return this.anos;
        }
        return null;
    }

    public boolean haveToTest() {
        String PAR1 = (String)this.hParams.get("nomencl");
        return PAR1.equals("M4") || PAR1.equals("M14") || PAR1.equals("M52") || PAR1.equals("M61") || PAR1.equals("M71");
    }

    public void endDocument() throws SAXException {
    }

    public void characters(char[] ch, int start, int length, String xpath) {
    }

    public void ignorableWhitespace(char[] ch, int start, int length, String xpath) {
    }

    public void startPrefixMapping(String prefix, String uri, String xpath) {
    }

    public void endPrefixMapping(String prefix, String xpath) {
    }

    public void processingInstruction(String target, String data, String xpath) {
    }

    public void skippedEntity(String name, String xpath) {
    }

    public void setParameters(Hashtable<String, Object> params) {
        this.hParams = params;
    }

    public void setDocumentLocator(Locator locator) {
    }
}

