/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.controls.pesv2.rec;

import fr.gouv.finances.cp.xemelios.controls.AbstractUnitControl;
import fr.gouv.finances.cp.xemelios.controls.Anomalie;
import fr.gouv.finances.cp.xemelios.controls.IdGenerator;
import fr.gouv.finances.cp.xemelios.controls.Node;
import fr.gouv.finances.cp.xemelios.controls.pesv2.ConstantsControlsPESv2;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class REC25
extends AbstractUnitControl
implements ConstantsControlsPESv2 {
    private static final Logger logger = Logger.getLogger(REC25.class);
    public static final transient String CTRL_ID = "REC25";
    private Vector<Anomalie> anos = new Vector();
    private Hashtable<String, Object> hParams;
    private static final String FIN_PIECE = "/PES_RecetteAller/Bordereau/Piece/";
    private static final String LIGNEPCE = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/";
    private static final String ON_RETURN_ANOMALIES = "/PES_RecetteAller/Bordereau/Piece/";
    private String bord_IdBord = "";
    private String bord_ExerBord = "";
    private String bord_TypBord = "";
    private String piece_IdPce = "";
    private String piece_TypPce = "";
    private String lignepiece_Id = "";
    private String lignepiece_CatTiers = "";
    private String lignepiece_NatJur = "";
    private String lignepiece_Tiers_Nom = "";
    private String lignepiece_CpteBancaire_NodeId = "";
    private String lignepiece_NodeId = "";
    private Vector<String> vCatTiersNatJur = new Vector();
    private boolean cpteBancaireExist = false;
    int compteurTiers = 0;
    private static final String MSG_BORD_NUM = "#BORD_NUM#";
    private static final String MSG_BORD_EXER = "#BORD_EXER#";
    private static final String MSG_BORD_TYPE = "#BORD_TYPBORD#";
    private static final String MSG_PIECE_ID = "#PIECE_IDPCE#";
    private static final String MSG_LIGNEPIECE_ID = "#LIGNE_IDLIGNE#";
    private static final String CHEMIN_BLOCBORDEREAU = "/PES_RecetteAller/Bordereau/BlocBordereau/";
    private static final String CHEMIN_PIECE = "/PES_RecetteAller/Bordereau/Piece/";
    private static final String CHEMIN_BLOCBORDEREAU_EXER = "/PES_RecetteAller/Bordereau/BlocBordereau/Exer/";
    private static final String CHEMIN_BLOCBORDEREAU_IDBORD = "/PES_RecetteAller/Bordereau/BlocBordereau/IdBord/";
    private static final String CHEMIN_BLOCBORDEREAU_TYPBORD = "/PES_RecetteAller/Bordereau/BlocBordereau/TypBord/";
    private static final String CHEMIN_BLOCPIECE_IDPIECE = "/PES_RecetteAller/Bordereau/Piece/BlocPiece/IdPce/";
    private static final String CHEMIN_BLOCPIECE_TYPPIECE = "/PES_RecetteAller/Bordereau/Piece/BlocPiece/TypPce/";
    private static final String CHEMIN_LIGNEPIECE = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/";
    private static final String CHEMIN_LIGNEPIECE_ID = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePiece/IdLigne/";
    private static final String CHEMIN_LIGNEPIECE_TIERS = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/Tiers/";
    private static final String CHEMIN_TIERS_CPTEBANCAIRE = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/Tiers/CpteBancaire/";
    private static final String CHEMIN_TIERS_CATTIERS = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/Tiers/InfoTiers/CatTiers/";
    private static final String CHEMIN_TIERS_NATJUR = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/Tiers/InfoTiers/NatJur/";
    private static final String CHEMIN_TIERS_TYPTIERS = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/Tiers/InfoTiers/TypTiers/";
    private static final String CHEMIN_TIERS_NOM = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/Tiers/InfoTiers/Nom/";

    public void startDocument() throws SAXException {
        logger.info((Object)"In REC25");
    }

    public void startElement(String uri, String localName, String qName, Attributes atts, String xpath) {
        if (xpath.endsWith(CHEMIN_BLOCBORDEREAU) && !this.anos.isEmpty()) {
            this.anos = new Vector();
        }
        if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_EXER)) {
            this.bord_ExerBord = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_IDBORD)) {
            this.bord_IdBord = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_TYPBORD)) {
            this.bord_TypBord = atts.getValue("V");
        }
        if (xpath.endsWith("/PES_RecetteAller/Bordereau/Piece/")) {
            this.anos.clear();
            this.piece_TypPce = "";
            this.piece_IdPce = "";
        }
        if (xpath.endsWith(CHEMIN_BLOCPIECE_IDPIECE)) {
            this.piece_IdPce = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_BLOCPIECE_TYPPIECE)) {
            this.piece_TypPce = atts.getValue("V");
        }
        if (xpath.endsWith("/PES_RecetteAller/Bordereau/Piece/LigneDePiece/")) {
            this.vCatTiersNatJur.clear();
            this.lignepiece_Id = "";
            this.lignepiece_NodeId = "";
            this.compteurTiers = 0;
        }
        if (xpath.endsWith(CHEMIN_LIGNEPIECE_ID)) {
            this.lignepiece_Id = atts.getValue("V");
            this.lignepiece_NodeId = atts.getValue("ano:node-id");
        }
        if (xpath.endsWith(CHEMIN_LIGNEPIECE_TIERS)) {
            ++this.compteurTiers;
            this.cpteBancaireExist = false;
            this.lignepiece_Tiers_Nom = "";
            this.lignepiece_NatJur = "";
            this.lignepiece_CatTiers = "";
            this.lignepiece_CpteBancaire_NodeId = "";
        }
        if (xpath.endsWith(CHEMIN_TIERS_CPTEBANCAIRE)) {
            this.cpteBancaireExist = true;
            this.lignepiece_CpteBancaire_NodeId = atts.getValue("ano:node-id");
        }
        if (xpath.endsWith(CHEMIN_TIERS_CATTIERS)) {
            this.lignepiece_CatTiers = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_TIERS_NATJUR)) {
            this.lignepiece_NatJur = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_TIERS_TYPTIERS)) {
            this.vCatTiersNatJur.add(this.lignepiece_CatTiers + this.lignepiece_NatJur);
        }
        if (xpath.endsWith(CHEMIN_TIERS_NOM)) {
            this.lignepiece_Tiers_Nom = atts.getValue("V");
        }
    }

    public Vector<Anomalie> endElement(String uri, String localName, String qName, String xpath) throws SAXException {
        String severity = this.getDocumentModel().getControlById(CTRL_ID).getSeverity();
        if (xpath.endsWith(CHEMIN_LIGNEPIECE_TIERS)) {
            if ((this.piece_TypPce.equals("03") || this.piece_TypPce.equals("04")) && this.cpteBancaireExist) {
                severity = "BLOQUANT";
                String msg = this.getDocumentModel().getControlById(CTRL_ID).getMessage().getHtmlContent();
                msg = msg.replaceAll(MSG_BORD_NUM, this.bord_IdBord);
                msg = msg.replaceAll(MSG_BORD_EXER, this.bord_ExerBord);
                msg = msg.replaceAll(MSG_BORD_TYPE, this.bord_TypBord);
                msg = msg.replaceAll(MSG_PIECE_ID, this.piece_IdPce);
                msg = msg.replaceAll(MSG_LIGNEPIECE_ID, this.lignepiece_Id);
                String path = "@added:primary-key='" + this.bord_ExerBord + "-" + this.bord_TypBord + "-" + this.bord_IdBord + "'";
                String anoId = IdGenerator.nextId();
                String libelleLien = "Bordereau " + this.bord_IdBord + " Titre " + this.piece_IdPce;
                Hashtable<String, String> xslParams = new Hashtable<String, String>();
                xslParams.put("elementId", "");
                xslParams.put("mandatId", this.piece_IdPce);
                xslParams.put("browser-destination", "internal");
                xslParams.put("anoId", anoId);
                Anomalie ano = new Anomalie(anoId, this.getDocumentModel().getControlById(CTRL_ID).getId(), this.getDocumentModel().getControlById(CTRL_ID).getLibelle(), this.getDocumentModel().getDocumentId(), xpath.split("/")[1], "BordereauRecette", this.bord_IdBord, localName, libelleLien, msg + " - Tiers : " + this.lignepiece_Tiers_Nom, this.getDocumentModel().getControlById(CTRL_ID).getRegle().getHtmlContent(), severity, path, xslParams);
                if (this.compteurTiers == 1) {
                    ano.addNode(new Node(this.lignepiece_CpteBancaire_NodeId));
                } else {
                    ano.addNode(new Node(this.lignepiece_NodeId));
                }
                this.anos.add(ano);
            }
            return null;
        }
        if (xpath.endsWith("/PES_RecetteAller/Bordereau/Piece/LigneDePiece/")) {
            if ((this.piece_TypPce.equals("03") || this.piece_TypPce.equals("04")) && !this.vCatTiersNatJur.contains("2007")) {
                String msg = this.getDocumentModel().getControlById(CTRL_ID).getMessage().getHtmlContent();
                msg = msg.replaceAll(MSG_BORD_NUM, this.bord_IdBord);
                msg = msg.replaceAll(MSG_BORD_EXER, this.bord_ExerBord);
                msg = msg.replaceAll(MSG_BORD_TYPE, this.bord_TypBord);
                msg = msg.replaceAll(MSG_PIECE_ID, this.piece_IdPce);
                msg = msg.replaceAll(MSG_LIGNEPIECE_ID, this.lignepiece_Id);
                String path = "@added:primary-key='" + this.bord_ExerBord + "-" + this.bord_TypBord + "-" + this.bord_IdBord + "'";
                String anoId = IdGenerator.nextId();
                String libelleLien = "Bordereau " + this.bord_IdBord + " Titre " + this.piece_IdPce;
                Hashtable<String, String> xslParams = new Hashtable<String, String>();
                xslParams.put("elementId", "");
                xslParams.put("mandatId", this.piece_IdPce);
                xslParams.put("browser-destination", "internal");
                xslParams.put("anoId", anoId);
                Anomalie ano = new Anomalie(anoId, this.getDocumentModel().getControlById(CTRL_ID).getId(), this.getDocumentModel().getControlById(CTRL_ID).getLibelle(), this.getDocumentModel().getDocumentId(), xpath.split("/")[1], "BordereauRecette", this.bord_IdBord, localName, libelleLien, msg + " (NON BLOQUANT)", this.getDocumentModel().getControlById(CTRL_ID).getRegle().getHtmlContent(), severity, path, xslParams);
                ano.addNode(new Node(this.lignepiece_NodeId));
                this.anos.add(ano);
            }
            return null;
        }
        if (xpath.endsWith("/PES_RecetteAller/Bordereau/Piece/")) {
            return this.anos;
        }
        return null;
    }

    public void endDocument() throws SAXException {
    }

    public void characters(char[] ch, int start, int length, String xpath) {
    }

    public void ignorableWhitespace(char[] ch, int start, int length, String xpath) {
    }

    public void startPrefixMapping(String prefix, String uri, String xpath) {
    }

    public void endPrefixMapping(String prefix, String xpath) {
    }

    public void processingInstruction(String target, String data, String xpath) {
    }

    public void skippedEntity(String name, String xpath) {
    }

    public void setParameters(Hashtable<String, Object> params) {
        this.hParams = params;
    }

    public void setDocumentLocator(Locator locator) {
    }
}

