/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.controls.pesv2.rec;

import fr.gouv.finances.cp.xemelios.controls.AbstractUnitControl;
import fr.gouv.finances.cp.xemelios.controls.Anomalie;
import fr.gouv.finances.cp.xemelios.controls.IdGenerator;
import fr.gouv.finances.cp.xemelios.controls.Node;
import fr.gouv.finances.cp.xemelios.controls.pesv2.ConstantsControlsPESv2;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class REC20
extends AbstractUnitControl
implements ConstantsControlsPESv2 {
    private static final Logger logger = Logger.getLogger(REC20.class);
    public static final transient String CTRL_ID = "REC20";
    private Vector<Anomalie> anos = new Vector();
    private Hashtable<String, Object> hParams;
    private String docId = null;
    private String bord_nodeId = null;
    private String ligne_nodeId = null;
    private Vector<Node> anonodes = new Vector();
    private static final String FIN_PIECE = "/PES_RecetteAller/Bordereau/Piece/";
    private static final String ON_RETURN_ANOMALIES = "/PES_RecetteAller/Bordereau/Piece/";
    private static final String FIN_LIGNE = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/";
    private String bord_Exer = "";
    private String bord_IdBord = "";
    private String bord_TypBord = "";
    private String piece_IdPce = "";
    private String ligne_IdLigne = "";
    private String typTiers_nodeid = "";
    private Vector<Couple> typTiers = new Vector();
    private String codAssDeb = "";
    private static final String MSG_BORD_NUM = "#BORD_NUM#";
    private static final String MSG_BORD_EXER = "#BORD_EXER#";
    private static final String MSG_BORD_TYPBORD = "#BORD_TYPBORD#";
    private static final String MSG_PIECE_IDPCE = "#PIECE_IDPCE#";
    private static final String MSG_LIGNE_IDLIGNE = "#LIGNE_IDLIGNE#";
    private static final String CHEMIN_BLOCBORDEREAU = "/PES_RecetteAller/Bordereau/BlocBordereau/";
    private static final String CHEMIN_BLOCBORDEREAU_EXER = "/PES_RecetteAller/Bordereau/BlocBordereau/Exer/";
    private static final String CHEMIN_BLOCBORDEREAU_IDBORD = "/PES_RecetteAller/Bordereau/BlocBordereau/IdBord/";
    private static final String CHEMIN_BLOCBORDEREAU_TYPBORD = "/PES_RecetteAller/Bordereau/BlocBordereau/TypBord/";
    private static final String CHEMIN_BLOCPIECE = "/PES_RecetteAller/Bordereau/Piece/BlocPiece/";
    private static final String CHEMIN_BLOCPIECE_IDPCE = "/PES_RecetteAller/Bordereau/Piece/BlocPiece/IdPce/";
    private static final String CHEMIN_INFOLIGNEPIECE = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePiece/";
    private static final String CHEMIN_INFOLIGNEPIECE_IDLIGNE = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoLignePiece/IdLigne/";
    private static final String CHEMIN_TIERS = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/Tiers/InfoTiers/";
    private static final String CHEMIN_TIERS_TYPTIERS = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/Tiers/InfoTiers/TypTiers/";
    private static final String CHEMIN_INFOASSURE_CODASSDEB = "/PES_RecetteAller/Bordereau/Piece/LigneDePiece/BlocLignePiece/InfoAssure/CodAssDeb/";

    public void startDocument() throws SAXException {
        logger.info((Object)"In REC20");
    }

    public void setDocId(String docID) {
        this.docId = docID;
    }

    public void startElement(String uri, String localName, String qName, Attributes atts, String xpath) {
        if (xpath.endsWith(CHEMIN_BLOCBORDEREAU)) {
            this.bord_TypBord = "";
            this.bord_IdBord = "";
            this.bord_Exer = "";
            this.bord_nodeId = atts.getValue("ano:node-id");
        }
        if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_EXER)) {
            this.bord_Exer = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_IDBORD)) {
            this.bord_IdBord = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_BLOCBORDEREAU_TYPBORD)) {
            this.bord_TypBord = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_BLOCPIECE)) {
            this.anos = new Vector();
            this.anonodes = new Vector();
            this.piece_IdPce = "";
        }
        if (xpath.endsWith(CHEMIN_BLOCPIECE_IDPCE)) {
            this.piece_IdPce = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_INFOLIGNEPIECE)) {
            this.codAssDeb = "";
            this.ligne_IdLigne = "";
            this.typTiers = new Vector();
            this.ligne_nodeId = atts.getValue("ano:node-id");
        }
        if (xpath.endsWith(CHEMIN_INFOLIGNEPIECE_IDLIGNE)) {
            this.ligne_IdLigne = atts.getValue("V");
        }
        if (xpath.endsWith(CHEMIN_TIERS)) {
            this.typTiers_nodeid = atts.getValue("ano:node-id");
        }
        if (xpath.endsWith(CHEMIN_TIERS_TYPTIERS)) {
            this.typTiers.add(new Couple(atts.getValue("V"), this.typTiers_nodeid));
        }
        if (xpath.endsWith(CHEMIN_INFOASSURE_CODASSDEB)) {
            this.codAssDeb = atts.getValue("V");
        }
    }

    public Vector<Anomalie> endElement(String uri, String localName, String qName, String xpath) throws SAXException {
        if (xpath.endsWith(FIN_LIGNE)) {
            Vector<Node> tmp = new Vector<Node>();
            boolean err = true;
            for (Couple c : this.typTiers) {
                if ("01".equals(c.getTypTiers()) || "07".equals(c.getTypTiers()) && "1".equals(this.codAssDeb)) {
                    err = false;
                    continue;
                }
                tmp.add(new Node(c.getTypTiers_nodeid()));
            }
            if (err) {
                this.anonodes.addAll(tmp);
            }
            return null;
        }
        if (xpath.endsWith("/PES_RecetteAller/Bordereau/Piece/")) {
            if (this.anonodes.size() > 0) {
                String msg = this.getDocumentModel().getControlById(CTRL_ID).getMessage().getHtmlContent();
                msg = msg.replaceAll(MSG_BORD_NUM, this.bord_IdBord);
                msg = msg.replaceAll(MSG_BORD_EXER, this.bord_Exer);
                msg = msg.replaceAll(MSG_BORD_TYPBORD, this.bord_TypBord);
                msg = msg.replaceAll(MSG_PIECE_IDPCE, this.piece_IdPce);
                msg = msg.replaceAll(MSG_LIGNE_IDLIGNE, this.ligne_IdLigne);
                String path = "@added:primary-key='" + this.bord_Exer + "-" + this.bord_TypBord + "-" + this.bord_IdBord + "'";
                String anoId = IdGenerator.nextId();
                String libelleLien = "Bordereau " + this.bord_IdBord + " Mandat " + this.piece_IdPce;
                Hashtable<String, String> xslParams = new Hashtable<String, String>();
                xslParams.put("elementId", "");
                xslParams.put("mandatId", this.piece_IdPce);
                xslParams.put("browser-destination", "internal");
                xslParams.put("anoId", anoId);
                Anomalie ano = new Anomalie(anoId, this.getDocumentModel().getControlById(CTRL_ID).getId(), this.getDocumentModel().getControlById(CTRL_ID).getLibelle(), this.getDocumentModel().getDocumentId(), xpath.split("/")[1], "BordereauRecette", this.bord_IdBord, localName, libelleLien, msg, this.getDocumentModel().getControlById(CTRL_ID).getRegle().getHtmlContent(), this.getDocumentModel().getControlById(CTRL_ID).getSeverity(), path, xslParams);
                ano.addAll(this.anonodes);
                this.anos.add(ano);
            }
            return this.anos;
        }
        return null;
    }

    public void endDocument() throws SAXException {
    }

    public void characters(char[] ch, int start, int length, String xpath) {
    }

    public void ignorableWhitespace(char[] ch, int start, int length, String xpath) {
    }

    public void startPrefixMapping(String prefix, String uri, String xpath) {
    }

    public void endPrefixMapping(String prefix, String xpath) {
    }

    public void processingInstruction(String target, String data, String xpath) {
    }

    public void skippedEntity(String name, String xpath) {
    }

    public void setParameters(Hashtable<String, Object> params) {
        this.hParams = params;
    }

    public void setDocumentLocator(Locator locator) {
    }

    private class Couple {
        String typTiers = "";
        String typTiers_nodeid = "";

        public Couple(String tt, String ttni) {
            this.typTiers = tt;
            this.typTiers_nodeid = ttni;
        }

        public String getTypTiers() {
            return this.typTiers;
        }

        public void setTypTiers(String typTiers) {
            this.typTiers = typTiers;
        }

        public String getTypTiers_nodeid() {
            return this.typTiers_nodeid;
        }

        public void setTypTiers_nodeid(String typTiers_nodeid) {
            this.typTiers_nodeid = typTiers_nodeid;
        }
    }
}

